#                       #
# header/sunet-spec.tcl #
#########################


#############################################################################
#                                                                           #
# This file contains a special check. When the Subject of a message starts  #
# with a colon, conversion is prohibited. This is a simple method for non   #
# MIME mailers to specify content conversion prohibited.                    #
#                                                                           #
#############################################################################


proc check_sunet_passthru {} {
	if {[is_root]} {
		if {[set SUBJ [getheader "Subject"]] != 0} {
			if {[llength $SUBJ] != 0} {
				set FSUBJ [lindex $SUBJ 0]
				if {[string index $FSUBJ 0] == ":"} {
debug "sunet-spec: Subject starting with colon: dotunnel"
					dotunnel
				}
			}
		}
	}
}
check_sunet_passthru


			
