/*
 *
 * Copyright (C) 1993 Swedish University Network (SUNET)
 *
 *
 * This program is developed by UDAC, Uppsala University by commission
 * of the Swedish University Network (SUNET). 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *                                          Martin.Wendel@udac.uu.se
 *
 *                                          Martin Wendel
 *                                          UDAC	
 *                                          Box 174
 *                                          S-751 04 Uppsala
 *                                          Sweden
 */






#include "mk.h"
#ifdef EMILDEBUG

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include <time.h>
char MkDate[28];
static bool MkLogOpened = FALSE;

#ifdef __STDC__ 
Mk_Log(int level, const char *frmt, ...)
#else 
Mk_Log(level, frmt, va_alist)
int level;
const char *frmt;
va_dcl
#endif /* __STDC__ */

{
  va_list args;
  char buf[1024];
  FILE *logfile;
  if (level <= EMILLOGLEVEL) {
    bzero(buf, 1024);
#ifdef __STDC__
    va_start(args, frmt);
#else
    va_start(args);
#endif /* __STDC */

    Mk_SetDate();
#ifdef SENDMAIL
#ifdef SENDMAIL_8
    sprintf(buf, "%s Mk_Debug: ", MkDate);
#else
    sprintf(buf, "%s Mk_Debug: %s: ", MkDate, CurEnv->e_id);
#endif /* SENDMAIL_8 */
#else
    sprintf(buf, "%s Mk_Debug: ", MkDate);
#endif
    vsprintf(&buf[strlen(buf)], frmt, args);
    strcat(buf, "\n");
#ifdef SENDMAIL
    if (level <= LOG_ERR)
      syslog(LOG_NOTICE, buf);
#endif    
    if ((logfile = fopen(EmilLogFile, "a")) == NULL) {
      return(0);
    }
    
    fprintf(logfile, "%s", buf);
    fflush(logfile);
    fclose(logfile);
  }
}


Mk_SetDate()
{
  time_t clock;
  
  (void) time(&clock);
  strftime(MkDate, 28, "%h %d %T", localtime(&clock));
}

#endif

int
log_messagebuf()
{
  Mk_Log(LOG_DEBUG, "New messagebuf log");
  if (MkMess_Curr->header)
    Mk_Log(LOG_DEBUG, "messagebuf has headers");
  Mk_Log(LOG_DEBUG, "start_line %i end_line %i", MkMess_Curr->start_line,
	 MkMess_Curr->end_line);
  Mk_Log(LOG_DEBUG, "MainType: %s Encoding: %s", MkMess_Curr->maintype,
	 MkMess_Curr->encoding);

}
