/*
 *
 * Copyright (C) 1993 Swedish University Network (SUNET)
 *
 *
 * This program is developed by UDAC, Uppsala University by commission
 * of the Swedish University Network (SUNET). 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *                                          Martin.Wendel@udac.uu.se
 *
 *                                          Martin Wendel
 *                                          UDAC	
 *                                          Box 174
 *                                          S-751 04 Uppsala
 *                                          Sweden
 */






#include "mk.h"
#ifdef SENDMAIL

HDR *Mk_CopyHdr();



mkcollqueueup()
{
  FILE *mfp;
  char *p;
  if (!MkMess_Curr->end_line)
    MkMess_Curr->end_line = linecount;
  MkMess_Buf->fconv = NULL;
  p = queuename(CurEnv, 'm');
  CurEnv->e_mf = newstr(p);
  if ((mfp = fopen(CurEnv->e_mf, "w")) == NULL)
    {
      Mk_Log(LOG_ERR, "mkcollqueueup: Cannot create %s ...using transparent mode.", 
	     CurEnv->e_mf);
      MkMess_Root->dotunnel = TRUE;
    }
  else
    {
      mkqueueup(mfp, MkMess_Root);
      fflush(mfp);
      (void) fclose(mfp);
    }
}



HDR *
Mk_CopyHdr(inhdr)
HDR *inhdr;
{
  HDR *outhdr;
  if (inhdr == NULL)
    return(NULL);
  else
    {
      outhdr = (HDR *)xalloc(sizeof(HDR));
      if (inhdr->h_field && *(inhdr->h_field))
	outhdr->h_field = newstr(inhdr->h_field);
      if (inhdr->h_value && *(inhdr->h_value))
	outhdr->h_value = newstr(inhdr->h_value);
      outhdr->h_flags = inhdr->h_flags;
      bcopy(inhdr->h_mflags, outhdr->h_mflags, sizeof(inhdr->h_mflags));
      outhdr->h_link = (HDR *)Mk_CopyHdr(inhdr->h_link);
      return(outhdr);
    }
}



  


#endif /* SENDMAIL */
