/*
 * mail.c: Ok, so I gave in.  I added mail checking.  So sue me. 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef lint
static	char	rcsid[] = "@(#)$Id: mail.c,v 1.21.2.2 1996/07/20 19:14:42 mrg Exp $";
#endif

#include "irc.h"
#include "newio.h"

#ifdef NeXT		/* ugly hack 'cause configure don't grok it -phone */
# ifndef NAME_MAX
#  define NAME_MAX 1024
# endif
# define SYSDIR
#endif

#if defined(HAVE_DIRENT_H) || defined(_POSIX_SOURCE)
# include <dirent.h>
# define NLENGTH(d) (strlen((d)->d_name)
#else /* DIRENT || _POSIX_SOURCE */
# define dirent direct
# define NLENGTH(d) ((d)->d_namlen)
# ifdef HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif /* HAVE_SYS_NDIR_H */
# ifdef HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif /* HAVE_SYS_DIR_H */
# ifdef HAVE_NDIR_H
#  include <ndir.h>
# endif /* HAVE_NDIR_H */
#endif /* HAVE_DIRENT_H || _POSIX_VERSION */

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif /* HAVE_FCNTL_H */

#ifdef ESIX
# include <lan/net_types.h>
#endif /* !ESIX */

/* #if (defined(ISC) || defined(POSIX) || defined (UNICOS)) && !defined(_IBMR2) */
#ifdef HAVE_SYS_FCNTL_H
# include <sys/fcntl.h>
#endif /* HAVE_SYS_FCNTL_H */

#include <sys/stat.h>

#include "mail.h"
#include "lastlog.h"
#include "hook.h"
#include "vars.h"
#include "ircaux.h"
#include "output.h"
#include "window.h"

static	char	*mail_path = (char *) 0;

static	void	init_mail _((void));

/* init_mail: this initialized the path to the users mailbox */
static	void
init_mail()
{
	char	*tmp_mail_path;

	if (mail_path)
		return; /* why do it 2000 times?  -lynx */

#ifdef UNIX_MAIL
	if ((tmp_mail_path = getenv("MAIL")) != NULL)
		strmcpy(buffer, tmp_mail_path, BIG_BUFFER_SIZE);
				/*then use it - Goodi */
	else
	{
		strmcpy(buffer, UNIX_MAIL, BIG_BUFFER_SIZE);
		strmcat(buffer, "/", BIG_BUFFER_SIZE);
		strmcat(buffer, username, BIG_BUFFER_SIZE);
	}
	malloc_strcpy(&mail_path, buffer);
#else
# ifdef AMS_MAIL
	strmcpy(buffer, my_path, BIG_BUFFER_SIZE);
	strmcat(buffer, "/", BIG_BUFFER_SIZE);
	strmcat(buffer, AMS_MAIL, BIG_BUFFER_SIZE);
	malloc_strcpy(&mail_path, buffer);
# endif /* AMS_MAIL */
#endif /* UNIX_MAIL */
}

#ifdef AMS_MAIL
/*
 * count_files: counts all the visible files in the specified directory and
 * returns that number as the function value 
 */
static	u_int
count_files(dir_name, lasttime)
	char	*dir_name;
	time_t	lasttime;
{
	DIR	*dir;
	struct	direct	*dirbuf;
	unsigned int	cnt;
	int	fd;
	char	LetterName[BIG_BUFFER_SIZE+1];
	struct	stat	LetterInfo;
	static	int	VirginProgram = 1;
	int	lastlog_level;

	if ((dir = opendir(dir_name)) == (DIR *) 0)
		return (0);
	cnt = 0;
	lastlog_level = set_lastlog_msg_level(LOG_CRAP);
	message_from((char *) 0, LOG_CURRENT);		/* XXX should delete this */
	while ((dirbuf = readdir(dir)) != (struct direct *) 0)
	{
		if (*(dirbuf->d_name) != '.')
		{
			cnt++;
			sprintf(LetterName, "%s/%s", dir_name, dirbuf->d_name);
			stat_file(LetterName, &LetterInfo);
			if (get_int_var(MAIL_VAR) == 2 && LetterInfo.st_ctime>lasttime && !VirginProgram)
			{
				if ((fd = open(LetterName, O_RDONLY)) == -1)
					say("Unable to check headers on new mail");
				else
				{
					while (dgets(LetterName,BIG_BUFFER_SIZE, fd, (char *) 0) > 0 && *LetterName != '\n' &&
					    *LetterName != '\0')
					{
						LetterName[strlen(LetterName) - - 1] = '\0';
						if (!strncmp(LetterName, "From", 4) || !strncmp(LetterName, "Subject:", 8))
							say("%s", LetterName);
					}
					new_close(fd);
				}
			}
		}
	}
end:
	VirginProgram = 0;
	closedir(dir);
	set_lastlog_msg_level(lastlog_level);
	return (cnt);
}
#endif /* AMS_MAIL */

/*
 * check_mail_status: returns 0 if mail status has not changed, 1 if mail
 * status has changed 
 */
int
check_mail_status()
{

#if defined(AMS_MAIL) || defined(UNIX_MAIL)
	struct	stat	stat_buf;
	static	time_t	old_stat = 0L;

#ifdef DAEMON_UID
	if (getuid() == DAEMON_UID)
		return 0;
#endif /*DAEMON_UID*/

	if (!get_int_var(MAIL_VAR))
	{
		old_stat = 0L;
		return (0);
	}
	init_mail();
	if (stat_file(mail_path, &stat_buf) == -1)
		return (0);
	if (stat_buf.st_ctime > old_stat)
	{
		old_stat = stat_buf.st_ctime;
		return (1);
	}
#endif /* defined(AMS_MAIL) || defined(UNIX_MAIL) */
	return (0);
}

/*
 * check_mail: This here thing counts up the number of pieces of mail and
 * returns it as static string.  If there are no mail messages, null is
 * returned. 
 */
char	*
check_mail()
{
#if !defined(AMS_MAIL) && !defined(UNIX_MAIL)
	return	(char *) 0;
#else
	static	unsigned int	cnt = 0;
	static	time_t	old_stat = 0L;
	static	char	ret_str[8];
	struct	stat	stat_buf;
	unsigned int	new_cnt = 0;
	char	tmp[8];
	static	int	VirginProgram = 1;  /* It's its first time */
	int	lastlog_level;
#ifdef UNIX_MAIL
	int	des;
	int	blanks = 1;
	int	reset_blanks = 0;
#endif /* UNIX_MAIL */

#ifdef DAEMON_UID
	if (getuid()==DAEMON_UID)
		return ((char *) 0);
#endif

	init_mail();
#ifdef UNIX_MAIL
	if (stat_file(mail_path, &stat_buf) == -1)
		return ((char *) 0);
	lastlog_level = set_lastlog_msg_level(LOG_CRAP);
	message_from((char *) 0, LOG_CURRENT);		/* XXX should delete this */
	if (stat_buf.st_ctime > old_stat)
	{
		old_stat = stat_buf.st_ctime;
		if ((des = open(mail_path, O_RDONLY, 0)) >= 0)
		{
			new_cnt = 0;
			while (dgets(buffer, BIG_BUFFER_SIZE, des,(char *) 0)>0)
			{
				if (buffer[0] == '\n') {
					blanks++;
					continue;
				}
				else
					reset_blanks = 1;
				if (!strncmp(MAIL_DELIMITER, buffer, sizeof(MAIL_DELIMITER) - 1) && blanks)
				{
					new_cnt++;
					if (new_cnt > cnt && !VirginProgram && get_int_var(MAIL_VAR) == 2)
					{
						while (dgets(buffer, BIG_BUFFER_SIZE, des, (char *) 0) > 0 && *buffer != '\0' && *buffer != '\n')
						{
							buffer[strlen(buffer)-1] = '\0';
							if (!strncmp(buffer, "From:", 5) || !strncmp(buffer, "Subject:", 8))
								say("%s", buffer);
						}
					}
				}
				if (reset_blanks)
					reset_blanks = blanks = 0;
			}
			VirginProgram=0;
			new_close(des);
		}
#else
# ifdef AMS_MAIL
		if (stat_file(mail_path, &stat_buf) == -1)
		{
			set_lastlog_msg_level(lastlog_level);
			return ((char *) 0);
		}
		if (stat_buf.st_ctime > old_stat)
		{
			new_cnt = count_files(mail_path, old_stat);
			old_stat = stat_buf.st_ctime;
		}
# endif /* AMS_MAIL */
#endif /* UNIX_MAIL */
		/* yeeeeack */
		sprintf(tmp, "%d", new_cnt - cnt);
		sprintf(buffer, "%d", new_cnt);
		if (new_cnt > cnt)
		{
			if (do_hook(MAIL_LIST, "%s %s", tmp, buffer) && get_int_var(MAIL_VAR) == 1)
				say("You have new email.");
		}
		cnt = new_cnt;
	}
	set_lastlog_msg_level(lastlog_level);
	if (cnt && (cnt < 65536))
	{
		sprintf(ret_str, "%d", cnt);
		return (ret_str);
	}
	else
		return ((char *) 0);
#endif /* !defined(AMS_MAIL) && !defined(UNIX_MAIL) */
}
