/* Copyright (c) 1992 Vincent Cate
 * All Rights Reserved.
 *
 * Permission to use and modify this software and its documentation
 * is hereby granted, provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative works
 * or modified versions, and any portions thereof, and that both notices
 * appear in supporting documentation.  This software or any derivate works
 * may not be sold or distributed without prior written approval from
 * Vincent Cate.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND VINCENT CATE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL
 * VINCENT CATE BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Users of this software agree to return to Vincent Cate any improvements
 * or extensions that they make and grant Vincent Cate the rights to
 * redistribute these changes.
 *
 */




/* UNFSD - copyright Mark A Shand, May 1988.
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 * Modified extensively by Vince Cate.
 */

#include "alexincs.h"
#include "alex.h"
#include "unfsd.h"
#include "fh.h"


static FILE *StreamFromAlex=NULL;
static FILE *StreamToAlex=NULL;

static struct timeval TIMEOUT = { 25, 0 }; /* Unused for now, eventually for
                          deciding when cached items are old. */


#define ROOT_UID    0   /* Root's user id. */
#define NOBODY_UID  110 /* The Unprivileged User */
#define NOBODY_GID  31  /* The Unprivileged Group */

/* ====================================================================== */

FILE *debugLog = NULL;
static char argbuf[1024];


extern LogUnfsdReal(level, name, arg, rqstp)
int     level;
char    *name;
char    *arg;
struct svc_req  *rqstp;
{
    struct authunix_parms *unix_cred;
    struct tm *tm;
    int i;

    if (level>DEBUGLEVEL) {
        return;                                             /* nothing to output */
    }
   
    if (rqstp == NULL) {
        ToLog(level, "%s %s \n", name, arg);
    } else {
        ToLog(level, "%s [%d ", name, rqstp->rq_cred.oa_flavor);
        if (rqstp->rq_cred.oa_flavor == AUTH_UNIX) {
            unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;
            tm = localtime((time_t *) &unix_cred->aup_time);
            ToLog(level, "%d/%d/%d %02d:%02d:%02d %s %d.%d",
                tm->tm_mon+1, tm->tm_mday, tm->tm_year,
                tm->tm_hour, tm->tm_min, tm->tm_sec,
                unix_cred->aup_machname,
                unix_cred->aup_uid,
                unix_cred->aup_gid);
            if (unix_cred->aup_len > 0) {
                ToLog(level, "+%d", unix_cred->aup_gids[0]);
                for (i = 1; i < unix_cred->aup_len; i++) {
                    ToLog(level, ",%d",unix_cred->aup_gids[i]);
                }
            }
        }
        ToLog(level, "]\n\t %s \n", arg);
    }
}


/* ====================================================================== */

extern int errno;

/* ====================================================================== */


/* we use arguments when it is not clear any are passed in XXXXX */

void * nfsproc_null_2(argp, rqstp)
void *argp;
struct svc_req *rqstp;
{
    static char res;

    bzero(&res, sizeof(res));
    LogUnfsd("nfsproc_null", "", rqstp);
    return ((void *)&res);
}




char *RequestToUidStr(rqstp)
struct svc_req *rqstp;
{
    struct authunix_parms *unix_cred;
    char *MachineName;
    int Uid;
    char *UidStr;

    unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;
    Uid = unix_cred->aup_uid;
    MachineName = unix_cred->aup_machname;      /* for some remote places this is not full XXXX */
                                                /* this can cause problems at some FTP sites */

    UidStr= UidToUidStr(Uid, MachineName);

    (void) strcpy(LastUidStr, UidStr);

/*    Log2("RequestToUidStr ", UidStr); */

    return(UidStr);
}

int inner_getattr(fh, status, attr, rqstp, RecursionOk)
nfs_fh      *fh;
nfsstat     *status;
fattr       *attr;
struct svc_req *rqstp;
int         RecursionOk;
{
    struct stat mysbuf;
    struct stat *sptr;
    char   *path, *UidStr;
    int    Status;
    struct ParsedDir Current;
    
   
    Log("inner_getattr  ");

    path = "inner_getattr";
    Status = fh_path(fh, status, &path);
    if (Status != AOK) {       
        LogT("inner_getattr failed returning ", Status);
        return(Status);
    }

    Log2("inner_getattr ", path);

    UidStr=RequestToUidStr(rqstp);

    Status=AlexInfoCompatStat(path, &mysbuf, &Current, UidStr, RecursionOk);
    if ((Status == AWORKING) || (Status == AUPDATE) || (Status == ARETRY)) {
        return(Status);
    }

    if (Status != AOK) { 
        *status = (nfsstat) NFSERR_NOENT;
        ToLog(10, "inner_getattr NOSUCHFILE path='%s' errno=%d\n", path, errno);
        LogT("inner_getattr returning ", Status);
        return(Status);
    }


    *status = (nfsstat) NFS_OK; 
    sptr = &mysbuf;
    
    attr->type = ft_map[ft_extr(sptr->st_mode)];
    attr->mode = sptr->st_mode;
    attr->nlink = sptr->st_nlink;
    attr->uid = ALEXUIDVAR;                   /* wanted alex but is alexsrvr*/
    attr->gid = ALEXGIDVAR;                   /* */
    attr->size = sptr->st_size;
    attr->blocksize = sptr->st_blksize;
    attr->rdev = sptr->st_rdev;
    attr->blocks = sptr->st_blocks;
    attr->fsid = 1;
    attr->fileid = (unsigned int) sptr->st_ino;
   
    LogN(path, (int) attr->fileid);

    attr->atime.seconds = sptr->st_atime;
    attr->atime.useconds = 0;
    attr->mtime.seconds = sptr->st_mtime;
    attr->mtime.useconds = 0;
    attr->ctime.seconds = sptr->st_ctime;
    attr->ctime.useconds = 0;

    if (*status != NFS_OK) {
        errno= (int) *status;
        error1("inner_getattr ERROR ");
    } else {
        ToLog(10, " t=%d, m=%u, lk=%u, u/g=%u/%u, sz=%u, bsz=%u \n",
                            attr->type, attr->mode, attr->nlink,
                            attr->uid, attr->gid, attr->size, attr->blocksize);

        if (attr->type == NFCHR || attr->type == NFBLK) {
            ToLog(10, " rdev=%u/%u", (attr->rdev>>8)&0xff, attr->rdev&0xff);
            ToLog(10, "\n  blks=%u, fsid=%u, inode=%u, at=%u, mt=%u, ct=%u\n",
                attr->blocks, attr->fsid, attr->fileid, attr->atime.seconds,
                attr->mtime.seconds, attr->ctime.seconds);
        }
    }

    if (Current.Stale) {                      /* got it but stale */
        return(AUPDATE);
    }

    return(AOK);
}


attrstat * nfsproc_getattr_2(argp, rqstp)
nfs_fh *argp;
struct svc_req *rqstp;
{
    static attrstat res;
    int Status, i;

    Log("\n nfsproc_getattr_2 starting \n");
    bzero( (char *) &res, sizeof(res));

    if (knownclient(rqstp) == NULL) {
        res.status = NFSERR_ACCES;
        return (&res);
    }

    LogUnfsdReal(DBRPC, "\n nfsproc_getattr_2", fh_pr(argp), rqstp);

    Status=ARETRY;
    for (i=0; i<2 && Status == ARETRY; i++) {
        Status=inner_getattr(argp, &(res.status), &(res.attrstat_u.attributes), rqstp, 1);
        if (Status != AWORKING && Status != AOK && Status != NOSUCHFILE) { 
            Status=MakeItSoGetAttr(argp, rqstp);
        }
    }

    LogT("nfsproc_getattr_2 done ", Status);
    Log(" ");

    if (Status==AWORKING) {
        ToLog(DBPERF, "nfsproc_getattr_2 DROPPING \n");
        return(NULL);
    } else {
        if (Status != AOK) {
            ToLog(DBRPC, "nfsproc_getattr_2 returning NFSERR_IO\n");
            res.status = NFSERR_IO;
        }
        return(&res);
    }
}


attrstat * nfsproc_setattr_2(argp, rqstp)
sattrargs *argp;
struct svc_req *rqstp;
{
    static attrstat res;

    bzero( (char *) &res, sizeof(res));
    LogUnfsdReal(DBRPC, "nfsproc_setattr", "", rqstp);

    res.status = NFSERR_ROFS;

    return (&res);
}


/* arguments used when probably none passed in XXXXXXXX */
void * nfsproc_root_2(argp, rqstp)
void *argp;
struct svc_req *rqstp;
{
    static char res;

    bzero( (char *) &res, sizeof(res));
    LogUnfsdReal(DBRPC, "nfsproc_root", "", rqstp);

    return ((void *)&res);
}




int CallAlex(Path, rqstp)
char *Path;
struct svc_req *rqstp;
{
    char *UidStr;
    int Status, Result;

    LogUnfsd("CallAlex", Path, rqstp);

    UidStr=RequestToUidStr(rqstp);

    Result=CheckFileCache(Path, UidStr);        

    Status=fh_fdclose();                /* XXXX don't really always need this */
    if (Status != AOK) {
        LogT("CallAlex ERROR could not close fd ", Status);
    }

    LogT("CallAlex returning", Result);
    return(Result);
}


int MakeItSoGetAttr(argp, rqstp)
nfs_fh *argp;
struct svc_req *rqstp;
{
    char Path[MAXPATH], *PtrPath;
    nfsstat status;
    int Result;

    Log("\nMakeItSoGetAttr entering ");

    Result = fh_path(argp, &status, &PtrPath);

    if (Result != AOK) {
        LogT("MakeItSoGetAttr failing ", Result);
    } else {
        PathToDir(PtrPath, Path);      
        LogUnfsd("MakeItSoGetAttr ", Path, rqstp);
        Result=CallAlex(Path, rqstp);
    }

    LogT("MakeItSoGetAttr done", Result);
    return(Result);
}


/* 
 *  *COMMENT NOT VALID*
 *    On input:                             Call Alex with:
 *  /alex/foo/bar + .                     /alex/foo
 *  /alex/foo/bar + ..                    /alex
 *  /alex/foo/bar + baz                   /alex/foo/bar
 *  /alex/foo/bar + baz + UseNameToo      /alex/foo/bar/baz
 */

int MakeItSoLookup(argp, rqstp, UseNameToo)
diropargs *argp;
struct svc_req *rqstp;
int UseNameToo;
{
    char Tmp[MAXPATH], Path[MAXPATH], *PtrPath;
    nfsstat status;
    int Result;

    LogN("\nMakeItSoLookup entering ", UseNameToo);

    Result = fh_path(&(argp->dir), &status, &PtrPath);

    if (Result != AOK) {
        LogT("MakeItSoLookup failing ", Result);
    } else {
/*       if (streql(argp->name, "..")) {
 *           PathToDir(PtrPath, Tmp);
 *           PathToDir(Tmp, Path);
 *       } else if (streql(argp->name, ".")) { 
 *           PathToDir(PtrPath, Path);
 *       } else {
 *           (void) strcpy(Path, PtrPath);      
 *           if (UseNameToo) {
 *               strcat(Path, "/");
 *               strcat(Path, argp->name);
 *           }
 *       }
 */
        (void) strcpy(Path, PtrPath);
        if (UseNameToo) {
            (void) strcat(Path, "/");
            (void) strcat(Path, argp->name);    /* may be . or .. */
        }

        LogUnfsd("MakeItSoLookup ", Path, rqstp);
        Result=CallAlex(Path, rqstp);
    }


    LogT("MakeItSoLookup done", Result);
    return(Result);
}


int MakeItSoReadDir(argp, rqstp, ForceCheck)
readdirargs *argp;
struct svc_req *rqstp;
int ForceCheck;
{
    char Path[MAXPATH], *PtrPath;
    static char LastFile[MAXPATH];
    static int  LastResult;
    nfsstat status;
    int Result, Status;

    Log("\nMakeItSoReadDir entering");

    Status = fh_path(&(argp->dir), &status, &PtrPath);

    if (Status != AOK) {       
        LogT("MakeItSoReadDir failing ", Status);
        return(Status);
    }

    if (ForceCheck || (LastResult == AWORKING) || !streql(LastFile, PtrPath)) {
        if (Status == AWORKING) {
            Result=Status;                                    /* fh_path already called alex */
        } else {
            (void) strcpy(LastFile, PtrPath);
            (void) strcpy(Path, PtrPath);
            LogUnfsd("MakeItSoReadDir ", Path , rqstp);
            SimplifyPath(Path);                             
            CountDiffFiles(Path, ADIR);                     /* MustCallAlex at least on first time */
            Result=CallAlex(Path, rqstp);                         
        }
    } else {
        Result=LastResult;                                    /* just did that */
    }

    LastResult=Result;

    LogT("MakeItSoReadDir done ", Result);
    return(Result);
}

int BigEnough(Path, NeededSize)
char *Path;
int NeededSize;
{
    int Size;

    Size=SizeOfCachedFile(Path);
       
    ToLog(DBALL, "\nBigEnough  Size= %d  NeededSize= %d  %s", Size, NeededSize, Path);

    if (Size > NeededSize) {
        return(1);
    } else {
        return(0);
    }
}


#define DIFFCACHESIZE 10

/* Note that this is not called on every read, just ones that cause us to go to ChecFileCache */
CountDiffFiles(Path, Type)
char *Path;
int  Type;                     /* AFILE, ADIR, ALINK */
{
    int i, AlreadySeenIt;
    static int  NextIndex=0;                            /* where next will go */
    static char DiffFilesCache[DIFFCACHESIZE][MAXPATH];
    static int  NumInCache=0;
    
    AlreadySeenIt=0;
    for (i=0; !AlreadySeenIt && i<DIFFCACHESIZE && i<NumInCache; i++) {
        if (streql(DiffFilesCache[i], Path)) {
           AlreadySeenIt=1;
        }
    }
   
    if (!AlreadySeenIt) {
        (void) strcpy(DiffFilesCache[NextIndex], Path);
        NextIndex = (NextIndex + 1) % DIFFCACHESIZE;
        switch (Type) {
            case AFILE: TotalFilesNFSed++;
                        break;

            case ADIR:  TotalDirsNFSed++;
                        break;

            default:    break;                   /* ALINK */
        }
        if (NumInCache < DIFFCACHESIZE) {
            NumInCache++;
        }
    }
}


/* We always call CallAlex() at least once for each filename before using
 */
int MakeItSoRead(argp, rqstp, Type, EndOffset, ForceCheck)
nfs_fh *argp;
struct svc_req *rqstp;
int Type, EndOffset, ForceCheck;
{
    char Path[MAXPATH], *PtrPath;
    static char LastFile[MAXPATH];             
    static int  LastResult;
    nfsstat status;
    int Result, Status, MustCallAlex;

    Status = fh_path(argp, &status, &PtrPath);
    
    if (Status != AOK) {
        LogT("MakeItSoRead returning ", Status);
        return(Status);
    }

    if ( (Type != ALINK) &&
         !ForceCheck     && 
         (Status == AOK) &&
         (streql(LastFile, PtrPath)) &&
         ((LastResult == AOK) || (LastResult == AWORKING)) && 
         BigEnough(PtrPath, EndOffset)) {
             Result=AOK;
             MustCallAlex=0;               /* thought about using !InTransit(PtrPath) */
    } else {
         MustCallAlex=1; 
    }

    if (MustCallAlex) {                    
        (void) strcpy(LastFile, PtrPath);
        CountDiffFiles(LastFile, Type);               /* MustCallAlex at least on first time */

        (void) strcpy(Path, PtrPath);
        LogUnfsd("MakeItSoRead ", Path , rqstp);

        Result=CallAlex(Path, rqstp);           /* call CallAlex() make sure this is in the cache */
    }
    
    if ((Result == AWORKING) && (Type != ALINK)) {
        if (BigEnough(PtrPath, EndOffset)) {
            Result=AOK;
        }
    }

    LastResult=Result;

    LogT("MakeItSoRead done ", Result);
    return(Result);
}

/* below was part of above */
       /*     LastResult=AWORKING; */
       /* (!streql(LastFile, PtrPath))  ||      /* is this a new file name?  */
       /* (CheckFileStatus(PtrPath) == AWORKING)) { /* is this file currently in transit?  */



/*  Sometimes there are bad and evil users, but usually it is just some deamon
 *  that is doing a "find /" and ends up romping through Alex.  When that all
 *  you can currently do is recompile after defining ABUSIVEMACHINE in config.h
 */
int AbusiveMachine(rqstp)
struct svc_req *rqstp;
{
    struct authunix_parms *unix_cred;
    char *MachineName;
    int Uid;
    static char LastMachine[MAXPATH];
    static int NumLastDone=0;

#ifdef ABUSIVEMACHINES
    int i;
    static char *BadMachines[] = ABUSIVEMACHINES;    /* {"foo", "bar", NULL} */
#endif

    unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;
    MachineName = unix_cred->aup_machname;
    Uid = unix_cred->aup_uid;


#ifdef ABUSIVEMACHINES
    for (i=0; BadMachines[i]!=NULL; i++) {
        if (streql(MachineName, BadMachines[i] )) {
             return(1);   /* refuse abusive machines */
        }
    }
#endif

#ifdef LIMITPERMACHINE
    if (streql(MachineName, LastMachine)) {               /* same guy again? */
        NumLastDone++;
        if (NumLastDone > LIMITPERMACHINE) return(1);
    } else {
        strcpy(LastMachine, MachineName);
        NumLastDone=1;
    }
#endif

#ifdef ABUSIVEUSER
    if (Uid == ABUSIVEUSER) {
        return(1);
    }
#endif

    return(0);
}



diropres *nfsproc_lookup_2(argp, rqstp)
diropargs *argp;
struct svc_req *rqstp;
{
    static diropres res;
    int Done, Tries, Status, OldNumFinishedFTPs;
    char s[100];

    Log("\n\nnfsproc_lookup_2 entering");

    bzero((char *) &res, sizeof(res));
    if ((knownclient(rqstp) == NULL) || (AbusiveMachine(rqstp))) {
        res.status = NFSERR_ACCES;
        return(&res);
    }

    OldNumFinishedFTPs=NumFinishedFTPs;
    (void) sprintf(argbuf, "fh=%s n=%s", fh_pr(&(argp->dir)), argp->name);
    if (HasChar(argp->name, '/')) {
        ToLog(DBERROR, "nfsproc_lookup ERROR should be simple name %s \n", argp->name);
    }
    LogUnfsdReal(DBRPC, "nfsproc_lookup", argbuf, rqstp);


    Done=0;
    Status=AFAIL;
    for (Tries=0; (Tries < 3) && !Done && (Status != AWORKING); Tries++) {
        Status = fh_compose(argp, &(res.diropres_u.diropres.file), &(res.status));
        if (Status == AOK) {
            Done=1;
            Status=inner_getattr(&(res.diropres_u.diropres.file), &(res.status),
                      &(res.diropres_u.diropres.attributes), rqstp, 1);
  
            if (Status == AOK) {
                Log2("nfsproc_lookup_2 good new_fh = ", fh_pr(&(res.diropres_u.diropres.file)));  
            } else if (Status == AUPDATE) {
                Done=0;
            }
        } else {
            if (Status != AWORKING && !Done  && Tries<2) {      
                Status=MakeItSoLookup(argp, rqstp, (Tries==1)); /* should detect .Stale */
            }                                                /* not done so we will loop  */ 
        }
    }

    if (Status == NOSUCHFILE) {
        res.status = NFSERR_NOENT;
    }

    if (Status == ANFSSTALE) {
        ToLog(DBRPC, "nfsproc_lookup_2 STALE\n");
        res.status = NFSERR_STALE;
    }

    if (Status == AFAIL) {
        ToLog(DBRPC, "nfsproc_lookup_2 returning NFSERR_IO\n");
        res.status = NFSERR_IO;
        return(&res);
    }

    LogT("nfsproc_lookup_2 done\n", Status);
    if (Status == AWORKING) {
        ToLog(DBPERF, "nfsproc_lookup_2 DROPPING\n");
        LookupDrops++;
        return(NULL);
    } else {
        if (OldNumFinishedFTPs == NumFinishedFTPs) {
            LookupHits++;
            LogN("NumFinishedFTPs ", NumFinishedFTPs);
        } else {
            LookupMisses++;
            sprintf(s, "LookupHits= %7d  Mis= %7d  Drop= %7d", LookupHits,LookupMisses,LookupDrops);
            Log(s);
        }
        TotalBytesNFSed += sizeof(res);
        TotalDirBytesNFSed += sizeof(res);
        return (&res);
    }
}



readlinkres * nfsproc_readlink_2(argp, rqstp)
nfs_fh *argp;
struct svc_req *rqstp;
{
    static readlinkres res;
    char    *path;
    static struct ParsedDir Current;
    int    Status, Len;
    char   *UidStr;

    Log("\n\n nfsproc_readlink_2 entering");

    bzero((char *) &res, sizeof(res));

                                  /* could save clnt_param if wanted it */
    if ((knownclient(rqstp) == NULL) || (AbusiveMachine(rqstp))) {
        res.status = NFSERR_ACCES;
        return(&res);
    }

    LogUnfsdReal(DBRPC, "nfsproc_readlink ", fh_pr(argp), rqstp);
    UidStr=RequestToUidStr(rqstp);

    Status = fh_path(argp, &(res.status), &path);
    if (Status == AOK) {
        Log2("\n nfsproc_readlink_2 got a path of ", path);
        Status = AlexInfoLStat(path, &Current, UidStr, RECURSIONOK);    
        if ((Status == AOK) && 
                ((Current.Type == HOSTALIAS) || (Current.Date == HOSTDATE))) { 
            Status=MakeItSoRead(argp, rqstp, ALINK, 0, 0);      /* if hostalias check if current */
            if (Status == AWORKING) {
                ToLog(DBPERF, "nfsproc_readlink_2 DROPPING\n");
                return(NULL);
            }
            Status = AlexInfoLStat(path, &Current, UidStr, RECURSIONOK);  /* redo after checking */
        }

        LogT("nfsproc_readlink_2 got a status of ", Status);
        LogT("nfsproc_readlink_2 got a type of ", Current.Type);
        Len=strlen(Current.SymLink);

        if (Status != AWORKING) {
            if ((Status != AOK) || (SimpleType(Current.Type) != ALINK)) {
                res.status = (nfsstat) NFSERR_NOENT;
            } else if (Len > NFS_MAXPATHLEN) {
                res.status = (nfsstat) NFSERR_NAMETOOLONG;
            } else {
                res.readlinkres_u.data = Current.SymLink;;
                res.status = (nfsstat) NFS_OK;
                Log2("\n nfsproc_readlink_2 is returning a symlink of ", Current.SymLink);
                errno=0;
            }
        }
    }

    if ((Status == AOK) && (res.status == NFS_OK)) {
        Log2("\n returning link value of ", res.readlinkres_u.data);
    } else {
        LogN("nfsproc_readlink_2 res.status", res.status);
        if (res.status == NFS_OK) {
            ToLog(DBERROR, "nfsproc_readlink_2  ERROR BUG said NFS_OK but is not.  making stale ");
            res.status =  NFSERR_STALE;
        }
    }

    LogT("nfsproc_readlink_2 ", Status);

    if (Status == AFAIL) {
        ToLog(DBRPC, "nfsproc_readlink_2 returning NFSERR_IO\n");
        res.status = NFSERR_IO;
        return(&res);
    }

    if (Status == AWORKING) {
        ToLog(DBPERF, "nfsproc_readlink_2 DROPPING\n");
        return(NULL);
    } else {
        return(&res);
    }
}


static char iobuf[NFS_MAXDATA];


readres * nfsproc_read_2(argp, rqstp)
readargs *argp;
struct svc_req *rqstp;
{
    static readres res;
    int fd, BytesRead, Status, OldNumFinishedFTPs, EndOffset;

    Log("\n\n nfsproc_read_2 entering");

    OldNumFinishedFTPs=NumFinishedFTPs;

    bzero((char *) &res, sizeof(res));
    if (knownclient(rqstp) == NULL) {
        res.status = NFSERR_ACCES;
        return (&res);
    }
    EndOffset = (int) argp->offset + argp->count;

    Status=MakeItSoRead( &argp->file, rqstp, AFILE, EndOffset, 0);
    if (Status == AWORKING) {
        ToLog(DBPERF, "nfsproc_read_2 DROPPING\n");
        ReadDrops++;
        return(NULL);
    }

    if (Status == ANFSSTALE) {
        ToLog(DBRPC, "nfsproc_read_2 returning NFSERR_STALE\n");
        res.status = NFSERR_STALE;
        return(&res);
    }

    (void) sprintf(argbuf, "%s @%u for %u", fh_pr(&(argp->file)),
                                    argp->offset, argp->count);
    LogUnfsdReal(DBRPC, "nfsproc_read", argbuf, rqstp);


    Status = fh_fd(&(argp->file), &(res.status), O_RDONLY, &fd);
    if (Status == ANFSSTALE) {
        ToLog(DBRPC, "nfsproc_read_2 returning   NFSERR_STALE\n");
        res.status = NFSERR_STALE;
        return(&res);
    }

    if (Status == AFAIL) {
        Status=MakeItSoRead( &argp->file, rqstp, AFILE, EndOffset, 1);           /* force a check */
        if (Status == AOK) {
            Status = fh_fd(&(argp->file), &(res.status), O_RDONLY, &fd);
        } else { 
            Status=AFAIL;                              /* really does not work */
        }
    }

    if (Status == AOK) {
        errno = 0;
        (void) lseek(fd, (long) argp->offset, 0);      /* we look at errno and ignore return val */
        res.readres_u.reply.data.data_val = iobuf;
        if (!errno) {
            BytesRead = read(fd, res.readres_u.reply.data.data_val, (int) argp->count);
            LogN("nfsproc_read BytesRead ", BytesRead);
            if (BytesRead>0) {
                TotalBytesNFSed += BytesRead;
                TotalFileBytesNFSed += BytesRead;
            }

            res.readres_u.reply.data.data_len = BytesRead;
        }

        res.status = (nfsstat) errno;                       /* does this really work? XXXX */

        if (!res.status) {
            Status=inner_getattr(&(argp->file), &(res.status), 
                            &(res.readres_u.reply.attributes), rqstp, 0);
        }
    }
   
    if (Status == AFAIL) {
        ToLog(DBRPC, "nfsproc_read_2 returning NFSERR_IO\n");
        res.status = NFSERR_IO;
        return(&res);
    }

    if (Status == AWORKING) {
        ToLog(DBPERF, "nfsproc_read DROPPING\n");
        ReadDrops++;
        return(NULL);
    } else { 
        if (OldNumFinishedFTPs == NumFinishedFTPs) {
            ReadHits++;
        } else {
            ReadMisses++;
            ToLog(DBPERF, "\nReadHits= %7d  Mis= %7d  Drop= %7d  TotalBytesNFSed= %9f\n", 
                     ReadHits, ReadMisses, ReadDrops, TotalBytesNFSed);
        }
        return(&res);
    }
}


/* This will be in next version of NFS but does nothing here */
void * nfsproc_writecache_2(argp, rqstp)
void *argp;
struct svc_req *rqstp;
{
    static char res;

    bzero( (char *) &res, sizeof(res));
    LogUnfsdReal(DBRPC, "nfsproc_writecache", "", rqstp);

    return ((void *)&res);
}


attrstat * nfsproc_write_2(argp, rqstp)
writeargs *argp;
struct svc_req *rqstp;
{
    static attrstat res;

    bzero( (char *) &res, sizeof(res));
    (void) sprintf(argbuf, "%s @%u for %u", fh_pr(&(argp->file)), 
                            argp->offset, argp->data.data_len);
    LogUnfsdReal(DBRPC, "nfsproc_write", argbuf, rqstp);

    res.status = NFSERR_ROFS;

    return (&res);
}


diropres * nfsproc_create_2(argp, rqstp)
createargs *argp;
struct svc_req *rqstp;
{
    static diropres res;
    
    bzero( (char *) &res, sizeof(res));
    (void) sprintf(argbuf, "fh=%s n=%s m=%u u/g=%u/%u sz=%u",
            fh_pr(&(argp->where.dir)), argp->where.name,
            argp->attributes.mode, argp->attributes.uid,
            argp->attributes.gid, argp->attributes.size);
    LogUnfsdReal(DBRPC, "nfsproc_create", argbuf, rqstp);

    res.status = NFSERR_ROFS;

    return (&res);
}


nfsstat * nfsproc_remove_2(argp, rqstp)
diropargs *argp;
struct svc_req *rqstp;
{
    static nfsstat res;

    bzero( (char *) &res, sizeof(res));
    (void) sprintf(argbuf, "fh=%s n=%s", fh_pr(&(argp->dir)), argp->name);
    LogUnfsdReal(DBRPC, "nfsproc_remove", argbuf, rqstp);

    res = NFSERR_ROFS;

    return (&res);
}


nfsstat * nfsproc_rename_2(argp, rqstp)
renameargs *argp;
struct svc_req *rqstp;
{
    static nfsstat res;

    bzero( (char *) &res, sizeof(res));
    LogUnfsdReal(DBRPC, "nfsproc_rename", "", rqstp);

    res = NFSERR_ROFS;

    return (&res);
}


nfsstat * nfsproc_link_2(argp, rqstp)
linkargs *argp;
struct svc_req *rqstp;
{
    static nfsstat res;

    bzero( (char *) &res, sizeof(res));
    LogUnfsdReal(DBRPC, "nfsproc_link", "", rqstp);

    res = NFSERR_ROFS;

    return (&res);
}


nfsstat * nfsproc_symlink_2(argp, rqstp)
symlinkargs *argp;
struct svc_req *rqstp;
{
    static nfsstat res;

    bzero( (char *) &res, sizeof(res));
    LogUnfsdReal(DBRPC, "nfsproc_symlink", "", rqstp);

    res = NFSERR_ROFS;

    return (&res);
}


diropres * nfsproc_mkdir_2(argp, rqstp)
createargs *argp;
struct svc_req *rqstp;
{
    static diropres res;

    bzero( (char *) &res, sizeof(res));
    (void) sprintf(argbuf,
            "fh=%s n=%s m=%0o u/g=%u/%u sz=%u\n\t at=%u %u mt=%u %u",
            fh_pr(&(argp->where.dir)), argp->where.name,
            argp->attributes.mode, argp->attributes.uid,
            argp->attributes.gid, argp->attributes.size,
            argp->attributes.atime.seconds,
            argp->attributes.atime.useconds,
            argp->attributes.mtime.seconds,
            argp->attributes.mtime.useconds);
    LogUnfsdReal(DBRPC, "nfsproc_mkdir", argbuf, rqstp);

    res.status = NFSERR_ROFS;

    return (&res);
}


nfsstat * nfsproc_rmdir_2(argp, rqstp)
diropargs *argp;
struct svc_req *rqstp;
{
    static nfsstat res;

    bzero( (char *) &res, sizeof(res));
    (void) sprintf(argbuf, "fh=%s n=%s", fh_pr(&(argp->dir)), argp->name);
    LogUnfsdReal(DBRPC, "nfsproc_rmdir", argbuf, rqstp);

    res = NFSERR_ROFS;

    return (&res);
}


#define DP_SLOP 16
#define MAX_E_SIZE sizeof(entry) + MAXNAMLEN + DP_SLOP

/*
*int dpsize(dp)
*struct direct *dp;
*{
*    return sizeof(entry) + strlen(dp->d_name) + DP_SLOP;
*}
*/

#if defined(MACH) || defined(hpux)
/* 
 * It seems Mach and HPUX do not have xdr_free while 
 * SUNs, Ultrix, 386BSD, Next already have this. 
 *
 * If you have some new system you may or may not need this.
 */
void xdr_free(unknown, resptr)
int unknown;
readdirres *resptr;
{
    entry *e;
    entry *last;
    int n;

    Log("xdr_free entering");
    e = resptr->readdirres_u.reply.entries;

    n=0;
    while (e != NULL) {
        last=e;
        e=e->nextentry;
        free(last->name);
        free((char *) last);
        n++;
        /* LogN("xdr_free freed another ", n); */
    }
    LogN("xdr_free done", n);
}

#endif

readdirres * nfsproc_readdir_2(argp, rqstp)
readdirargs *argp;
struct svc_req *rqstp;
{
    static readdirres res;
    entry **e;
    char    *path;
    long    dloc;
    struct ActiveAlexInfo AAI;
    struct ParsedDir Current;
    int    Status, OldNumFinishedFTPs, NeedAnUpdate, ReadingFirstPart;
    int    res_size;
    char   *UidStr;

    OldNumFinishedFTPs=NumFinishedFTPs;

    Log("\n nfsproc_readdir entering");

    xdr_free(xdr_readdirres, &res);                        /* Free previous result */
    bzero( (char *) &res, sizeof(res));

    if (!knownclient(rqstp)) {
        res.status = NFSERR_ACCES;
        return (&res);
    }

    Status=MakeItSoReadDir(argp, rqstp, 0);
    if (Status == AWORKING) {
        ToLog(DBPERF, "nfsproc_readdir_2 DROPPING\n");
        ReadDirDrops++;
        return(NULL);
    }

    LogUnfsdReal(DBRPC, "nfsproc_readdir", fh_pr(&(argp->dir)), rqstp); /* want MakeItSo before fh_pr */

    if (Status == ANFSSTALE) {
        ToLog(DBRPC, "nfsproc_readdir returning STALE\n");
        res.status = NFSERR_STALE;
        return(&res);
    }

    LogUnfsd("nfsproc_readdir", fh_pr(&(argp->dir)), rqstp);

    UidStr=RequestToUidStr(rqstp);

    ReadingFirstPart=0;
    NeedAnUpdate=0;
    Status = fh_path(&(argp->dir), &(res.status), &path);
    if (Status == ANFSSTALE) {
        ToLog(DBRPC, "nfsproc_readdir returning   STALE\n");
        res.status = NFSERR_STALE;
        return(&res);
    }

    if (Status == AOK) {
        errno = 0;
        Status=AlexOpenDir(path, &AAI, UidStr);
        if (Status == AWORKING) {
            ToLog(DBPERF, "nfsproc_readdir_2 DROPPING\n");
            ReadDirDrops++;
            return(NULL);                                    
        }
        if (Status != AOK) {
            res.status = (nfsstat) NFSERR_NOENT;
        } else {
            res_size = 0;

            Log2("nfsproc_readdir_2 done with AlexOpenDir of ", path);
            res.status = NFS_OK;
            bcopy((char *) argp->cookie, (char *) &dloc, sizeof(dloc));
            if (dloc != 0) {
                if (fseek(AAI.File, dloc, 0) < 0) {
                    LogN("nfsproc_readdir_2 ERROR could not fseek to ", (int) dloc);
                    res.status = NFSERR_IO;   /*  wonder what the error should be XXX */
                    return(&res);
                }
                LogN("nfsproc_readdir_2 done with fseek", (int) dloc);
            } else {
                ReadingFirstPart=1;
            }
            e = &(res.readdirres_u.reply.entries);
            while (((res_size+MAX_E_SIZE) < argp->count || e == &(res.readdirres_u.reply.entries))
                 && (Status=AlexInfoInNext(&AAI, &Current)) == AOK) {
            
                if ((*e = (entry *) malloc((unsigned) sizeof(entry))) == NULL) {
                    MallocDeath("fsproc_readdir_2   1");
                }
                TotalNFSLS++;
                (*e)->fileid = (ino_t) Current.Inode;   
                (*e)->name = strsave(Current.Name);
                dloc = ftell(AAI.File);            
                LogN(Current.Name, (int) (*e)->fileid);
                LogN(Current.Name, (int) dloc);
                bcopy((char *) &dloc, (char *) ((*e)->cookie), sizeof(nfscookie));
                e = &((*e)->nextentry);
                res_size += sizeof(entry) + strlen(Current.Name) + DP_SLOP;
            }
            *e = NULL;
            res.readdirres_u.reply.eof = (Status == AEOF);
            LogN("nfsproc_readdir_2 did AlexInfoInClose  reply.eof=", res.readdirres_u.reply.eof);
            LogN("nfsproc_readdir_2 HasAlexError     = ", AAI.HasAlexError);
            LogN("nfsproc_readdir_2 NeedAnUpdate  = ", AAI.NeedAnUpdate);
            if (AAI.NeedAnUpdate > 0) {
                NeedAnUpdate=1;
            }
            (void) AlexInfoInClose(&AAI);
        }
    }

    LogT("nfsproc_readdir_2 done", Status);

    if (ReadingFirstPart && (NeedAnUpdate > 0) && (Status != AWORKING)) {
        ToLog(6, "nfsproc_readdir_2 NeedAnUpdate and needs an update");
        Status=MakeItSoReadDir(argp, rqstp, 1);  

        Status=AWORKING;                             /* will drop this and try again later */
    }
        
    if (Status == AFAIL) {
        ToLog(DBRPC, "nfsproc_readdir_2 returning NFSERR_IO\n");
        res.status = NFSERR_IO;
        return(&res);
    }

    if (Status == AWORKING) {
        ToLog(DBPERF, "nfsproc_readdir_2 DROPPING \n");
        ReadDirDrops++;
        Log(" ");
        return(NULL);
    } else {
        if ((Status == AOK) && (res_size > 0)) {
            TotalBytesNFSed += res_size;
            TotalDirBytesNFSed += res_size;
        }

        if (OldNumFinishedFTPs == NumFinishedFTPs) {
            ReadDirHits++;
            LogN("NumFinishedFTPs ", NumFinishedFTPs);
        } else {
            char s[100];

            ReadDirMisses++;
            sprintf(s, "ReadDirHit= %7d  Mis= %7d  Drop= %7d", 
                                 ReadDirHits,ReadDirMisses,ReadDirDrops);
            Log(s);
        }
        Log(" ");
        return (&res);
    }
}


statfsres * nfsproc_statfs_2(argp, rqstp)
nfs_fh *argp;
struct svc_req *rqstp;
{
    static statfsres res;
    struct statfs fsdata;

    bzero( (char *) &res, sizeof(res));
    if ((knownclient(rqstp) == NULL) || (AbusiveMachine(rqstp))) {
        res.status = NFSERR_ACCES;
        return(&res);
    }

    LogUnfsdReal(DBRPC, "nfsproc_statfs", fh_pr(argp), rqstp);

/*
      tsize   The optimum transfer size of the server in bytes.  This is
              the number of bytes the server would like to have in the
              data part of READ and WRITE requests.

      bsize   The block size in bytes of the filesystem.

      blocks  The total number of "bsize" blocks on the filesystem.

      bfree   The number of free "bsize" blocks on the filesystem.

      bavail  The number of "bsize" blocks available to non-privileged
              users.
*/
    res.status = NFS_OK;
#ifdef __linux__
    res.statfsres_u.reply.tsize = 1024;
#else
    res.statfsres_u.reply.tsize = 8192;
#endif

#ifdef ultrix
    if (1) {
#else
    if (statfs(CACHEDIR, &fsdata) < 0) {
#endif
        res.statfsres_u.reply.bsize = 4096;
        res.statfsres_u.reply.blocks = 250000000;     /* about 1 TB I think */
        res.statfsres_u.reply.bfree =  100000000;     /* hard to say        */
        res.statfsres_u.reply.bavail = 100000000;
    } else {
	/*
	 * return fs data from cache area, so people can tell how much disk
	 * space we got
	 */
        res.statfsres_u.reply.bsize = fsdata.f_bsize;
        res.statfsres_u.reply.blocks = fsdata.f_blocks;
        res.statfsres_u.reply.bfree =  fsdata.f_bfree;
        res.statfsres_u.reply.bavail = fsdata.f_bavail;
    }
    return(&res);
}





