%token ID MONTH DAYOFWEEK MERIDIAN NUMBER ZONE DAYZONE 
%{

/*  Vince  Cate  11/9/91  
 *
 *  Simplified a bit - no more shift/reduce conflicts.
 */

/*      Steven M. Bellovin (unc!smb)                    */
/*      Dept. of Computer Science                       */
/*      University of North Carolina at Chapel Hill     */
/*      @(#)getdate.y   2.13    9/16/86                 */

/*      defining malloc in one of the following can cause problems if you do 
 *      a "make noyacc" because you do not have yacc  */
#include "alexincs.h"
#include "alex.h"

#define daysec (24L*60L*60L)

static int timeflag, zoneflag, dateflag, yearflag;
static int hh, mm, ss, merid, daylightsvs;
static int month, day, year;
static int ourzone;

#define AM 1
#define PM 2
#define DAYLIGHT 1
#define STANDARD 2
#define MAYBE    3
%}

%%

validstring:   /* empty */
        | dayofweek validstring =
                {;}
        | zonespec validstring =
                {zoneflag++;}
        | timespec validstring =
                {timeflag++;}
        | datespec validstring =
                {dateflag++;}
        | dateyearspec validstring =
                {dateflag++; yearflag++;}
        | yearspec validstring =
                {yearflag++;};

dayofweek: DAYOFWEEK =
                {;};


yearspec:       NUMBER =
                {year = $1; };

timespec: NUMBER ':' NUMBER =
                {hh = $1; mm = $3; ss=0; merid = 24;}
        | NUMBER ':' NUMBER MERIDIAN =
                {hh = $1; mm = $3; ss=0; merid = $4;}
        | NUMBER ':' NUMBER ':' NUMBER =
                {hh = $1; mm = $3; ss = $5; merid = 24;}
        | NUMBER ':' NUMBER ':' NUMBER MERIDIAN =
                {hh = $1; mm = $3; ss = $5; merid = $6;};

/* note that zone flag means that both ourzone and daylightsvs are set */
zonespec:       ZONE =
                {ourzone = $1; daylightsvs = STANDARD;}
        | DAYZONE =
                {ourzone = $1; daylightsvs = DAYLIGHT;};

datespec:       NUMBER '/' NUMBER =
                {month = $1; day = $3;}
        | MONTH NUMBER =
                {month = $1; day = $2;}
        | NUMBER '-' MONTH =
                {month = $3; day = $1;};

dateyearspec:  NUMBER '/' NUMBER '/' NUMBER =
                {month = $1; day = $3; year = $5;  }
        | MONTH NUMBER ',' NUMBER =
                {month = $1; day = $2; year = $4;  }
        | NUMBER '-' MONTH '-' NUMBER =
                {month = $3; day = $1; year = $5;  };


%%

static int mdays[12] =
        {31, 0, 31,  30, 31, 30,  31, 31, 30,  31, 30, 31};

#define epoch 1970

extern struct tm *localtime();
time_t dateconv(mm, dd, yy, h, m, s, mer, zone, daylightsvs)
int mm, dd, yy, h, m, s, mer, zone, daylightsvs;
{
    time_t tod, jdate;
    register int i;
    time_t timeconv();

    if (yy < 0) yy = -yy;
    if (yy < 100) yy += 1900;
    mdays[1] = 28 + (yy%4 == 0 && (yy%100 != 0 || yy%400 == 0));
    if (yy < epoch || yy > 1999 || mm < 1 || mm > 12 ||
            dd < 1 || dd > mdays[--mm]) return (-1);
    jdate = dd-1;
    for (i=0; i<mm; i++) jdate += mdays[i];
    for (i = epoch; i < yy; i++) jdate += 365 + (i%4 == 0);
    jdate *= daysec;
    jdate += zone * 60L;
    if ((tod = timeconv(h, m, s, mer)) < 0) return (-1);
    jdate += tod;
    if (daylightsvs==DAYLIGHT ||(daylightsvs==MAYBE&&localtime(&jdate)->tm_isdst))
        jdate += -1*60*60;
    return (jdate);
}


time_t timeconv(hh, mm, ss, mer) register int hh, mm, ss, mer;
{
    if (mm < 0 || mm > 59 || ss < 0 || ss > 59) return (-1);
    switch (mer) {
        case AM: if (hh < 1 || hh > 12) return(-1);
                 return (60L * ((hh%12)*60L + mm)+ss);
        case PM: if (hh < 1 || hh > 12) return(-1);
                 return (60L * ((hh%12 +12)*60L + mm)+ss);
        case 24: if (hh < 0 || hh > 23) return (-1);
                 return (60L * (hh*60L + mm)+ss);
        default: return (-1);
    }
}


static char *lptr;

yylex()
{
    extern int yylval;
    register char c;
    register char *p;
    char idbuf[20];
    int pcnt;

    for (;;) {
        while (isspace(*lptr)) lptr++;

        if (isdigit(c = *lptr)) {
            yylval = 0;
            while (isdigit(c = *lptr++)) yylval = 10*yylval + c - '0';
                lptr--;
            return (NUMBER);

        } else if (isalpha(c)) {                      
            p = idbuf;
            while (isalnum(c = *lptr++) || c=='.' || c=='+' || c=='-') {
                if (p < &idbuf[sizeof(idbuf)-1]) {
                    *p++ = c;
                }
            }
            *p = '\0';
            lptr--;
            return (lookup(idbuf));

        } else if (c == '(') {                  /* ignore anything in parens */
            pcnt = 0;
            do {
                c = *lptr++;
                if (c == '\0') return(c);
                else if (c == '(') pcnt++;
                else if (c == ')') pcnt--;
            } while (pcnt > 0);

        } else {
            return (*lptr++);
        }
    }
}

struct table {
    char *name;
    int type, value;
};

struct table mdtab[] = {       /* user can abreviate with just first 3 chars */
        {"January", MONTH, 1},
        {"February", MONTH, 2},
        {"March", MONTH, 3},
        {"April", MONTH, 4},
        {"May", MONTH, 5},
        {"June", MONTH, 6},
        {"July", MONTH, 7},
        {"August", MONTH, 8},
        {"September", MONTH, 9},
        {"October", MONTH, 10},
        {"November", MONTH, 11},
        {"December", MONTH, 12},

        {"Sunday", DAYOFWEEK, 0},
        {"Monday", DAYOFWEEK, 1},
        {"Tuesday", DAYOFWEEK, 2},
        {"Wednesday", DAYOFWEEK, 3},
        {"Thursday", DAYOFWEEK, 4},
        {"Friday", DAYOFWEEK, 5},
        {"Saturday", DAYOFWEEK, 6},
        {0, 0, 0}};

#define HRS *60
#define HALFHR 30
struct table mztab[] = {           /* meridian and zones - always full length */
        {"a.m.", MERIDIAN, AM},
        {"am", MERIDIAN, AM},
        {"p.m.", MERIDIAN, PM},
        {"pm", MERIDIAN, PM},
        {"nst", ZONE, 3 HRS + HALFHR},          /* Newfoundland */
        {"n.s.t.", ZONE, 3 HRS + HALFHR},
        {"ast", ZONE, 4 HRS},           /* Atlantic */
        {"a.s.t.", ZONE, 4 HRS},
        {"adt", DAYZONE, 4 HRS},
        {"a.d.t.", DAYZONE, 4 HRS},
        {"est", ZONE, 5 HRS},           /* Eastern */
        {"e.s.t.", ZONE, 5 HRS},
        {"edt", DAYZONE, 5 HRS},
        {"e.d.t.", DAYZONE, 5 HRS},
        {"cst", ZONE, 6 HRS},           /* Central */
        {"c.s.t.", ZONE, 6 HRS},
        {"cdt", DAYZONE, 6 HRS},
        {"c.d.t.", DAYZONE, 6 HRS},
        {"mst", ZONE, 7 HRS},           /* Mountain */
        {"m.s.t.", ZONE, 7 HRS},
        {"mdt", DAYZONE, 7 HRS},
        {"m.d.t.", DAYZONE, 7 HRS},
        {"pst", ZONE, 8 HRS},           /* Pacific */
        {"p.s.t.", ZONE, 8 HRS},
        {"pdt", DAYZONE, 8 HRS},
        {"p.d.t.", DAYZONE, 8 HRS},
        {"yst", ZONE, 9 HRS},           /* Yukon */
        {"y.s.t.", ZONE, 9 HRS},
        {"ydt", DAYZONE, 9 HRS},
        {"y.d.t.", DAYZONE, 9 HRS},
        {"hst", ZONE, 10 HRS},          /* Hawaii */
        {"h.s.t.", ZONE, 10 HRS},
        {"hdt", DAYZONE, 10 HRS},
        {"h.d.t.", DAYZONE, 10 HRS},

        {"gmt",      ZONE,  0 HRS},
        {"gmt+000",  ZONE,  0 HRS},
        {"gmt+100",  ZONE,  1 HRS},
        {"gmt+200",  ZONE,  2 HRS},
        {"gmt+300",  ZONE,  3 HRS},
        {"gmt+400",  ZONE,  4 HRS},
        {"gmt+500",  ZONE,  5 HRS},
        {"gmt+600",  ZONE,  6 HRS},
        {"gmt+700",  ZONE,  7 HRS},
        {"gmt+800",  ZONE,  8 HRS},
        {"gmt+900",  ZONE,  9 HRS},
        {"gmt+1000", ZONE, 10 HRS},
        {"gmt+1100", ZONE, 11 HRS},
        {"gmt+1200", ZONE, 12 HRS},
        {"gmt-100",  ZONE, -1 HRS},
        {"gmt-200",  ZONE, -2 HRS},
        {"gmt-300",  ZONE, -3 HRS},
        {"gmt-400",  ZONE, -4 HRS},
        {"gmt-500",  ZONE, -5 HRS},
        {"gmt-600",  ZONE, -6 HRS},
        {"gmt-700",  ZONE, -7 HRS},
        {"gmt-800",  ZONE, -8 HRS},
        {"gmt-900",  ZONE, -9 HRS},
        {"gmt-1000", ZONE, -10 HRS},
        {"gmt-1100", ZONE, -11 HRS},
        {"g.m.t.", ZONE, 0 HRS},
        {"bst", DAYZONE, 0 HRS},                /* British Summer Time */
        {"b.s.t.", DAYZONE, 0 HRS},
        {"eet", ZONE, 0 HRS},           /* European Eastern Time */
        {"e.e.t.", ZONE, 0 HRS},
        {"eest", DAYZONE, 0 HRS},       /* European Eastern Summer Time */
        {"e.e.s.t.", DAYZONE, 0 HRS},
        {"met", ZONE, -1 HRS},          /* Middle European Time */
        {"m.e.t.", ZONE, -1 HRS},
        {"mest", DAYZONE, -1 HRS},      /* Middle European Summer Time */
        {"m.e.s.t.", DAYZONE, -1 HRS},
        {"wet", ZONE, -2 HRS },         /* Western European Time */
        {"w.e.t.", ZONE, -2 HRS },
        {"west", DAYZONE, -2 HRS},      /* Western European Summer Time */
        {"w.e.s.t.", DAYZONE, -2 HRS},

        {"jst", ZONE, -9 HRS},          /* Japan Standard Time */
        {"j.s.t.", ZONE, -9 HRS},       /* Japan Standard Time */
                                        /* No daylight savings time */

        {"aest", ZONE, -10 HRS},        /* Australian Eastern Time */
        {"a.e.s.t.", ZONE, -10 HRS},
        {"aesst", DAYZONE, -10 HRS},    /* Australian Eastern Summer Time */
        {"a.e.s.s.t.", DAYZONE, -10 HRS},
        {"acst", ZONE, -(9 HRS + HALFHR)},      /* Australian Central Time */
        {"a.c.s.t.", ZONE, -(9 HRS + HALFHR)},
        {"acsst", DAYZONE, -(9 HRS + HALFHR)},  /* Australian Central Summer */
        {"a.c.s.s.t.", DAYZONE, -(9 HRS + HALFHR)},
        {"awst", ZONE, -8 HRS},         /* Australian Western Time */
        {"a.w.s.t.", ZONE, -8 HRS},     /* (no daylight time there, I'm told */
        {0, 0, 0}};

struct table milzone[] = {
        {"a", ZONE, 1 HRS},
        {"b", ZONE, 2 HRS},
        {"c", ZONE, 3 HRS},
        {"d", ZONE, 4 HRS},
        {"e", ZONE, 5 HRS},
        {"f", ZONE, 6 HRS},
        {"g", ZONE, 7 HRS},
        {"h", ZONE, 8 HRS},
        {"i", ZONE, 9 HRS},
        {"k", ZONE, 10 HRS},
        {"l", ZONE, 11 HRS},
        {"m", ZONE, 12 HRS},
        {"n", ZONE, -1 HRS},
        {"o", ZONE, -2 HRS},
        {"p", ZONE, -3 HRS},
        {"q", ZONE, -4 HRS},
        {"r", ZONE, -5 HRS},
        {"s", ZONE, -6 HRS},
        {"t", ZONE, -7 HRS},
        {"u", ZONE, -8 HRS},
        {"v", ZONE, -9 HRS},
        {"w", ZONE, -10 HRS},
        {"x", ZONE, -11 HRS},
        {"y", ZONE, -12 HRS},
        {"z", ZONE, 0 HRS},
        {0, 0, 0}};

lookup(id) 
char *id;
{
#define gotit (yylval=i->value,  i->type)
#define getid for(j=idvar, k=id;   *j++ = *k++;      )    /* fresh copy */

    char idvar[20];
    register char *j, *k;
    register struct table *i;

    getid;
    for (i = mdtab; i->name; i++) {
        if (strncasecmp(idvar, i->name, 3) == 0) {
            return gotit;
        }
    }

    getid;
    for (i = mztab; i->name; i++)
        if (strcmp(i->name, idvar) == 0) return gotit;

    for (j = idvar; *j; j++)
        if (isupper(*j)) *j = tolower(*j);
    for (i=mztab; i->name; i++)
        if (strcmp(i->name, idvar) == 0) return gotit;

    getid;
    if (strlen(idvar) == 1 && isalpha(*idvar)) {
        if (isupper(*idvar)) *idvar = tolower(*idvar);
        for (i = milzone; i->name; i++) {
            if (strcmp(i->name, idvar) == 0) return gotit;
        }
    }

    return(ID);
}

#define mcheck(f)       if (f>1) err++

int StringToTimeb(p, Now, Result) 
char *p; 
struct timeb *Now, *Result;
{
    int err;
    struct tm *lt;
    struct timeb ftz;
    time_t sdate;

    lptr = p;
    if (Now == ((struct timeb *) NULL)) {
        Now = &ftz;
        ftime(&ftz);
    }
    lt = localtime(&Now->time);
    year = lt->tm_year;
    month = lt->tm_mon+1;
    day = lt->tm_mday;
    timeflag=zoneflag=dateflag=yearflag=0;
    ourzone = Now->timezone;
    daylightsvs = MAYBE;
    hh = mm = ss = 0;
    merid = 24;

    err=yyparse();
    if (err) {
        Log2("StringToTimeb could not parse date ", p);
        return(AFAIL);
    }

    mcheck(timeflag);               /* each of these should be at most 1 */
    mcheck(zoneflag);
    mcheck(dateflag);
    mcheck(yearflag);

    if (err) {
        Log2("StringToTimeb ERROR parsed some type of field twice", p);
        return(AFAIL);
    }
    if (!dateflag && !timeflag) {   
        Log2("StringToTimeb ERROR did not find a major item in string ", p);
        return(AFAIL);
    }

    sdate = dateconv(month,day,year,hh,mm,ss,merid,ourzone,daylightsvs);
    if (sdate < 0) {
        Log2("StringToTimeb ERROR from dateconv", p);
        return(AFAIL);
    }

/*  This is for times of files, so if there is no year we assume it could
 *  be up to a day ahead but otherwise in the past if no year specified.  
 */ 
    if (!yearflag && (sdate > (Now->time + ADAY))) { 
        Log2("StringToTimeb backing up a year since file dates must be in past", p);
        year--;                                       
        sdate = dateconv(month,day,year,hh,mm,ss,merid,ourzone,daylightsvs);
        if (sdate < 0) {
            Log2("StringToTimeb ERROR from dateconv after backing up a year", p);
            return(AFAIL);
        }
    }


    Result->time=sdate;
    Result->millitm=0;
    Result->timezone=ourzone;
    Result->dstflag=daylightsvs; 

    Log("StringToTimeb returning AOK");
    return(AOK);
}

yyerror(s)
char *s;
{
    Log2("yyerror", s);
}

