
#include "config.h"


#ifndef DEBUGLEVEL
#define DEBUGLEVEL 1
#endif

/* The following can be renumbered.  Any that are <= DEBUGLEVEL
*  end up getting sent to the log.  For example, make DBDOTALEX 0 if you always
*  want to see the .alex.dir and .alex.info files         
*
*                 0      nothing to log - should not do this       */
#define DBERROR   1   /* errors only - minimal logging             */
#define DBMAJOR   2   /* only major calls - like to CheckAlexCache */
#define DBRPC     3   /* a line or two per RPC                     */
#define DBPERF    4   /* performance monitoring                    */
#define DBPERF2   5   /* more performance monitoring               */
#define DBFTP     6   /* all actual FTP details from parent side   */
#define DBFTPCHILD 7  /* all FTP details in childs own log         */
#define DBOPEN    9   /* opens and closes of files                 */
#define DBALL    10   /* log every random thing - lots of stuff    */
#define DBALLT   11   /* log everything and timestamp it           */

#define DBDOTALEX 1000000  /* show .alex.dir and .alex.info files       */

#define DEFAULTTIMEZONE 300     /* Eastern time if can not get remote timezone info back */
#define MAXWAITFORTIME  30      /* 30 seconds */

extern FILE *debugLog;

extern ToLog_c();
extern Logcall_c();

#if (DEBUGLEVEL != 0)
#define ToLog ToLog_c
#define Logcall Logcall_c
#else
#define ToLog     (void)       
#define Logcall   (void)
#endif


#define Log2(x, y)     ToLog(10, "%s : %s\n", x, y)
#define Log3(x, y, z)  ToLog(10, "%s : %s : %s \n", x, y, z)
#define LogN(x, y)     ToLog(10, "%s : %d \n",   x, y)
#define LogD(x, y)     ToLog(10, "%s : %f \n",   x, y)
#define LogT(x, t)     ToLog(10, "%s : %s \n", x, ATypeToString(t))
#define LogC(x, c)     ToLog(10, "%s : %c \n",   x, c)
#define Log(x)         ToLog(10, "%s \n",      x)
#define AlexAssert(x)      if (!(x)) AlexAssertFailed(__FILE__, __LINE__, 1);   /* phone home */
#define AlexAssertSetup(x) if (!(x)) AlexAssertFailed(__FILE__, __LINE__, 0);   /* just a setup thing */

extern error1();
extern error2();
extern double TimeStampLog();
extern char *DateStr();
extern char *CurrentDateStr();

#define DONOTWAIT       0
#define DOWAIT          1

#define AMINUTE           60
#define AHOUR             (60 * AMINUTE)
#define ADAY              (24 * AHOUR)
#define AWEEK             ( 7 * ADAY)
#define AMONTH            (30 * ADAY)
#define TRUSTTIMEZONE     (6*AMONTH)   /* we catch daylight savings, so no hurry really to recheck timezone */
#define TRUSTHOSTTYPE     AMONTH           /* if NOANONFTP don't go back for one month   */
#define TRUSTHOSTALIAS    AWEEK
#define SECSTILLRETRY     (10 * AMINUTE)   /* till we retry after major FTP error */

#define MINCONSSLOP       (5 * AMINUTE)    /* minimum consistency promise */
                                           /* if file changes every minute, you loose */

/* Will force an update off all .alex.info files older than this.  */
#define MINTIMEOKALEXINFO 690460771

#define AFOPEN(x, t) afopen(x, t, __FILE__, __LINE__)
#define ALEXINFOINOPEN(m, n, o, p) AlexInfoInOpen(m, n, o, p, __FILE__, __LINE__)

#define AFCLOSE(f) afclose(f, __FILE__, __LINE__)

#define STARTDATA 20

#define ROOTINODE 3                /* also in RootAlexInfo            */
extern  char ROOTALEXINFOSTR[];    /* something like /usr2/.alex.info */
extern  int  CACHEDIRLEN;          /* strlen(CACHEDIR)                */
extern  char CACHEDIRVAR[];        /* alot like CACHEDIR              */
extern  int  CACHEDIRPARTS;        /* number of directories           */
extern  int  ALEXUIDVAR;
extern  int  ALEXGIDVAR;

extern  int NumFinishedFtps;

#define FTPWRAPPATH     "/usr/vac/alex/bin/ftpwrap"
#define FTPWRAP         "ftpwrap"

#define ALEXDIR         ".alex.dir"
#define SLASHALEXDIR   "/.alex.dir"

#define ALEXINFO        ".alex.info"
#define SLASHALEXINFO  "/.alex.info"
 
#define ALEXERROR       ".alex.error"
#define SLASHALEXERROR "/.alex.error" 

#define ALEXUPDATE      ".alex.update"    /* accessing this file causes server to update dir */
#define SLASHALEXUPDATE "/.alex.update" 

#define ALEXADDHOST     ".addhost"        /* if NOAUTOADDHOST only check if host if this is */
                                          /* at end of a path  */

#define MAXPARTSINHOSTNAME 6 /* only a very few this long and never seen longer */
/* I only know of a couple FTP sites with 6 part names:
    /jp/ac/keio/cs/sync/cs-syncgwy 
    /uk/ac/bpmf/ion/nmr/saturn 

   But there is one host alias (which Alex ignores) with 7 parts:
        web.yl.is.s.u-tokyo.ac.jp
 */


#define MAXFTPSOPEN  10      /* note they also are closed after MAXIDLEFTP */
#define STRANGEOPENCOUNT 10  /* does not count FTPs - should not be this many files open */ 

#define RemTimeZoneFAIL  24*60          /* unreasonable number of minutes */

#define FILLCHAR '_'         /* what strange chars and spaces are replaced with in error messages */

#define MAXPATH 500

#define MAXTOKENS  11
#define MAXTOKENLEN   200

#define RECURSIONOK 1
#define NORECURSION 0

#define NoKillFtps  0
#define YesKillFtps 1

#define BOGUSINODE  123456

#define HOSTDATE 0           /* All hosts show last modification times of Dec 31 1969 (Unix zero) */


/*  C's enumerated types are not really portable and don't mix well with real ints
 *  so I don't use them.
 *
 *  .alex.info needs AFILE, ADIR, ALINK to not change (can remove all .alex.info if need to)
 */
#define AOK    0                   /* function did what was asked - we use fact that is zero */
#define AFAIL  1                   /* function failed */
#define AFILE  2                   /* type info (no failure implied) */
#define ADIR   3                   /* type info  "    "      "       */
#define AERRORMESSAGE    4         /* not a real file just an error message */
                                   /* 5 no longer used */
#define ALINK      6               /* a link on a remote host type info  */
#define NOSUCHFILE 7               /* */
#define AOLD       8               /* failed because we have old directory data              */
#define NOPWD      9               /* failed because it does not do PWD but don't know type  */
#define SOFTERROR  10              /* seems to be the type of error where a retry might work */
#define AEOF       11              /* were reading a file and got to the end                 */
#define AHOST      12              /* a directory for a host                                 */
#define AUPDATE    13              /* we found that directory information is out of date     */
#define AWORKING   14              /* Alex is working on that job but is not yet done        */
#define ANFSSTALE  15              /* Stale NFS Handle                                       */
#define NOSUCHHOST 16              /* even if there used to be such a host, there is not now */
#define ARETRY     17              /* had to update a few things, a retry should work now    */
#define MAKELINKSTOPARENT 18       /* only in dirtoinfo.c                                    */
#define MAKELINKSTOALEX   19       /* only in dirtoinfo.c                                    */
#define REMOVEALWAYS 20            /* always remove (unless just seconds old)                */
#define REMOVEMAYBE  21            /* if old then remove                                     */
#define REMOVENEVER  22            /* do not remove                                          */
#define ADOMAIN      23            /* we have something that is part of a hostname */
         /* XXXXXX UG.  ADOMAIN is in .alex.info as 23 so can not change but is a hosttype   */
         /* so mst be between MinHostType and MaxHostType.  Ug.                              */
         /* we use strings for the types below in HostsList so they can change */
#define MinHostType  ADOMAIN
#define NOANONFTP    ADOMAIN+1        /* this host does not alow anonymous ftp */
#define NEVERDOFTP   ADOMAIN+2        /* this host hates ftp attempts - dmscanb.cbr.dms.csiro.au */
#define UNIX         ADOMAIN+3        /* Unix */
#define ABSUNIX      ADOMAIN+4        /* Unix with absolute paths like /usr0/anon/pub/README */
#define CDMODE       ADOMAIN+5        /* unix but must use CDs to get around */
#define RELMODE      ADOMAIN+6        /* unix but use . as top */
#define DECVMS       ADOMAIN+7        /* VMS */
#define IBM          ADOMAIN+8        /* IBM */
#define TOPS20       ADOMAIN+9        /* TOPS20 */
#define DECTEN       ADOMAIN+10       /* DECTEN */
#define HOSTALIAS    ADOMAIN+11       /* need to keep track of these too - very similar to ALINK */
#define HPUX         ADOMAIN+12       /* only used in dirtoinfo */
#define DECVMS2      ADOMAIN+13       /* only used in dirtoinfo */
#define HENSA	     ADOMAIN+14	      /* uk.ac.hensa.micros */
#define NOVEL	     ADOMAIN+15	      /* Novel */
#define MaxHostType  NOVEL
#define UNKNOWN      MaxHostType+1   /* can not tell type - always largest type number */

#define ALEXINFOVERSION  4           /* changes .alex.info's format changes  */
#define OLDVERSIONTOKEN "()"         /* compatibility with older shit    */
#define METACHAR      '!'             /* non directory info in .alex.info */
#define VERSCHAR      'V'             /* version number (ALEXINFOVERSION) */
#define DATECHAR      'D'             /* date last fetched                */
#define NEWCHAR       'N'             /* date of newest item in directory       */
#define SIZECHAR      'S'             /* 1 if we could parse the sizes of files */
#define HOSTPARTSCHAR 'H'             /* number of parts in hostname "cs.cmu.edu" is 3 */
#define ERRORCHAR     'E'             /* if there then there if a .alex.error type message */
#define UPDATECHAR    'U'             /* force and update on next use of this file */

struct HostEntry {
    char   *Path;                    /* like /edu/berkeley                                        */
    int    Type;                     /* ADOMAIN, UNIX...                                          */
    int    TimeZone;                 /* in minutes from greenwich                                 */
    unsigned int TimeLastCheck;      /* time we last checked with host about this info            */
    char   *TopDir;                  /* for places we keep a topdir for                           */
    char   *SymLink;                 /* if HOSTALIAS                                              */
                                     /* above is stuff that is saved in file below is dynamic     */
    int    Status;                   /* AFAIL / AOK / AWORKING                                    */
    int    NumErrorsSinceOk;         /* 0 add 1 for error clear when worked */
    unsigned int LastUsed;           /* Time last used                                            */
    int    PartsInHostName;          /* /edu/berkeley is 2                                        */
    int    PathLen;                  /* strlen(Path) = strlen("/edu/berkeley") = 13               */
    float  RespTime;
    float  KBPSec;
};

extern char SERVERHOSTNAME[];        /* name of host running alex  - myhostname  */

extern struct HostEntry *HostsTable[];    /* mostly just in alex but dirtoinfo uses too */
extern int HostsInTable;

struct ParsedDir {
    int          Type;               /* AFILE, ADIR, ALINK, AHOST    */
#ifdef EXECUTABLE
        int          Executable;                 /* if the file is trusted as executable */
#endif
    unsigned int Date;               /* same as NFS                  */
    unsigned int Size;               /* same as NFS                  */
    unsigned int Inode;              /* same as NFS                  */
    int          CacheStatus;        /* 0=NotThere  1=There          */
    char Name[MAXPATH];              /* like foo                     */
    char SymLink[MAXPATH];           /* except for /afs and /alex the link should be relative */
    int          Stale;              /* 0 if consistent enough 1 if stale */
    int          SizeTrusted;        /* 1 if sizes come from trusted .alex.dir like UNIX ones */
    int PartsInHostName;             /* cs.cmu.edu is 3                          */
};

struct ActiveAlexInfo {
    int  Version;
    char OpenAlexInfoPath[MAXPATH];  /* path used for open of .alex.info              */
    int PartsInDirPath;              /* /usr2/alex-cache/edu/berkeley/.alex.info is 2 i.e. after CACHEDIR */
    unsigned int UpdateDate;         /* date of last fetch of .alex.dir               */
    unsigned int NewestDate;         /* date of newest item in directory              */
    int SizeOk;                      /* 1=parsed good sizes,  0=don't know sizes      */
    FILE *File;
    int PartsInHostName;             /* cs.cmu.edu is 3                               */
    int HasAlexError;                /* an .alex.error was included in this           */
    int NeedAnUpdate;                /* an old .alex.error was included in this - need an update */
};


extern unsigned int InodeNext;

/* UidToUidStr module */
extern char  LastUidStr[];
extern char  *UidToUidStr();
extern void   ClearKnownUsers();
extern int    NumKnownUsers;
extern int    NumDiffKnownUids();


extern SetUidGid();

/* Friendly string operations */
#define streql(x, y)    (!(strcmp(x, y)))
extern int WhereString();
extern int HasStringNoCase();
extern int HasString();
extern int HasChar();
extern int CountOccurances();
extern int StrLastNCmp();
extern char *strsave();

/* Destructive string operations  */
extern int ChopAtCR();
extern int RemoveTrailingSlash();
extern int RemoveDot();
extern int RemoveDotDot();
extern int SimplifyPath();
extern int NoTrailingSpaces();
extern int RemoveThroughSlash();
extern int RemoveTrailingC();

extern int   afclose();
extern FILE *afopen();

extern char *GetNthToken();
extern char *GetNextToken();
extern GetLastToken();

extern int DirToInfo();
extern int EmptyToInfo();
extern int OneLineIn();
extern int OneLineOut();
extern CopyParsedDir();

extern char *ATypeToString();
extern int StringToAType();
extern int IsAHostType();

extern int AlexStat();
extern int LiteStat();

extern double TimeInSeconds();
extern double RecentTime;
extern double GreenTimeInSeconds();
extern int StringToTimeb();
extern int StringToTimeInt();
extern double LastTimeChange;

extern double MTimeOfFile();
extern double SecsSinceWrite();

extern int AlarmIgnore();

extern int CheckFileCache();
extern int CloseAndDie();
extern int HisClockIsOK();
extern int RemTimeZone();
extern int AlexInit();
extern int TouchFile();

extern int PathToFileName();       /* /foo/bar/baz to baz      */
extern int PathToDir();            /* /foo/bar/baz to /foo/bar */

/*  converstion between            /* /edu/berkeley and berkeley.edu */
extern int HostNameToPath();
extern void PathToHostName();


extern int AlexInfoCompatStat();   /* returns a regular stat buf */
extern int AlexInfoLStat();
extern int SimpleType();           


extern int LocateHostEntry();
extern void ToLower();

extern int InvalidateStatCache;    /* readinfo should not trust its cache after alex changes world */

extern int AlexInfoInNext();
extern int AlexInfoInClose();
extern int AlexInfoInOpen();
extern int AlexOpenDir();
extern unsigned int AlexInfoMTime();


extern int LineToTokens();         /* string to array of token strings */

extern SetUsrX();
extern int CopyAFile();



#define Return return

extern char * strerror();

extern int StringIntoFile();
extern int StringFromFile();
extern int StringToUnsigned();

extern int RecursiveRm();

extern int SpecialFileName();

/*  doanftp.c */
extern int IgnoreSIGPIPE();
extern int CloseAllFtpCaches();
extern int ClearFtpCacheEntry();
extern int DoAnFtp();
extern int CheckFileStatus();
extern int HaveResultFile();
extern int InTransit();
extern void KillOldFtps();

/* known stale stuff  */
extern void SaveKnownStaleFilePath();
extern void ClearKnownStaleFilePath();
extern int IsKnownStale();


extern int FilesAreEqual();


/* Performance results */
extern double InitTime;

extern double TotalBytesNFSed;
extern double TotalBytesFTPed;
extern double TotalFTPTime;
extern int    NumFinishedFTPs;

extern int    TotalFilesNFSed;
extern int    TotalFilesFTPed;
extern double TotalFileBytesNFSed;
extern double TotalFileBytesFTPed;

extern int    TotalFtpsForked;

extern int    TotalDirsNFSed;
extern int    TotalDirsFTPed;
extern double TotalDirBytesNFSed;
extern double TotalDirBytesFTPed;

extern int    LookupHits;
extern int    LookupMisses;
extern int    LookupDrops;

extern int    ReadHits;
extern int    ReadMisses;
extern int    ReadDrops;

extern int    ReadDirHits;
extern int    ReadDirMisses;
extern int    ReadDirDrops;

extern int    TotalStaleFiles;
extern int    TotalStaleSecs;

extern double TotalNFSLS;
extern double TotalFTPLS;

extern void   AlexAssertFailed();
extern void   PhoneHome();

extern int    TotalGHBNCalls;
extern double TotalGHBNTime;
extern double TotalGHBNTimeSQ;
extern int    TotalRTZCalls;
extern double TotalRTZTime;
extern double TotalRTZTimeSQ;

extern int    NumAlexUpdates;

extern int    TotalErrorMsg;
extern int    TotalUnchangedDirs;



#ifndef FALSE
#define FALSE 0                     /* probably only used for AlexAssert(FALSE)  */
#endif

extern int h_errno;

extern int    SortFile();
extern int    PrependLineToFile();

#define ALEXVERSION "Thu Apr 6 01:15:31 EDT 1995"
