/*
 * rvfs.c -- readvfs() function for lsof library
 */


/*
 * Copyright 1997 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


#include "../machine.h"

#if	defined(USE_LIB_READVFS)

# if	!defined(lint)
static char copyright[] =
"@(#) Copyright 1997 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: rvfs.c,v 1.1 97/02/24 07:29:53 abe Exp $";
# endif	/* !defined(lint) */

#include "../lsof.h"


/*
 * The caller must define RVFS_DEVSAVE to enable the saving of the
 * device number in the local vfs structure.
 */


/*
 * readvfs() - read vfs structure
 */

struct l_vfs *
readvfs(ka)
	struct vfs *ka;			/* vfs structure kernel address */
{
	struct l_vfs *vp;

	if (!ka)
		return(NULL);
	for (vp = Lvfs; vp; vp = vp->next) {
		if (ka == vp->addr)
			return(vp);
	}
	if ((vp = (struct l_vfs *)malloc(sizeof(struct l_vfs))) == NULL) {
		(void) fprintf(stderr, "%s: PID %d, no space for vfs\n",
			Pn, Lp->pid);
		Exit(1);
	}

#if	defined(RVFS_DEVSAVE)
	vp->dev = 0;
#endif

	vp->dir = NULL;
	vp->fsname = NULL;

#if	defined(HASFSINO)
	vp->fs_ino = 0;
#endif	/* defined(HASFSINO) */

	vp->next = Lvfs;
	vp->addr = ka;
	Lvfs = vp;
	return(vp);
}
#else	/* !defined(USE_LIB_READVFS) */
static char d1[] = "d"; static char *d2 = d1;
#endif	/* defined(USE_LIB_READVFS) */
