#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>

static char *servname = "finger";
static char *hostname = "ftp.uu.net";

int main(int argc, char **argv) {
    struct servent *sp;
    struct hostent *hp;

    fprintf(stderr, "Hi\n");

    if (argc > 1) servname = argv[1];
    if (argc > 2) servname = argv[2];

    if ((sp  = getservbyname(servname, "tcp")) == NULL) {
	fprintf(stderr, "Unable to resolve service name: %s\n", servname);
	exit(-1);
    }

    fprintf(stderr, "Hi again\n");
    hp = gethostbyname(hostname);

    if (strcmp(sp->s_name, servname)) {
	fprintf(stderr, "Test failed, gethostbyname clobbered service name: %s -> %s\n", servname, sp->s_name);
	exit(-1);
    }

    fprintf(stderr, "Test succeeded, gethostbyname didn't change a thing\n");
    exit(0);
}
