/*
 * (C)opyright 1995 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "var.h"
#include "misc.h"

#ifndef	lint
static	char	sccsid[] = "@(#)prscd.c	1.2 10/24/95 (C) 1995 Darren Reed";
#endif

static	int	order[] = { VA_FMASK, VA_TMASK, VA_FNET, VA_FPORT, VA_PROTO,
			    VA_TNET, VA_TPORT, VA_ACTION,
			    VA_LOG, -1 };
static	int	aclbase = 100;

extern	var_t	*varlist;


static	char	*genmask(mask)
char	*mask;
{
	struct	in_addr	addr;
	int	i, j;

	if (strchr(mask, '.')) {
		addr.s_addr = inet_addr(mask);
		addr.s_addr = ~addr.s_addr;
		return inet_ntoa(addr);
	}

	i = atoi(mask);
	if (i > 32)
		i = 32;
	for (j = 0; (i > 0); i--)
		j |= 1 << i;
	addr.s_addr = j;
	return inet_ntoa(addr);
}


static	void	printaction(str, opt)
char	*str;
int	opt;
{
	int	bits = 0;

	if (strstr(str, "block"))
		bits |= 1;
	if (strstr(str, "pass"))
		bits |= 2;
	if (strstr(str, "log"))
		bits |= 8;

#ifdef	DEBUG
	printf("printaction(%s,%d) = %#x\n", str, opt, bits);
#endif
	if (!opt)
		if (bits & 1)
			printf(" reject");
		else if (bits & 2)
			printf(" accept");
	if (opt)
		if (bits & 8)
			printf(" log");
}


void	printscreend(lvl)
int	lvl;
{
	var_t	*v, *v2;
	char	*proto, *pcmp, *s;
	int	i, j, k, lastset = -1, aclbase = 100;

	for (i = 0; i < VA_MAX; ) {
		j = i;
		if ((k = order[i]) == -1)
			break;
		for (v = varlist; v; v = v->va_next) {
			if ((k == VA_ACTION) && v->va_action) {
				printaction(v->va_action, 0);
				lastset = k;
				i++;
				break;
			}

			if ((k == VA_INOUT) && v->va_inout) {
				lastset = k;
				i++;
				break;
			}

			if ((k == VA_LOG) && v->va_action) {
				printaction(v->va_action, 1);
				lastset = k;
				i++;
			}

			if (k == VA_PROTO) {
				if (!(proto = v->va_proto) && !v->va_lvl)
					proto = "ip";
				if (proto) {
					lastset = k;
					printf(" proto %s", proto);
					i++;
					break;
				}
			}

			if ((k == VA_FHOST || k == VA_FNET) &&
			    (v->va_net[0] || v->va_host[0])) {
				if (v->va_net[0])
					printf(" net %s",
						hostnum(v->va_net[0]));
				else
					printf(" host %s",
						hostnum(v->va_host[0]));
				v2 = v;
				lastset = k;
				i++;
				break;
			}

			if (((k == VA_FMASK) && v->va_mask[0]) && v2) {
				if ((lastset == VA_FNET) && v2->va_net[0]) {
					printf("for %s netmask is %s;\n",
						v->va_net[0],
						genmask(v->va_mask[0]));
					lastset = k;
					i++;
				}
				v2 = NULL;
				break;
			}

			if ((k == VA_FPORT) && (s = v->va_port1[0])) {
				if (strcasecmp(proto, "udp") &&
				    strcasecmp(proto, "tcp")) {
					synerr("port field & not udp/tcp\n");
					break;
					i++;
				}
				pcmp = v->va_portcmp[0];
				if (pcmp && (!strcmp(pcmp, "=") &&
					     !strcmp(pcmp, "!=")))
					synerr("unsupported operator: %s\n",
						pcmp);
				else if (!v->va_port2[0]) {
					printf(" port%s %d",
						strchr(pcmp, '!') ? "-not":"",
						portnum(s, proto));
					lastset = k;
					i++;
				} else
					synerr("no port ranges on screend\n");
				break;
			}

			if ((k == VA_THOST || k == VA_TNET) &&
			    (v->va_net[1] || v->va_host[1])) {
				if (v->va_net[1])
					printf(" host %s",
						hostnum(v->va_net[1]));
				else
					printf(" net %s",
						hostnum(v->va_host[1]));
				lastset = k;
				i++;
				v2 = v;
				break;
			}

			if (((k == VA_TMASK) && v->va_mask[1]) && v2) {
				if ((lastset == VA_TNET) && v2->va_net[1]) {
					printf("for %s netmask is %s;\n",
						v->va_net[1],
						genmask(v->va_mask[1]));
					lastset = k;
					i++;
				}
				v2 = NULL;
				break;
			}

			if ((k == VA_TPORT) && (s = v->va_port1[1])) {
				if (strcasecmp(proto, "udp") &&
				    strcasecmp(proto, "tcp")) {
					synerr("port field & not udp/tcp\n");
					break;
					i++;
				}
				pcmp = v->va_portcmp[1];
				if (pcmp && (!strcmp(pcmp, "=") &&
					     !strcmp(pcmp, "!=")))
					synerr("unsupported operator: %s\n",
						pcmp);
				else if (!v->va_port2[0]) {
					printf(" port%s %d",
						strchr(pcmp, '!') ? "-not":"",
						portnum(s, proto));
					lastset = k;
					i++;
				} else
					synerr("no port ranges on screend\n");
				break;
			}
		}
		if (!v) {
			if ((k == VA_FNET) || (k == VA_FHOST))
				printf(" any");
			else if ((k == VA_TNET) || (k == VA_THOST))
				printf(" any");
			v2 = NULL;
		}
		if (i == j)
			i++;
	}
	printf(";\n");
}


emitscreend()
{
	var_t   *v;
	char	*s;
	int	ifn;

	if (!(v = varlist))
		return;
	if (!v->va_iface)
		fprintf(stderr, "No interface defined\n");
	if ((v->va_policy & (VP_ACTION|VP_INOUT)) == (VP_ACTION|VP_INOUT)) {
		printf("default");
		printf(" %s", strstr(v->va_action, "pass") ? "accept" :
							     "reject");
	}

	printf(";\n");
	clear_policy(v);
}
