/* Copyright (c) 1996 NEC Corporation.  All rights reserved.                 */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("COPYRIGHT") included with this distribution.                   */
#include "socks5p.h"
#include "buffer.h"
#include "addr.h"
#include "protocol.h"
#include "confutil.h"
#include "wrap.h"
#include "msg.h"

#define DONT_NEED_SIGBLOCK
#define DONT_NEED_SIGPAUSE
#define DONT_NEED_SIGUNBLOCK
#define DONT_NEED_SIGPENDING
#include "sigfix.h"

#define BUFLEN 2048

static S5IOInfo cinfo;
sig_atomic_t hadsigint;

static RETSIGTYPE HandleINT() {
    hadsigint = 1;
}

int InitProxy(CONST S5NetAddr *proxy, const S5NetAddr *dst, u_char command, u_char flags) {
    S5NetAddr rsin;
    u_char err, res;
    int fd;

    if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0)     return -1;
    if (connect(fd, &proxy->sa, lsAddrSize(proxy)) < 0) return -1;
    if (dup2(fd, STDIN_FILENO) < 0)                     return -1;

    Signal(SIGPIPE, SIG_IGN);
    close(fd);

    S5BufSetupContext(&cinfo);
    cinfo.fd   = STDIN_FILENO;
    
    if (lsProtoExchg(STDIN_FILENO, &cinfo, dst, lsEffUser(), SOCKS5_VERSION, command, flags) < 0) return -1;
    return lsReadResponse(STDIN_FILENO, &cinfo, &rsin, SOCKS5_VERSION, &err, &res);
}

void DataRelay(void) {
    char msgbuf[BUFLEN];
    int n;

    Signal(SIGINT,  HandleINT);
    Signal(SIGQUIT, HandleINT);
    
    for (;;) {
	n = S5IORecv(STDIN_FILENO, &cinfo, msgbuf, BUFLEN, 0, 0, NULL);

	if (n == 0 || (n < 0 && errno != EINTR)) {
	    break;
	}

	if (n < 0 && hadsigint) {
	    msgbuf[0] = '\0';
	    hadsigint = 0;
	    S5IOSend(STDIN_FILENO, &cinfo, msgbuf, 1, MSG_OOB, S5_IOFLAGS_RESTART|S5_IOFLAGS_NBYTES, NULL);
	    continue;
	}

	if (S5IOSend(STDOUT_FILENO, NULL, msgbuf, n, 0, S5_IOFLAGS_RESTART|S5_IOFLAGS_NBYTES, NULL) < 0) {
	    break;
	}
    }

    Signal(SIGINT,  SIG_DFL);
    Signal(SIGQUIT, SIG_DFL);
}

