/*
 * monInt.h --
 *
 *      Declarations of the internal features of Monitor
 *      which are not exported out of the package.
 *
 * Copyright(C) 1995, 1996 NEC Corporation. All rights reserved.
 * This is a genuine component of Socks5Toolkit(TM).
 *
 * $Header: /insg/project/socks/s5watch/include/monInt.h,v 1.4 1997/08/25 19:10:38 miked Exp $
 * $Log: monInt.h,v $
 * Revision 1.4  1997/08/25 19:10:38  miked
 * Changed MON_NAME to actual executable name.
 *
 * Revision 1.3  1997/02/06  19:20:46  miked
 * Moved monLogHandle here since it will be used only by server code.
 *
 * Revision 1.2  1997/02/01  06:22:46  miked
 * Merged OSTC/NT and NWSL/UNIX versions.
 *
 * Revision 1.2  1996/09/05 21:22:21  naomi
 * Changes to where Jonathan left off...
 * Revision 1.1  1996/09/04 21:43:07  naomi
 * Initial revision
 * Revision 1.1.1.1  1996/08/30 02:43:49  miked
 * Initial version.
 *
 * Revision 1.9  1996/07/31  23:39:50  miked
 * Added mon_DbPass[].
 *
 * Revision 1.8  1996/07/31  20:11:01  miked
 * Added #define MON_DB_NAME
 *
 * Revision 1.7  1996/07/30  21:00:59  miked
 * Yet another copyright notice.
 *
 * Revision 1.6  1996/07/15  22:58:01  miked
 * Removed handle parameter from MonSocksServer(), MonGUIServer().
 *
 * Revision 1.5  1996/07/12  02:10:47  miked
 * Named handle parameter to MonSocksServer(), MonGUIServer() memHandle.
 *
 * Revision 1.4  1996/07/12  02:03:23  miked
 * Added #define MON_PID_NAME to hold Monitor main process PID.
 *
 * Revision 1.3  1996/07/11  04:31:23  miked
 * Added #define MON_FIFO_NAME
 *
 * Revision 1.2  1996/07/09  23:57:46  miked
 * Added new copyright notice.
 *
 * Revision 1.1.1.1  1996/07/08  15:09:43  miked
 * Initial version for Socks5 API.
 */

#ifndef _H_MONINT
#define _H_MONINT

#include "monPort.h"

/*
 *----------------------------------------------------------------------
 *    C O N S T A N T S
 *----------------------------------------------------------------------
 */

#define MON_VERSION        "1.1"
#define MON_MAJOR_VERSION   1
#define MON_MINOR_VERSION   1
#define MON_NAME            "socks5watchAG"
#define MON_DB_NAME         "socks5database"

#define MON_PATH_PREFIX     "/tmp/"
#define MON_PID_NAME        "mon.pid"
#define MON_FREE_MUTEX_NAME "mon.free.mutex"
#define MON_HASH_MUTEX_NAME "mon.hash.mutex"

#ifdef WIN32
#define MON_PERF_MEM_NAME   "mon_counter_block"
#define MON_MMAP_NAME       "monmmap.map"
#define MON_FIFO_NAME       "\\\\.\\PIPE\\mon.pip"

#else /* UNIX */
#define MON_MMAP_NAME       "mon.mmap"
#define MON_FIFO_NAME       "mon.fifo"
#endif /* !WIN32 */

/*
 *----------------------------------------------------------------------
 *    P R O C E D U R E S
 *----------------------------------------------------------------------
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Monitor server process handles TCP/IP connections from GUI client(s).
 */

EXTERN void FAR
MonGUIServer();

EXTERN void FAR
MonGUICleanup();

/*
 * Monitor server process handles FIFO from Socks.
 */

EXTERN void FAR
MonSocksServer();

/*
 * Monitor subprocess stores Socks5 data records into data base.
 */

EXTERN void FAR
MonDatabase();

#ifdef __cplusplus
}
#endif

EXTERN char             mon_DbName[];     /* Data base name */
EXTERN char             mon_DbHost[];     /* Data base server host */
EXTERN char             mon_DbPass[];     /* Data base password file */
EXTERN int              mon_DbPort;       /* Data base TCP/IP port */

EXTERN VOID*            MonLogHandle;

#endif /* _H_MONINT */
