/*
 * monAPI.h --
 *
 *      This header file describes the externally-visible facilities
 *      exported to Monitor clients.
 *
 * Copyright(C) 1995, 1996 NEC Corporation. All rights reserved.
 * This is a genuine component of Socks5Toolkit(TM).
 *
 * $Header: /insg/project/socks/s5watch/include/monAPI.h,v 1.5 1997/02/10 23:41:35 miked Exp $
 * $Log: monAPI.h,v $
 * Revision 1.5  1997/02/10 23:41:35  miked
 * Added parameter `all' to S5MonRecvNextData().
 *
 * Revision 1.4  1997/02/06  19:19:06  miked
 * Moved MonLogHandle to monInt.h since it will be used only by server code.
 * Moved MON_MMAP_EVENT to monMmap.h where it belongs.
 *
 * Revision 1.3  1997/02/06  01:43:15  miked
 * Fixed a couple of ()'s in the last release's macros.
 *
 * Revision 1.2  1997/02/06  00:07:07  miked
 * Redefined S5_MON_KEY_SIZE and added portable macros to access the key.
 *
 * Revision 1.6  1996/10/24 21:47:03  naomi
 * Reversed definitions of S5_MON_PERF and S5_MON_GUI
 * Revision 1.5  1996/10/07 18:08:05  naomi
 * added a macro for an event to signal for mmap's availability
 * (MON_MMAP_EVENT) -- mainly for SocksCop's benefit
 * Revision 1.4  1996/09/18 13:01:45  naomi
 * define an extern handle MonLogHandle (as opposed to using the
 * default log handle defined in log.h)
 * Revision 1.3  1996/09/06 22:05:12  naomi
 * Got rid of definition of S5MonGetLastErr()
 * Revision 1.2  1996/09/05 21:22:14  naomi
 * Changes to where Jonathan left off...
 * Revision 1.1  1996/09/04 21:43:01  naomi
 * Initial revision
 * Revision 1.1.1.1  1996/08/30 02:43:49  miked
 * Initial version.
 *
 * Revision 1.8  1996/07/30  13:51:57  miked
 * Added S5_MON_DATABASE for Monitor's database store subprocess.
 *
 * Revision 1.7  1996/07/17  21:13:30  miked
 * Removed #define S5_ERRMSG_SIZE, S5_APPNAME_SIZE because socks5api.h now has.
 *
 * Revision 1.6  1996/07/15  22:56:27  miked
 * Redefined S5_LINK_END, added definition for S5_LINK_ACTIVE.
 *
 * Revision 1.5  1996/07/12  22:43:34  miked
 * Removed #include "defs.h"
 *
 * Revision 1.4  1996/07/12  02:01:42  miked
 * *** empty log message ***
 *
 * Revision 1.3  1996/07/09  23:57:42  miked
 * Added new copyright notice.
 *
 * Revision 1.2  1996/07/08  20:02:08  miked
 * Made errNumPtr in S5MonGetLastError() Sint32 FAR* instead of int FAR*.
 *
 * Revision 1.1.1.1  1996/07/08  15:09:42  miked
 * Initial version for Socks5 API.
 */

#ifndef _H_MONAPI
#define _H_MONAPI

#ifdef WIN32
#include <time.h>
#include <winsock.h>
#endif /* WIN32 */

#include "monPort.h"
#include "socks5api.h"

/*
 *----------------------------------------------------------------------
 *    C O N S T A N T S
 *----------------------------------------------------------------------
 */

/*
 * Enumeration of Monitor client types.
 */

#define S5_MON_SELF       0           /* Monitor itself (r/w) */
#define S5_MON_SOCKS5     1           /* Socks5 server (w) */
#define S5_MON_SNMP       2           /* SNMP agent (r) */
#define S5_MON_ALARM      3           /* Alarm raising agent (r) */
#define S5_MON_DATABASE   4           /* Database store process (r) */
#define S5_MON_PERF_DLL   5           /* Remote perfmon dll (r) (NT) */
#define S5_MON_GUI        6           /* Remote GUI client (r) */
                                      /* 6,7,8,9 (=MON_MAX_GUIS) reserved */

/*
 * Bit definitions for `state' field of struct S5MonData.
 * (State bits are not mutually exclusive, more than one bit may be set).
 */
                                   /* Maintained on a per client basis */
#define S5_LINK_START     (1UL<<0)    /* New Socks5 data record */
#define S5_LINK_UPDATE    (1UL<<1)    /* Update on a Socks5 data record */
#define S5_LINK_ERROR     (1UL<<2)    /* Error on a Socks5 data record */
#define S5_LINK_END       (1UL<<3)    /* End on a Socks5 data record */

                                   /* Not readable by clients */
#define S5_LINK_MULTIPLE  (1UL<<30)   /* Socks5 UDP multiple destinations */
#define S5_LINK_ACTIVE    (1UL<<31)   /* Active Socks5 data record */


/*
 * Miscellaneous size definitions.
 * Size of Monitor key = process ID + thread handle/ID + connection number.
 */

#define S5_MON_KEY_SIZE   (sizeof(Uint32) + sizeof(Uint32) + sizeof(Uint16))

#define GET_PID_FROM_KEY(PID, KEY) (memcpy(&PID, &KEY, sizeof(Uint32)))
#define PUT_PID_IN_KEY(PID, KEY)   (memcpy(&KEY, &PID, sizeof(Uint32)))

#define GET_THREAD_FROM_KEY(THREAD, KEY) \
        (memcpy(&THREAD, ((char *) &KEY + sizeof(Uint32)), sizeof(Uint32)))
#define PUT_THREAD_IN_KEY(THREAD, KEY) \
        (memcpy(((char *) &KEY + sizeof(Uint32)), &THREAD, sizeof(Uint32)))

#define GET_CONN_FROM_KEY(CONN, KEY) \
        (memcpy(&CONN, ((char *) &KEY + 2 * sizeof(Uint32)), sizeof(Uint16)))
#define PUT_CONN_IN_KEY(CONN, KEY) \
        (memcpy(((char *) &KEY + 2 * sizeof(Uint32)), &CONN, sizeof(Uint16)))

#define S5_OPTDATA_SIZE   512         /* Max size optional user data */

/*
 *----------------------------------------------------------------------
 *    D A T A   S T R U C T U R E S
 *----------------------------------------------------------------------
 */

typedef VOID FAR* S5MonHandle;        /* Opaque handle */
typedef Uint32    S5Count;            /* Monitor counter at least 32-bits */
typedef time_t    S5Time;             /* Monitor time field */


/*
 * Random access key for Socks5 data record in Monitor's table.
 */

typedef struct {
    char          key[S5_MON_KEY_SIZE];
} S5MonKey;


/*
 * Socks5 optional user-specified data passed to Monitor.
 *
 * Note: `len' field must be set correctly, (0 <= len <= S5_OPTDATA_SIZE).
 * All data fields must be maintained in network byte order.
 * It is the responsibility of the user to do the conversions
 * between host byte order and network byte order.
 */

typedef struct {
    Uint16        len;                   /* Length of following data */
    char          data[S5_OPTDATA_SIZE]; /* Variable length user data */
} S5OptData;


/*
 * Socks5 data record in Monitor's table.
 */

typedef struct {
    S5MonKey      key;            /* Key used to random access this data rec */
    S5MonKey      nextKey;        /* Key for next UDP destination data rec */
    S5Count       totConns;       /* Total Socks5 connections */
    Uint32        state;          /* State of Socks5 data record */

    S5Time        startTime;      /* Start time */
    S5Time        curTime;        /* Current time */
    S5Time        endTime;        /* Termination time */
    S5Time        readTime;       /* Last access time by client program */
    S5Count       inTotBytes;     /* Total input bytes xferred */
    S5Count       outTotBytes;    /* Total output bytes xferred */
    Uint32        socksErr;       /* Socks5 error */
    Uint16        authen;         /* Authentication method used in proxy */
    Uint16        socksCmd;       /* Proxy command */

    S5NetAddr     srcSockAddr;    /* Source address */
    S5NetAddr     dstSockAddr;    /* Destination address */
    S5NetAddr     proxySockAddr;  /* Proxy address */

    char          srcHostName  [S5_HOSTNAME_SIZE]; /* Source Host name */
    char          dstHostName  [S5_HOSTNAME_SIZE]; /* Destination Host name */
    char          proxyHostName[S5_HOSTNAME_SIZE]; /* Next proxy host name */

    char          userName     [S5_USERNAME_SIZE]; /* User Name */
    char          appName      [S5_APPNAME_SIZE];  /* Application name */
    char          socksErrMsg  [S5_ERRMSG_SIZE];   /* Socks5 error message */

    S5OptData     optData;                         /* Optional user data */
} S5MonData;

/*----------------------------------------------------------------------
 *    P R O C E D U R E S
 *----------------------------------------------------------------------
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Open TCP/IP data transfer channel to Monitor.
 * Returns opaque handle in *handlePtr.
 * Returns 0 on success; -1 on failure.
 */

EXTERN int
S5MonNetOpen _ANSI_ARGS_((
    CONST char FAR*      hostName,   /* IN  -- Hostname of firewall */
    int                  clientType, /* IN  -- Type of Client */
    S5MonHandle FAR*     handlePtr   /* OUT -- Ptr to opaque handle returned */
));


/*
 * Open bidirectional data transfer to Monitor's shared memory area.
 * Returns opaque handle in *handlePtr.
 * Returns 0 on success; -1 on failure.
 */

EXTERN int
S5MonMemOpen _ANSI_ARGS_((
    CONST char FAR*      memName,    /* IN  -- Shared memory area name */
    int                  clientType, /* IN  -- Type of Client */
    S5MonHandle FAR*     handlePtr   /* OUT -- Ptr to opaque handle returned */
));


/*
 * Open unidirectional data transfer FIFO to Monitor.
 * Returns opaque handle in *handlePtr.
 * Returns 0 on success; -1 on failure.
 */

EXTERN int
S5MonFifoOpen _ANSI_ARGS_((
    CONST char FAR*      fifoName,   /* IN  -- FIFO name */
    int                  clientType, /* IN  -- Type of Client */
    S5MonHandle FAR*     handlePtr   /* OUT -- Ptr to opaque handle returned */
));


/*
 * Close opaque handle and object associated with it.
 * Returns 0 on success; -1 on failure.
 */

EXTERN int
S5MonClose _ANSI_ARGS_((
    S5MonHandle          handle      /* IN -- Opaque handle */
));


/*
 * Insert Socks5 data record into Monitor's table by key.
 * Returns 0 on success; -1 on failure.
 */

EXTERN int
S5MonSendData _ANSI_ARGS_((
    S5MonHandle          handle,     /* IN -- Opaque handle */
    S5MonData FAR*       dataPtr     /* IN -- Pointer to Data */
));

/*
 * Retrieve Socks5 data record from Monitor by key.
 * Returns 0 on success; -1 on failure.
 */

EXTERN int
S5MonRecvData _ANSI_ARGS_((
    S5MonHandle          handle,     /* IN -- Opaque handle */
    S5MonData FAR*       dataPtr     /* IN/OUT -- Specify key, return data */
));

/*
 * Get data from current position in table, iterate through table.
 * If Boolean all is TRUE, every connection in the table is returned
 * irrespective of whether it was updated since the last scan.
 * Returns > 0 on success; 0 on no more data; -1 on error.
 */

EXTERN int
S5MonRecvNextData _ANSI_ARGS_((
    S5MonHandle          handle,     /* IN -- Opaque handle */
    unsigned int         all,        /* IN -- Boolean, if TRUE get all data */
    S5MonData FAR*       dataPtr     /* IN/OUT -- Return data; goto next */
));

#ifdef __cplusplus
}
#endif

#endif /* _H_MONAPI */
