/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1993.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XFTP shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XFTP for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <X11/Intrinsic.h>
#include <sys/param.h>
#include <string.h>
#include "xftp.h"

char *strrchr();


/*
 * parse_path_to_links - Parses the path name into its constituent links. 
 *                       parse_path_to_links returns a pointer to an array
 *                       of pointers to the link names.  The last entry
 *                       in the array is a NULL pointer.  If a failure
 *                       occurs, a NULL value is returned.  Call
 *                       release_path_links() to free memory returned
 *                       parse_path_to_links.
 */
char **
parse_path_to_links(path)
char *path;
{
	int i;
	char *p;
	char *q;
	char *pathcopy;
	char **links;
	int nlinks;

	/* Check for null path name */
	if (path[0] == '\0')
		return NULL;

	/* Need to copy path because routine strtok() is destructive */
	pathcopy = XtNewString(path);

	/* Allocate space for array of link names */
	links = (char **)XtMalloc(sizeof(char *)*(MAXLINKS+1));
		
	/* Special case first link of full path name */
	if (pathcopy[0] == '/') {
		links[0] = XtNewString("/");
		p = &pathcopy[1];
		nlinks = 1;
	} else {
		p = pathcopy;
		nlinks = 0;
	}

	/* Loop through links of path name */
	while ((q=strtok(p, "/")) != NULL) {
		if (nlinks == MAXLINKS)
			goto error;
		links[nlinks++] = XtNewString(q);
		p = NULL;
	}

	/* Success */
	links[nlinks] = NULL;
	XtFree(pathcopy);
	return links;

	/* Failure */
error:
	XtFree(pathcopy);
	for (i=0; i<nlinks; i++)
		XtFree(links[i]);
	XtFree((char *)links);
	return NULL;
}


/*
 * release_path_links - Release the memory returned by parse_path_to_links().
 */
release_path_links(links)
char **links;
{
	char **ptr = links;
	
	/* Check for null pointer */
	if (links == NULL)
		return;

	/* Release memory */
	while (*ptr)
		XtFree(*ptr++);
	XtFree ((char *)links);
	links = NULL;
}


/*
 * reverse_link_order - Reverse the order of the directory links in the
 *                      array returned by parse_path_to_links().
 */
reverse_link_order(links)
char **links;
{
	int nlinks = 0;
	int nlim;
	int i;
	char **ptr = links;
	char *temp;

	while (*ptr++)
		nlinks++;

	nlim = nlinks/2;

	for (i=0; i<nlim; i++) {
		temp = links[i];
		links[i] = links[nlinks-1-i];
		links[nlinks-1-i] = temp;
	}
}


/*
 * parse_path - Parses path name, "path", into its constituent directory,
 *              "dir", and name, "name.  "dir" and "name" will be set to
 *              NULL if they are not given in "path".  The caller is
 *              responsible for calling XtFree() to release memory.
 */
parse_path(path, dir, name)
char *path;
char **dir;
char **name;
{
    char *ptr;
    int name_len;
    int path_len;
    int dir_len;


    *dir = NULL;
    *name = NULL;

    if (path == NULL)
        return;

    path_len = strlen(path);
    ptr = strrchr(path, '/');

    if (ptr == NULL) {
        if (path_len != 0) {
            *name = XtMalloc(path_len+1);
            strcpy(*name, path);
        }
    } else {
        name_len = path_len-(ptr-path+1);
        if (name_len != 0) {
            *name = XtMalloc(name_len+1);
            strcpy(*name, ptr+1);
        }
        if (ptr == path)
            *dir = XtNewString("/");
        else {
            dir_len = ptr-path;
            *dir = XtMalloc(dir_len+1);
            strncpy(*dir, path, dir_len);
            (*dir)[dir_len] = '\0';
        }
    }
}
