/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

const char *
lntoa(addr)
u_long addr;
{
    static int i = 0;
    static char bufs[8][20];
    unsigned char *p = (unsigned char *) &addr;

    i = (i + 1) % (sizeof bufs / sizeof bufs[0]);
    sprintf(bufs[i], "%d.%d.%d.%d", p[0], p[1], p[2], p[3]);
    return (bufs[i]);
}

const char *logtype[] =
{
    "Monitor request",
    "Hello",
    "DB Description",
    "Link-State Req",
    "Link-State Update",
    "Link-State Ack",
    "Monitor response",
    "Hello",
    "DB Description",
    "Link-State Req",
    "Link-State Update",
    "Link-State Ack",
    "IP: Bad OSPF pkt type",
    "IP: Bad IP Dest",
    "IP: Bad IP proto id",
    "IP: Pkt src = my IP addr",
    "OSPF: Bad OSPF version",
    "OSPF: Bad OSPF checksum",
    "OSPF: Bad intf area id",
    "OSPF: Area mismatch",
    "OSPF: Bad virt link info",
    "OSPF: Auth type != area type",
    "OSPF: Auth key != area key",
    "OSPF: Packet is too small",
    "OSPF: Packet size > IP length",
    "OSPF: Transmit bad",
    "OSPF: Received on down IF",
    "Hello: IF mask mismatch",
    "Hello: IF hello timer mismatch",
    "Hello: IF dead timer mismatch",
    "Hello: Extern option mismatch",
    "Hello: Nbr Id/IP addr confusion",
    "Hello: Unknown Virt nbr",
    "Hello: Unknown NBMA nbr",
    "DD: Unknown nbr",
    "DD: Nbr state low",
    "DD: Nbr's rtr = my rtrid",
    "DD: Extern option mismatch",
    "Ack: Unknown nbr",
    "Ack: Nbr state low",
    "Ls Req: Nbr state low",
    "Ls Req: Unknown nbr",
    "Ls Req: Empty request",
    "LS Req: Bad pkt",
    "LS Update: Nbr state low",
    "Ls Update: Unknown nbr",
    "Ls Update: Newer self-gen LSA",
    "Ls Update: Bad LS chksum",
    "Ls Update: less recent rx",
    "Ls Update: Unknown type"};

long cumlog[LASTLOG + 1];		/* should be even */

void
rxlog(multicast, type, ifspfndx, from)
int multicast, type, ifspfndx;
u_long32 from;
{

    int log_bit = 1 << (type - 1);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    cumlog[type] += 1;
    EVENT_UPDATE();
    if ((type > GOOD_LSA) && OSPF_TRAP_LOG) {
	sprintf(_ospf_prt_buf, "Rxlog: %s", logtype[type]);
	OSPF_LOG(_ospf_prt_buf);
    } else if (log_bit & ospf_log_flags) {
	sprintf(_ospf_prt_buf, "Rxlog: (%s) %s",
		(multicast) ? "Multicast" : "Unicast",
		logtype[type]);
	OSPF_LOG(_ospf_prt_buf);
	sprintf(_ospf_prt_buf, "     on IF %s source %s",
		lntoa(NDX_IP_ADDR(ifspfndx)),
		lntoa(from));
	OSPF_LOG(_ospf_prt_buf);
    }
}


/*
 * Change dest addr to string
 */
const char *
to2str(to)
u_long32 to;
{

    switch (to) {
	case ALL_UP_NBRS:
	    return ("All_up_nbrs");
	case ALL_ELIG_NBRS:
	    return ("All_elig_nbrs");
	case ALL_EXCH_NBRS:
	    return ("All_exch_nbrs");
	case DR_and_BDR:
	    return ("Dr_and_Bdr");
	default:
	    if (to == AllSPFRouters)
		return ("AllSPFRouters");
	    if (to == AllDRouters)
		return ("AllDRouters");
	    return (lntoa(to));
    }
}

void
txlog(multicast, type, ifspfndx, retrans, to)
int multicast, type, ifspfndx;
int retrans;
u_long32 to;
{
    int log_bit = 1 << (type - 1);

    cumlog[type] += 1;

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    if (log_bit & ospf_log_flags) {
	sprintf(_ospf_prt_buf, "%s: (%s) %s",
		(!retrans) ? "TxLog" : "ReTrans",
		(multicast) ? "Multicast" : "Unicast",
		logtype[type + 6]);
	OSPF_LOG(_ospf_prt_buf);
	sprintf(_ospf_prt_buf, "     out IF %s dest %s",
		lntoa(NDX_IP_ADDR(ifspfndx)),
		to2str(to));
	OSPF_LOG(_ospf_prt_buf);

    }
}


/*
 *		Transition log stuff
 */

const char *TransType[] =
{
    "Broadcast Interface",
    "Nonbroadcast Interface",
    "Point To Point	Interface",
    "Virtual Interface",
    "Neighbor"};

const char *IfEvents[] =
{
    "Interface Up",
    "Wait Timer",
    "Backup Seen",
    "Neighbor Change",
    "Loop Indication",
    "Unloop Indication",
    "Interface Down"};


const char *IfStates[] =
{
    "Down",
    "Loopback",
    "Waiting",
    "P To P",
    "DR",
    "BackupDR",
    "DR Other"};

const char *NbrEvents[] =
{
    "Hello Received",
    "Start",
    "Two Way Received",
    "Adjacency OK",
    "Negotiation Done",
    "Exchange Done",
    "Sequence # Mismatch",
    "Bad LS Request",
    "Loading Done",
    "One way",
    "Reset Adjacency",
    "Kill Neighbor",
    "Inactivity Timer",
    "Lower Level Down"};

const char *NbrStates[] =
{
    "Down      ",
    "Attempt   ",
    "Init      ",
    "2 Way     ",
    "Exch Start",
    "Exchange  ",
    "Loading   ",
    "Full      ",
    "SCVirtual "};

void
translog(type, event, curstate, newstate, id)
short type, event, curstate;
int newstate;
u_long id;
{
    EVENT_UPDATE();
    if (type < NBR_TYPE) {
	sprintf(_ospf_prt_buf, "TRANS %s id: %s event: %s",
		TransType[type - 1],
		lntoa(id),
		IfEvents[event]);
	OSPF_LOG(_ospf_prt_buf);
	sprintf(_ospf_prt_buf, "     current state: %s new state: %s",
		IfStates[curstate],
		IfStates[newstate]);
	OSPF_LOG(_ospf_prt_buf);
    } else {
	sprintf(_ospf_prt_buf, "TRANS %s nbr ip addr: %s event: %s",
		TransType[type - 1],
		lntoa(id),
		NbrEvents[event]);
	OSPF_LOG(_ospf_prt_buf);
	sprintf(_ospf_prt_buf, "     curstate: %s new state: %s",
		NbrStates[curstate],
		NbrStates[newstate]);
	OSPF_LOG(_ospf_prt_buf);
    }
}
