/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

#ifdef	PROTO_OSPF

int
pkt_send(ifspfndx, pkt, len, to)
int ifspfndx;
void *pkt;
int len;
u_long32 to;
{
#ifndef UMBC_SIM
    struct sockaddr_in dst;

    dst.sin_family = AF_INET;
    dst.sin_port = 0;
    dst.sin_addr.s_addr = to;

    return (sendto(IF_NDX[ifspfndx].fd, pkt, len, 0, (struct sockaddr *) & dst,
		   sizeof(dst)));
#else
    return (sim_send(ifspfndx, (char *) pkt, len, to, OSPF_UPDATE_TYPE));
#endif
}


int
ospf_txpkt(packet, intf, type, length, to, retrans)
void *packet;
struct INTF *intf;
int type;
int length;
u_long32 to;
int retrans;				/* log flag if pkt was retrans */
{
    struct OSPF_HDR *o_hdr = (struct OSPF_HDR *) packet;
    struct NBR *nbr;
    int multicast = (to == AllSPFRouters || to == AllDRouters) ? 1 : 0;


    o_hdr->version = OSPF_VERSION;
    o_hdr->type = type;
    o_hdr->length = htons(length);
    o_hdr->rtr_id = MY_ID;
    o_hdr->area_id = (intf->type == VIRTUAL_LINK) ?
	0 : htonl(ifspfAREA(intf->ifspfndx).area_id);
    o_hdr->checksum = 0;
    CLEAR_BUF(o_hdr->Auth, 8);

    o_hdr->AuType = (intf->type == VIRTUAL_LINK) ?
	ospf.area[0].authtype : ifspfAREA(intf->ifspfndx).authtype;
    o_hdr->AuType = htons(o_hdr->AuType);
    o_hdr->checksum = inet_chksum(packet, length);
    if (o_hdr->AuType)
	AUTH_COPY(intf->authkey, o_hdr->Auth, 8);


    /* Handle NBMA send cases */
    if (to >= ALL_UP_NBRS && to <= DR_and_BDR) {
	switch (to) {
	    case ALL_UP_NBRS:
		for (nbr = intf->nbr.next; nbr != NBRNULL; nbr = nbr->next)
		    if (nbr->state != NDOWN) {
			if (pkt_send(intf->ifspfndx, (void *) packet,
				     length, nbr->nbrip_addr) < 0)
			    goto badsend;
		    }
		break;
	    case ALL_ELIG_NBRS:
		for (nbr = intf->nbr.next; nbr != NBRNULL; nbr = nbr->next)
		    if (nbr->pri) {
			if (pkt_send(intf->ifspfndx, (void *) packet,
				     length, nbr->nbrip_addr) < 0)
			    goto badsend;
		    }
		break;
	    case ALL_EXCH_NBRS:
		for (nbr = intf->nbr.next; nbr != NBRNULL; nbr = nbr->next)
		    if (nbr->state >= NEXCHANGE) {
			if (pkt_send(intf->ifspfndx, (void *) packet,
				     length, nbr->nbrip_addr) < 0)
			    goto badsend;
		    }
		break;
	    case DR_and_BDR:
		if (intf->dr) {
		    if (pkt_send(intf->ifspfndx, (void *) packet,
				 length, intf->dr->nbrip_addr) < 0)
			goto badsend;
		}
		if (intf->bdr) {
		    if (pkt_send(intf->ifspfndx, (void *) packet,
				 length, intf->bdr->nbrip_addr) < 0)
			goto badsend;
		}
		break;
	}
    } else {
	if (pkt_send(intf->ifspfndx, (void *) packet, length, to) < 0)
	    goto badsend;
    }

    TX_LOG(multicast, type, intf->ifspfndx, retrans, to);

#ifdef PKTLOG
    PKT_LOG(dumpfp, packet, length, type, 0, to);
#endif
    return (TRUE);


  badsend:
    sprintf(_ospf_prt_buf, "ospf_txpkt sendto: ifspfndx %d %s: %s",
	    intf->ifspfndx,
	    lntoa(to),
	    strerror(errno));
    OSPF_LOG(_ospf_prt_buf);
    TX_LOG(multicast, TX_SENDTO_BAD, intf->ifspfndx, retrans, to);
    return (FALSE);
}

#endif
