/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

extern char *NbrStates[];
extern char *IfStates[];
extern char *if_types[];
extern char *ls_types[];
extern char *lntoa();
extern int get_ospf_general(),
	get_area_entry(),
	get_stub_metric(),
	get_lsdb_entry(),
	get_address_range(),
	get_host_entry(),
	get_intf_entry(),
	get_if_metric(),
	get_virt_intf_entry(),
	get_nbr_entry(),
	get_virt_nbr_entry();


void
tp_general(mp)
struct OspfGeneralGroup *mp;
{


    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, "Rtr ID: %s\n", lntoa(mp->ospfRouterId));
    MON_WRITE(_ospf_prt_buf);

    sprintf(_ospf_prt_buf,
		"     Status: %s  Version: %d  ABR: %s  ASBR: %s\n",
		(mp->ospfAdminStat == MIB_ENABLED) ? "Enabled" : "Disabled",
		mp->ospfVersionNumber,
	    	(mp->ospfAreaBdrRtrStatus == MIB_ENABLED) ? "On" : "Off",
	    	(mp->ospfASBdrRtrStatus == MIB_ENABLED) ? "On" : "Off");
    MON_WRITE(_ospf_prt_buf);

    sprintf(_ospf_prt_buf, 
		"     LS ASE Count: %d  ASE Cksum sum: Ox%x  Tos Support: %s\n",
    		mp->ospfExternLSACount,
    		mp->ospfExternLSACksumSum,
		(mp->ospfTOSSupport == MIB_ENABLED) ? "On" : "Off");
    MON_WRITE(_ospf_prt_buf);
    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));

    sprintf(_ospf_prt_buf, 
		"     New LSA Originate Count: %d  Rx New LSA Count: %d\n",
    		mp->ospfOriginateNewLsa,
    		mp->ospfRxNewLSA);
    MON_WRITE(_ospf_prt_buf);
}

void
tp_area(mp)
struct OspfAreaEntry *mp;
{

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, "Area ID: %s\n", lntoa(mp->ospfAreaId));
    MON_WRITE(_ospf_prt_buf);

    sprintf(_ospf_prt_buf,
	"     Auth Type: %s  Import ASE: %s  Spf Runs: %d\n",
	(mp->ospfAuthType) ? "Simple Passwd" : "None",
    	(mp->ospfImportASExtern == MIB_TRUE) ? "On" : "Off",
	mp->ospfSpfRuns);
    MON_WRITE(_ospf_prt_buf);

    sprintf(_ospf_prt_buf,
	"     Local ABRs: %d  Local ASBRs: %d  Intra LSAs: %d  Intra Cksum sum: 0x%x\n",
	mp->ospfAreaBdrRtrCount,
	mp->ospfASBdrRtrCount,
	mp->ospfLSACount,
	mp->ospfAreaLSACksumSum);
    MON_WRITE(_ospf_prt_buf);
}

void
tp_stub(mp)
struct OspfStubAreaEntry *mp;
{
    sprintf(_ospf_prt_buf,"Area id: %s Valid: %s Default Metric: %d\n",
	lntoa(mp->ospfStubAreaID),
    	(mp->ospfStubStatus == MIB_VALID) ? "True" : "False",
    	mp->ospfStubMetric,
	mp->ospfStubTOS);
    MON_WRITE(_ospf_prt_buf);
}

void
tp_lsdb(mp)
struct OspfLsdbEntry *mp;
{
    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, "Area: %-12s Type: %-7s LS ID: %-13s Adv Rtr: %-13s\n",
    	    lntoa((mp)->ospfLsdbAreaId),
	    ls_types[(mp)->ospfLsdbType],
    	    lntoa((mp)->ospfLsdbLSID),
    	    lntoa((mp)->ospfLsdbRouterId));
    MON_WRITE(_ospf_prt_buf);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, "Age: %-3d Cksum: 0x%-8x Sequence: 0x%-8x\n",
    	    ntohs((mp)->ospfLsdbAge),
    	    ntohs((mp)->ospfLsdbChecksum),
    	    ntohl((mp)->ospfLsdbSequence));
    MON_WRITE(_ospf_prt_buf);
}

void
tp_range(mp)
struct OspfAreaRangeEntry *mp;
{

    sprintf(_ospf_prt_buf, "Area: %s Net: %s Mask: %s Status: %s\n",
	lntoa(mp->ospfAreaRangeAreaID),
	lntoa(mp->ospfAreaRangeNet),
	lntoa(mp->ospfAreaRangeMask),
    	(mp->ospfAreaRangeStatus == MIB_VALID) ? "Valid" : "Invalid");
    MON_WRITE(_ospf_prt_buf);
}

void
tp_host(mp)
struct OspfHostEntry *mp;
{

    sprintf(_ospf_prt_buf, "TOS: %d Addr: %s Cost: %d Status: \n",
	    mp->ospfHostTOS,
	    lntoa(mp->ospfHostIpAddress),
	    mp->ospfHostCost,
    	    (mp->ospfHostStatus == MIB_VALID) ? "Valid" : "Invalid");
    MON_WRITE(_ospf_prt_buf);
}


void
tp_intf(mp)
struct OspfIfEntry *mp;
{

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf,
	"Addr: %-12s Ndx: %-2d Area: %-10s Type: %-8s Status: %-8s\n",
    	lntoa(mp->ospfIfIpAddress),
    	mp->ospfAddressLessIf,
    	lntoa(mp->ospfIfAreaId),
    	if_types[mp->ospfIfType -1],
    	(mp->ospfIfAdminStat == MIB_VALID) ? "Enabled" : "Disabled");
    MON_WRITE(_ospf_prt_buf);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf,
	"    Pri: %-3d Dly: %-4d Retrans: %-4d Hello: %-4d Poll: %-4d\n",
    	mp->ospfIfRtrPriority,
    	mp->ospfIfTransitDelay,
    	mp->ospfIfRetransInterval,
    	mp->ospfIfHelloInterval,
    	mp->ospfIfPollInterval);
    MON_WRITE(_ospf_prt_buf);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf,
    "    Dead: %-4d State: %-8s DR: %-12s BDr: %-12s Events: %d\n",
    	mp->ospfIfRtrDeadInterval,
    	IfStates[mp->ospfIfState],
    	lntoa(mp->ospfIfDesignatedRouter),
    	lntoa(mp->ospfIfBackupDesignatedRouter),
    	mp->ospfIfEvents);
    MON_WRITE(_ospf_prt_buf);

}

void
tp_metric(mp)
struct OspfIfMetricEntry *mp;
{

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf,
	"Addr: %-12s Ndx: %-3d TOS: %-3d Cost: %-4d Status: %-8s\n",
	lntoa(mp->ospfIfMetricIpAddress),
	mp->ospfIfMetricAddressLessIf,
	mp->ospfIfMetricTOS,
	mp->ospfIfMetricCost,
	(mp->ospfIfMetricStatus == MIB_VALID) ? "Valid" : "Invalid");
    MON_WRITE(_ospf_prt_buf);
}

void
tp_virt_intf(mp)
struct OspfVirtIfEntry	*mp;
{

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf,
	"Area: %-12s Nbr: %-12s Dly: %-4d Retrans: %-4d Hello: %-4d Dead: %-4d\n",
	lntoa(mp->ospfVirtIfAreaID),
	lntoa(mp->ospfVirtIfNeighbor),
	mp->ospfVirtIfTransitDelay,
	mp->ospfVirtIfRetransInterval,
	mp->ospfVirtIfHelloInterval,
	mp->ospfVirtIfRtrDeadInterval);
    MON_WRITE(_ospf_prt_buf);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf,
	"    States: %-8s Events: %d Status: %s\n",
	IfStates[mp->ospfVirtIfState],
	mp->ospfVirtIfEvents,
	(mp->ospfVirtIfStatus == MIB_VALID) ? "Valid" : "Invalid");
    MON_WRITE(_ospf_prt_buf);
}

void
tp_nbr(mp)
struct	OspfNbrEntry *mp;
{

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf,
	"Addr: %-12s Ndx: %d RtrId: %-12s Options: %x Pri: %d\n",
	lntoa(mp->ospfNbrIpAddr),
	mp->ospfNbrAddressLessIndex,
	lntoa(mp->ospfNbrRtrId),
	mp->ospfNbrOptions,
	mp->ospfNbrPriority);
    MON_WRITE(_ospf_prt_buf);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf,
	"    State: %-8s Events: %-4d QLen: %-4d Status: %-8s\n",
	NbrStates[mp->ospfNbrState],
	mp->ospfNbrEvents,
	mp->ospfNbrLSRetransQLen,
	(mp->ospfNBMANbrStatus == MIB_VALID) ? "Valid" : "Invalid");
    MON_WRITE(_ospf_prt_buf);
}

void
tp_virt_nbr(mp)
struct	OspfVirtNbrEntry *mp;
{
    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf,
    "Area: %-12s Nbr: %-12s Addr: %-12s Opt: %x State: %s Events: %d Q: %d\n",
	lntoa(mp->ospfVirtNbrArea),
	lntoa(mp->ospfVirtNbrRtrId),
	lntoa(mp->ospfVirtNbrIpAddr),
	mp->ospfVirtNbrOptions,
	NbrStates[mp->ospfVirtNbrState],
	mp->ospfVirtNbrEvent,
	mp->ospfVirtNbrLSRetransQLen);
    MON_WRITE(_ospf_prt_buf);
}


struct MIB_TAB mib_tab[] = {
    {"First:", 			get_ospf_general,	tp_general},
    {"OspfGeneral:", 		get_ospf_general,	tp_general},
    {"OspfAreaEntry:", 		get_area_entry,		tp_area},
    {"OspfStubMetric:", 	get_stub_metric,	tp_stub},
    {"OspfLsdbEntry:", 		get_lsdb_entry,		tp_lsdb},
    {"OspfAreaRangeEntry:", 	get_address_range,	tp_range},
    {"OspfHostEntry:", 		get_host_entry,		tp_host},
    {"OspfIntfEntry:",		get_intf_entry,		tp_intf},
    {"OspfIntfMetricEntry:", 	get_if_metric,		tp_metric},
    {"OspfVirtIntfEntry:",	get_virt_intf_entry,	tp_virt_intf},
    {"OspfNbrEntry:",		get_nbr_entry,		tp_nbr},
    {"OspfVirtNbrEntry:",	get_virt_nbr_entry,	tp_virt_nbr}};


void
test_mib()
{
    union 	OSPF_MIB_UN ospf_mib_un;
    union 	OSPF_MIB_UN *mib_un = &ospf_mib_un;
    int 	ret, i, mr_good_mib;
    
    for(i = 1; i < 12; i++) {
    	CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
	sprintf(_ospf_prt_buf,"\n%s\n",mib_tab[i].mib_name);
	MON_WRITE(_ospf_prt_buf);
    	CLEAR_BUF(mib_un, sizeof(union OSPF_MIB_UN));
    	mr_good_mib = mib_tab[i].mib_routine(GET_FIRST,&mib_un);

    	while (mr_good_mib) {
    		mib_tab[i].mib_print(mib_un);
    		mr_good_mib = mib_tab[i].mib_routine(GET_THIS,&mib_un);
		if (!mr_good_mib) break;
    		mib_tab[i].mib_print(mib_un);

    		mr_good_mib = mib_tab[i].mib_routine(GET_NEXT,&mib_un);
    	}
    }

}
