/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

extern void tqhandler();
extern time_t ospf_get_time();
extern void tq_retrans(), tq_ack(), tq_hellotmr();
extern void tq_int_age(), tq_sum_age(), tq_ase_age();
extern void tq_IntLsa(), tq_SumLsa(), tq_AseLsa(), tq_lsa_lock();


/*
 *	TIMERQ DEFINES
 */
struct OTIMER {
    struct OTIMER *ptr[2];
    int type;				/* type of alarm */
#ifdef UMBC_SIM
    Event *sim_event;
#else
    time_t set;				/* Just use seconds */
    time_t reset;
#endif
    void *tq_data;
    void (*routine) ();			/* routine to call after timeout */
}

#ifndef UMBC_SIM
 timerq;				/* head of the timer queue */

#else
 timerq_sim[RTR_CNT];			/* head of the timer queue */

#endif

#define OTIMERNULL ((struct OTIMER *) 0)


#define addalarm(S,RS,T,R,D) insert_tq(makealarm(S,RS,T,R,D))

/*
 * Timerq types 
 */
#define TQHelloTimer	1		/* Hello interval timer - intf */
#define TQAck		2		/* Delayed ack send - intf */
#define TQRetrans	3		/* LSA retransmit timer - per intf */
#define TQLsaLock	4		/* MinLsInterval lock rtr and net lsa */
#define TQIntLsa	5		/* Generate interal lsa timer */
#define TQSumLsa	6		/* Generate sum lsa timer */
#define TQAseLsa	7		/* Generate external lsa timer */
#define TQIntLsdbAge	8		/* age interal LSDB in all areas */
#define TQSumLsdbAge	9		/* age summary LSDB in all areas */
#define TQAseLsdbAge	10		/* age AS external LSDB */
