/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/******************************************************************************
 *
 *			STATE TRANSITION SUPPORT ROUTINES
 *
 ******************************************************************************/



/******************************************************************************
 *
 *			NEIGHBOR STATE TRANSITIONS
 *
 ******************************************************************************/

void
NErr(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
}

/*
 *	NHello - received a hello packet
 *		current state: NATTEMPT or NDOWN; new state: NINIT
 */

void
NHello(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;
    struct AREA *area = AREA_PTR(intf);
    /* Unnumbered ptop link? */
    u_long32 nh_addr = (nbr->nbrip_addr) ? nbr->nbrip_addr : nbr->nbr_id;

    /*
     * fire up dead timer alarm
     */
    reset_inact_tmr(nbr);
    nbr->state = NINIT;
    intf->nbrIcnt += 1;
    ospf.nbrIcnt += 1;
    area->nbrIcnt += 1;
    add_nh_entry(nbr->ifspfndx, nh_addr, NH_NBR, 0);

    TRANS_LOG(NBR_TYPE, HELLO_RX, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;
}

/*
 * Non-broadcast interface is up - current state = NDOWN
 *	start inactivity timer and start sending hellos
 */
void
NStart(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;

    nbr->state = NATTEMPT;
    if (intf->pri)
	send_hello(intf, nbr);
    reset_inact_tmr(nbr);
    TRANS_LOG(NBR_TYPE, START, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;
}

void
N2Way(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{

    int oldstate = nbr->state;

    nbr->state = N2WAY;

    /* MODIFIED 2/4/92 */
    if ((intf->type <= NONBROADCAST) && (intf->state > IPOINT_TO_POINT)) {
	(*(if_trans[NBR_CHANGE][intf->state])) (intf);
    }

    TRANS_LOG(NBR_TYPE, TWOWAY, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;
    /*
     * if type is PTP or VIRTUAL or we are still in N2WAY and
     * the neighbor is DR or BDR - establish an adjacency
     */
    if ((intf->type > NONBROADCAST && intf->type <= VIRTUAL_LINK) ||
	((nbr->state == N2WAY && intf->type < POINT_TO_POINT) &&
	 (intf->dr == nbr || intf->bdr == nbr ||
	  intf->dr == &(intf->nbr) || intf->bdr == &(intf->nbr))))
	(*(nbr_trans[ADJ_OK][nbr->state])) (intf, nbr);
    /*
     * choose dr will have reset adjacencies or established
     * adjacencies if we are dr or bdr
     */
}

void
NAdjOk(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;

    nbr->state = NEXSTART;
    /*
     * set initial seq number
     */
    nbr->seq = ospf_get_time();
    nbr->I_M_MS = (bit_I | bit_M | bit_MS);
    send_dbsum(intf, nbr, 0);
    TRANS_LOG(NBR_TYPE, ADJ_OK, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;
}

void
NNegDone(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;
    struct AREA *area = AREA_PTR(intf);

    /*
     * build a summary of all of the LSDB
     * return if build_dbsum is out of bufs
     */
    /*
     * stop sending db negotiation pkt
     */
    /* MODIFIED 11/22 */
    intf->nbrEcnt += 1;
    area->nbrEcnt += 1;
    ospf.nbrEcnt += 1;
    if (build_dbsum(intf, nbr)) {
    	intf->nbrEcnt -= 1;
    	area->nbrEcnt -= 1;
    	ospf.nbrEcnt -= 1;
	return;
    }

    nbr->state = NEXCHANGE;
    TRANS_LOG(NBR_TYPE, NEGO_DONE, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;
}

void
NExchDone(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;

    /*
     * if master free last dbsum else leave it hanging around for a while
     */
    if (nbr->mode == MASTER) {
	if (nbr->dbsum != LSDB_SUM_NULL)
	    freeDbSum(nbr);
    } else {				/* mode == SLAVE */
	/*
 	 * put nbr in SLAVE_HOLDING mode until timer has expired
	 */
	nbr->mode = SLAVE_HOLD;
	set_hold_tmr(nbr);
    }

    nbr->state = NLOADING;
    TRANS_LOG(NBR_TYPE, EXCH_DONE, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;

    if (NO_REQ(nbr))
	(*(nbr_trans[LOAD_DONE][nbr->state])) (intf, nbr);
}

void
NBadReq(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;
    struct AREA *area = AREA_PTR(intf);

    /*
     * Free all lists
     */
    freeDbSum(nbr);			/* summary of area db */
    if (nbr->retrans != DBRTNULL)
	rem_nbr_retrans(nbr);
    freeLsReq(nbr);			/* list of requests from this nbr */
    if (intf->nbrIcnt == 1) {
    	freeAckList(intf);		/* list of acks to send to this nbr */
    }

    /* MODIFIED 2/7/92 added state checks */
    if (nbr->state == NFULL) {
	intf->nbrFcnt -= 1;		/* Another one bites the dust */
	area->nbrFcnt -= 1;
	ospf.nbrFcnt -= 1;
	/* 
	 * Schedule nbr change or build_rtr 
	 */
	if ((intf->type <= NONBROADCAST) && (intf->state >= IDr))
	    /* MODIFIED 2/7/92 */
	    intf->nbr_change = NBR_CHANGE;
	else if (intf->type == POINT_TO_POINT || intf->type == VIRTUAL_LINK)
	    area->build_rtr = TRUE;

    }
    if (nbr->state >= NEXCHANGE) {
	intf->nbrEcnt -= 1;		/* Another one bites the dust */
	area->nbrEcnt -= 1;
	ospf.nbrEcnt -= 1;
    }

    nbr->state = NEXSTART;
    intf->nbrEcnt -= 1;
    area->nbrEcnt -= 1;
    ospf.nbrEcnt -= 1;
    /*
     * set initial seq number and start all over
     */
    nbr->seq = ospf_get_time();
    nbr->I_M_MS = (bit_I | bit_M | bit_MS);
    send_dbsum(intf, nbr, 0);

    TRANS_LOG(NBR_TYPE, BAD_LS_REQ, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;
}


void
NBadSq(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;
    struct AREA *area = AREA_PTR(intf);

    /*
     * Free all lists
     */
    freeDbSum(nbr);			/* summary of area db */
    if (nbr->retrans != DBRTNULL)
	rem_nbr_retrans(nbr);
    freeLsReq(nbr);			/* list of requests from this nbr */

    if (intf->nbrIcnt == 1) {
    	freeAckList(intf);		/* list of acks to send to this nbr */
    }

    if (nbr->state == NFULL) {
	intf->nbrFcnt -= 1;		/* Another one bites the dust */
	area->nbrFcnt -= 1;
	ospf.nbrFcnt -= 1;
	/* 
	 * Schedule nbr change or build_rtr 
	 */
	/* MODIFIED 2/7/92 */
	if ((intf->type <= NONBROADCAST) && (intf->state >= IDr))
	    intf->nbr_change = NBR_CHANGE;
	else if (intf->type == POINT_TO_POINT || intf->type == VIRTUAL_LINK)
	    area->build_rtr = TRUE;

    }
    if (nbr->state >= NEXCHANGE) {
	intf->nbrEcnt -= 1;		/* Another one bites the dust */
	area->nbrEcnt -= 1;
	ospf.nbrEcnt -= 1;
    }
    nbr->state = NEXSTART;
    /*
     * set initial seq number and start all over
     */
    nbr->seq = ospf_get_time();
    nbr->I_M_MS = (bit_I | bit_M | bit_MS);
    send_dbsum(intf, nbr, 0);

    TRANS_LOG(NBR_TYPE, SEQ_MISMATCH, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;

}

void
NLoadDone(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;
    struct AREA *area = AREA_PTR(intf);

    /*
     * Another Full neighbor
     */
    nbr->state = NFULL;
    intf->nbrFcnt += 1;
    area->nbrFcnt += 1;
    ospf.nbrFcnt += 1;

    area->build_rtr = TRUE;
    if (intf->state == IDr)
	intf->build_net = TRUE;
    TRANS_LOG(NBR_TYPE, LOAD_DONE, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;
}

/*
 *	Can no longer see ourself in nbr's hello pkt
 *		- revert back to INIT
 */
void
N1Way(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;
    struct AREA *area = AREA_PTR(intf);

    rem_hold_tmr(nbr);
    /*
     * Another neighbor bites the dust
     */
    if (nbr->state == NFULL) {
	intf->nbrFcnt -= 1;
	area->nbrFcnt -= 1;
	ospf.nbrFcnt -= 1;
	/* 
	 * Schedule nbr change or build_rtr 
	 */
	/* MODIFIED 2/7/92 */
	if ((intf->type <= NONBROADCAST) && (intf->state >= IDr))
	    intf->nbr_change = NBR_CHANGE;
	else if (intf->type == POINT_TO_POINT || intf->type == VIRTUAL_LINK)
	    area->build_rtr = TRUE;

    }
    if (nbr->state >= NEXCHANGE) {
	intf->nbrEcnt -= 1;
	area->nbrEcnt -= 1;
	ospf.nbrEcnt -= 1;
    }
    nbr->state = NINIT;
    nbr->mode = 0;
    nbr->seq = 0;
    nbr->dr = 0;
    nbr->bdr = 0;

    /*
     * Free all lists
     */
    freeDbSum(nbr);			/* summary of area db */
    if (nbr->retrans != DBRTNULL)
	rem_nbr_retrans(nbr);
    freeLsReq(nbr);			/* list of requests from this nbr */
    if (intf->nbrIcnt == 1) {
    	freeAckList(intf);		/* list of acks to send to this nbr */
    }

    TRANS_LOG(NBR_TYPE, ONEWAY, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;

    /* MODIFIED 2/13/92 removed state trans - is done in rxhello */
}

void
NRstAd(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;
    struct AREA *area = AREA_PTR(intf);

    rem_hold_tmr(nbr);
    /*
     * Another nbr bites the dust
     */
    if (nbr->state == NFULL) {
	intf->nbrFcnt -= 1;
	area->nbrFcnt -= 1;
	ospf.nbrFcnt -= 1;
    }
    if (nbr->state >= NEXCHANGE) {
	intf->nbrEcnt -= 1;
	area->nbrEcnt -= 1;
	ospf.nbrEcnt -= 1;
    }
    nbr->state = N2WAY;
    nbr->mode = 0;
    nbr->seq = 0;
    /*
     * Free all lists
     */
    freeDbSum(nbr);			/* summary of area db */
    if (nbr->retrans != DBRTNULL)
	rem_nbr_retrans(nbr);
    freeLsReq(nbr);			/* list of requests from this nbr */

    if (intf->nbrIcnt == 1) {
    	freeAckList(intf);		/* list of acks to send to this nbr */
    }

    TRANS_LOG(NBR_TYPE, RST_ADJ, oldstate, nbr->state, nbr->nbrip_addr);
    nbr->events++;

    /*
     * if type is PTP or VIRTUAL || (since we are still in N2WAY)
     * the neighbor is DR or BDR - establish an adjacency
     */
    if ((intf->type > NONBROADCAST && intf->type <= VIRTUAL_LINK) ||
	((nbr->state == N2WAY && intf->type < POINT_TO_POINT) &&
	 (intf->dr == nbr || intf->bdr == nbr ||
	  intf->dr == &(intf->nbr) || intf->bdr == &(intf->nbr))))
	(*(nbr_trans[ADJ_OK][nbr->state])) (intf, nbr);
}

/*
 * Neighbor has gone away -
 */
void
NDown(intf, nbr)
struct INTF *intf;
struct NBR *nbr;
{
    int oldstate = nbr->state;
    struct NBR *n;
    struct AREA *area = AREA_PTR(intf);

    TRANS_LOG(NBR_TYPE, INACT_TIMER, oldstate, NDOWN, nbr->nbrip_addr);
    nbr->events++;

    /* disable all timers associated with this neighbor */
    rem_hold_tmr(nbr);
    rem_inact_tmr(nbr);

    /*
     * Free all lists
     */
    freeDbSum(nbr);			/* summary of area db */
    if (nbr->retrans != DBRTNULL)
	rem_nbr_retrans(nbr);
    freeLsReq(nbr);			/* list of requests from this nbr */
    if (intf->nbrIcnt == 1) {
    	freeAckList(intf);		/* list of acks to send to this nbr */
    }

    /*
     * Another nbr bytes the dust
     */
    if (nbr->state > NATTEMPT) {
	intf->nbrIcnt -= 1;
	ospf.nbrIcnt -= 1;
	area->nbrIcnt -= 1;
    }
    if (nbr->state == NFULL) {
	intf->nbrFcnt -= 1;
	area->nbrFcnt -= 1;
	ospf.nbrFcnt -= 1;
    }
    if (nbr->state >= NEXCHANGE) {
	intf->nbrEcnt -= 1;
	area->nbrEcnt -= 1;
	ospf.nbrEcnt -= 1;
    }
    /*
     * For types other than BROADCAST we want to keep the nbr and the
     * initialized info around
     */
    if (intf->type > BROADCAST) {
	nbr->mode = 0;
	nbr->seq = 0;
	if (intf->type != VIRTUAL_LINK) {
	    nbr->nbr_id = 0;
#ifdef IFF_MULTICAST
	    if (intf->type != NONBROADCAST)
		nbr->nbrip_addr = 0;
#endif
	} else {			/* virtual link */
	    nbr->nbrip_addr = 0;
	}
	nbr->dr = nbr->bdr = 0;
	if (nbr == intf->dr) {
	    intf->dr = NBRNULL;
	    intf->nbr.dr = 0;
	} else if (nbr == intf->bdr) {
	    intf->bdr = NBRNULL;
	    intf->nbr.bdr = 0;
	}
	nbr->state = NDOWN;
    } else {
	/*
	 * Broadcast - free the nbr structure
	 */
	/* Johnathan's fix */
	if (nbr == intf->dr) {
	    intf->dr = NBRNULL;
	    intf->nbr.dr = 0;
	} else if (nbr == intf->bdr) {
	    intf->bdr = NBRNULL;
	    intf->nbr.bdr = 0;
	}
	for (n = &(intf->nbr); n != NBRNULL; n = n->next)
	    if (n->next == nbr) {	/* found it! */
		n->next = nbr->next;
		ZAP(nbr, OMEM_NBR);
		nbr = NBRNULL;
		ospf.nbrcnt--;
		ospf.nbr_sb_not_valid = TRUE;
		break;
	    }
	if (nbr != NBRNULL)
	    adios("NDown: could not find nbr on IF");
    }

    /* Schedule nbr change or build_rtr */
    if ((intf->type <= NONBROADCAST) && (intf->state >= IDr))
	intf->nbr_change = NBR_CHANGE;
    /* MODIFIED 12/19 */
    else if (intf->type == POINT_TO_POINT || intf->type == VIRTUAL_LINK)
	area->build_rtr = TRUE;
}

/* MODIFIED 2/6/92  Removed NSCVL */
void (*nbr_trans[NNBR_EVENTS][NNBR_STATES]) () = {
/*
 * event/state	NDOWN NATTEMPT NINIT N2WAY NEXSTART NEXCH     NLOAD     NFULL
 */
/* HELLO_RX  */ NHello,NHello,NErr, NErr,  NErr,    NErr,     NErr,     NErr,
/* START     */ NStart,NErr,  NErr, NErr,  NErr,    NErr,     NErr,     NErr,
/* 2WAY      */ NErr,  NErr,  N2Way,NErr,  NErr,    NErr,     NErr,     NErr,
/* ADJ_OK    */ NErr,  NErr,  NErr, NAdjOk,NErr,    NErr,     NErr,     NErr,
/* NEGO_DONE */ NErr,  NErr,  NErr, NErr,  NNegDone,NErr,     NErr,     NErr,
/* EXCH_DONE */ NErr,  NErr,  NErr, NErr,  NErr,    NExchDone,NErr,     NErr,
/* SEQ_MSMTCH*/ NErr,  NErr,  NErr, NBadSq,NBadSq,  NBadSq,   NBadSq,   NBadSq,
/* BAD_LSREQ */ NErr,  NErr,  NErr, NErr,  NErr,    NBadReq,  NBadReq,  NBadReq,
/* LOAD_DONE */ NErr,  NErr,  NErr, NErr,  NErr,    NErr,     NLoadDone,NErr,
/* 1WAY      */ NErr,  NErr,  NErr, N1Way, N1Way,   N1Way,    N1Way,    N1Way,
/* RST_ADJ   */ NErr,  NErr,  NErr, NErr,  NRstAd,  NRstAd,   NRstAd,   NRstAd,
/* KILL_NBR  */ NDown, NDown, NDown,NDown, NDown,   NDown,    NDown,    NDown,
/* INACT_TMR */ NDown, NDown, NDown,NDown, NDown,   NDown,    NDown,    NDown,
/* LLDOWN    */ NDown, NDown, NDown,NDown, NDown,   NDown,    NDown,    NDown,
};


/******************************************************************************
 *
 *			INTERFACE STATE TRANSITIONS
 *
 ******************************************************************************/

void
IErr(intf)
struct INTF *intf;
{
}

/*
 * IUp: in state: IDOWN, event: INTF_UP
 */
void
IUp(intf)
struct INTF *intf;
{

    int oldstate = intf->state;
    struct AREA *a = AREA_PTR(intf);
    struct NBR *n;

    switch (intf->type) {
	case BROADCAST:
	    intf->state = IWAITING;
	    send_hello(intf, 0);
	    start_wait_tmr(intf);
	    break;

	case POINT_TO_POINT:
	    /*
	     * fire up dead timer alarm
	     */
	    reset_inact_tmr(&(intf->nbr));

	case VIRTUAL_LINK:
	    intf->state = IPOINT_TO_POINT;
	    ospf.area[intf->transarea].virtual_up++;
	    ospf.vUPcnt++;
	    send_hello(intf, 0);
	    break;

	case NONBROADCAST:
	    if (intf->pri) {
		intf->state = IWAITING;
		start_wait_tmr(intf);
	    } else
		intf->state = IDrOTHER;
	    /*
	     * Fire up all NBMA neighbors
	     */
	    for (n = intf->nbr.next; n != NBRNULL; n = n->next)
		(*(nbr_trans[START][n->state])) (intf, n);
	    break;
    }

    /*
     * If virtual link has come up, schedule a build_rtr_lsa
     */
    if (intf->type != VIRTUAL_LINK)
	a->build_rtr = TRUE;
    else
	set_rtr_sched(ospf.area);

    intf->events++;
    /* MODIFIED 11/24 */
    a->ifUcnt++;
    TRANS_LOG(intf->type, INTF_UP, oldstate, intf->state,
	      (intf->type == VIRTUAL_LINK) ? intf->nbr.nbrip_addr :
	      NDX_IP_ADDR(intf->ifspfndx));
}


/*
 * Interface has gone down - tq_ifchk has been called
 */
void
IDown(intf)
struct INTF *intf;
{
    int oldstate = intf->state;
    struct NBR *n, *next_nbr;
    struct AREA *a = AREA_PTR(intf);

    intf->state = IDOWN;
    /*
     * reset intf variables
     */
    rem_wait_tmr(intf);
    reset_net_sched(intf);
    intf->nbr.dr = 0;
    intf->nbr.bdr = 0;
    intf->dr = NBRNULL;
    intf->bdr = NBRNULL;

    freeAckList(intf);		/* list of acks to send to this nbr */

    TRANS_LOG(intf->type, INTF_DOWN, oldstate, intf->state,
	      (intf->type == VIRTUAL_LINK) ? intf->nbr.nbrip_addr :
	      NDX_IP_ADDR(intf->ifspfndx));
    for (n = FirstNbr(intf); n != NBRNULL; n = next_nbr) {
	next_nbr = n->next;
	(*(nbr_trans[KILL_NBR][n->state])) (intf, n);
    }

    /*
     * Net has left us for the great beyond
     */
    if (intf->type <= NONBROADCAST && intf->nbrIcnt == 0) {
	(*(if_trans[NBR_CHANGE][intf->state])) (intf);
	/* MODIFIED 2/7/92 */
	a->build_rtr = TRUE;
    }
    if (intf->type == VIRTUAL_LINK) {
	ospf.area[intf->transarea].virtual_up--;
	ospf.vUPcnt--;
    }
    /* MODIFIED 11/24 */
    a->ifUcnt--;
    intf->events++;
}

void
ILoop(intf)
struct INTF *intf;
{
}

void
IUnLoop(intf)
struct INTF *intf;
{
}

/*
 * Wait timer has gone off from state IWAIT
 *		time to elect BDR and DR
 */
void
IWaitTmr(intf)
struct INTF *intf;
{
    int oldstate = intf->state;
    struct AREA *a = AREA_PTR(intf);

    /*
     * if we are elig and there are neighbors
     * reform adjacencies
     */
    choose_dr(intf);

    /*
     * flag to build new router lsa
     */
    a->build_rtr = TRUE;

    TRANS_LOG(intf->type, WAIT_TIMER, oldstate, intf->state,
	      (intf->type == VIRTUAL_LINK) ? intf->nbr.nbrip_addr :
	      NDX_IP_ADDR(intf->ifspfndx));
    if (oldstate != intf->state)
    	intf->events++;
}



/*
 * Backup has been seen from state IWAIT
 *		time to elect BDR and DR
 */
void
IBackUp(intf)
struct INTF *intf;
{
    int oldstate = intf->state;
    struct AREA *a = AREA_PTR(intf);

    /*
     * nuke the wait timer
     */
    rem_wait_tmr(intf);

    /*
     * if we are elig and there are neighbors
     * reform adjacencies
     */
    choose_dr(intf);
    /*
     * flag to build new router lsa
     */
    a->build_rtr = TRUE;

    TRANS_LOG(intf->type, BACKUP_SEEN, oldstate, intf->state,
	      (intf->type == VIRTUAL_LINK) ? intf->nbr.nbrip_addr :
	      NDX_IP_ADDR(intf->ifspfndx));
    if (oldstate != intf->state)
    	intf->events++;
}

void
INbrCh(intf)
struct INTF *intf;
{
    int oldstate = intf->state;
    struct AREA *a = AREA_PTR(intf);

    intf->nbr_change = 0;

    /* MODIFIED 2/13/92 */
    if (intf->type > NONBROADCAST)
	return;

    /*
     * if we are elig and there are neighbors
     * reform adjacencies
     */
    choose_dr(intf);
    /*
     * flag to build new router lsa
     */
    a->build_rtr = TRUE;
    TRANS_LOG(intf->type, NBR_CHANGE, oldstate, intf->state,
	      (intf->type == VIRTUAL_LINK) ? intf->nbr.nbrip_addr :
	      NDX_IP_ADDR(intf->ifspfndx));
    if (oldstate != intf->state)
    	intf->events++;
}


void (*if_trans[NINTF_EVENTS][NINTF_STATES]) () = {
/*
 * event/state  IDOWN ILOOPBACK IWAIT    IPtoP IDR      IBACKUP IDROTHER
 */
/* UP      */ 	IUp,  IErr,     IErr,    IErr, IErr, 	IErr,  IErr,
/* WAIT_TM */   IErr, IErr,     IWaitTmr,IErr, IErr, 	IErr,  IErr,
/* BACKUP  */   IErr, IErr,     IBackUp, IErr, IErr, 	IErr,  IErr,
/* NBR_CH  */   IErr, IErr,     IErr,    IErr, INbrCh, 	INbrCh,INbrCh,
/* LOOP    */   ILoop,IErr,     IErr,    IErr, IErr, 	IErr,  IErr,
/* UNLOOP  */   IErr, IUnLoop,  IErr,    IErr, IErr, 	IErr,  IErr,
/* DOWN    */   IErr, IDown,    IDown,   IDown,IDown, 	IDown, IDown
};



#endif				/* PROTO_OSPF */
