/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

void
new_lsu(pkt, adv_cnt, adv, len)
struct OSPF_HDR **pkt;
u_long32 **adv_cnt;
union ADV **adv;
int len;
{

    OSPF_PKT_ALLOC((*pkt), len);
#ifdef DBG
    sprintf(_ospf_prt_buf, "Pkt0 is %x", *pkt);
    DBG_LOG(_ospf_prt_buf);
#endif
    *adv = (union ADV *) & ((*pkt)->un.ls_update.adv);
    *adv_cnt = (u_long *) & ((*pkt)->un.ls_update.adv_cnt);
}

/*
 * RxLsReq - receive an ls request
 *	   - while parsing build and send ls pkt
 */
int
RxLsReq(ls_req, intf, ipsrc, rtrid, olen, mc)
struct LS_REQ_HDR *ls_req;
struct INTF *intf;
u_long32 ipsrc, rtrid;
int olen;
int mc;					/* multicast rx flag */
{
    struct NBR *n, *nbr = NBRNULL;
    struct OSPF_HDR *pkt;
    struct LS_REQ_PIECE *req = &(ls_req->req);
    struct AREA *area = AREA_PTR(intf);
    struct LSDB *db;
    /* MODIFIED 2/7/92 */
    struct LSDB_LIST *txq = LLNULL;
    union ADV *adv;
    time_t sec;
    u_long32 	*adv_cnt;
    int 	len = OSPF_HDR_SIZE + 4;	/* max len of pkt is INTF_MTU */
    int 	intf_mtu = INTF_MTU(intf);
    /* MODIFIED 2/7/92 */
    int 	ret = GOOD_RX;

    /* Locate nbr */
    n = FirstNbr(intf);
    if (intf->type > NONBROADCAST) {
	if (n->nbr_id == rtrid)
	    nbr = n;
    } else
	for (n = FirstNbr(intf); n != NBRNULL; n = n->next) {
	    if (ipsrc == n->nbrip_addr) {
		nbr = n;
		break;
	    }
	}

    if (nbr == NBRNULL)
	return (CANT_FIND_NBR4);
    if (nbr->state < NEXCHANGE)
	return (LOW_NBR_STATE4);

    sec = ospf_get_time();		/* get time to check MaxAge */
    olen -= OSPF_HDR_SIZE;
    if (!olen)
	return (EMPTY_LS_REQ);
    new_lsu(&pkt, &adv_cnt, &adv, intf_mtu);
    if (pkt == OSPF_HDR_NULL)
	return (GOOD_RX);

#ifdef DBG
    sprintf(_ospf_prt_buf, "Pkt1 is %x", pkt);
    DBG_LOG(_ospf_prt_buf);
#endif

    for (; olen; olen -= LS_REQ_PIECE_SIZE) {
	if ((req->ls_type < LS_RTR || req->ls_type > LS_ASE) ||
	    ((db = FindLSA(area, req->ls_id, req->adv_rtr, req->ls_type)) ==
	     LSDBNULL)) {
	    ZAP_PKT(pkt);
	    (*(nbr_trans[BAD_LS_REQ][nbr->state])) (intf, nbr);
	    /* MODIFIED 2/7/92 */
	    ret = BOGUS_REQ;
	    goto we_are_through;
	}
	if ((len + ntohs(LS_LEN(db))) > intf_mtu) {
	    *adv_cnt = htonl(*adv_cnt);
	    ospf_txpkt(pkt, intf, O_LSU, len, nbr->nbrip_addr, NOT_RETRANS);
	    len = OSPF_HDR_SIZE + 4;	/* 4 for adv_cnt */
	    ZAP_PKT(pkt);
	    new_lsu(&pkt, &adv_cnt, &adv, intf_mtu);
    	    if (pkt == OSPF_HDR_NULL)
		return (GOOD_RX);
#ifdef DBG
	    sprintf(_ospf_prt_buf, "Pkt2 is %x", pkt);
	    DBG_LOG(_ospf_prt_buf);
#endif
	}
	*adv_cnt += 1;
	ADV_COPY(DB_RTR(db), adv, ntohs(LS_LEN(db)));
	adv->rtr.ls_hdr.ls_age =
	    ((ADV_AGE(db, sec) + intf->transdly) >= MaxAge) ?
	    htons(MaxAge) : htons(ADV_AGE(db,sec) + intf->transdly);
	adv = (union ADV *) ((long) adv + ntohs(LS_LEN(db)));
	len += ntohs(LS_LEN(db));
	req++;
    }

    if (*adv_cnt) {			/* any left to send? */
	*adv_cnt = htonl(*adv_cnt);
	ospf_txpkt(pkt, intf, O_LSU, len, nbr->nbrip_addr, FALSE);
    }
    ZAP_PKT(pkt);

    /* MODIFIED 2/7/92 Added next few lines of code */
  we_are_through:

    if (intf->nbr_change) {
	(*(if_trans[intf->nbr_change][intf->state])) (intf);
    }
    /* build net and rtr lsa if necessary */
    if (intf->build_net) {
	area->spfsched |= build_net_lsa(intf, &txq, 0);
	intf->build_net = FALSE;
    }
    if (area->build_rtr) {
	area->spfsched |= build_rtr_lsa(area, &txq, 0);
	area->build_rtr = FALSE;
    }
    if (txq != LLNULL) {		/* may be locked out */
	self_orig_area_flood(area, txq, LS_RTR);
	freeq(&txq, OMEM_LL);
    }
    if (area->spfsched)
	RX_RUN_SPF(area);

    return (ret);
}

#endif				/* PROTO_OSPF */
