/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

int
RxHello(hello, intf, ipsrc, rtrid, olen, mc)
struct HELLO_HDR *hello;
struct INTF *intf;
u_long32 ipsrc, rtrid;
u_short16 olen;
int mc;					/* multicast rx flag */
{
    int 	ret = GOOD_RX;
    int 	nbr_is_dr = FALSE, nbr_is_bdr = FALSE;
    /* MODIFIED 2/7/92 delete nbr change */
    int		rtr_heard_from = FALSE;
    struct 	NBR *nbr;
    struct 	NBR *newnbr = NBRNULL;
    struct 	RHF *rhf, *last_rhf;
    struct 	LSDB_LIST *txq = LLNULL;
    struct 	AREA *area = AREA_PTR(intf);	/* area received from */

    if (intf->state == IDOWN) {
	/* wait until virtual nbr is brought up by trans area running SPF */
	if (intf->type == VIRTUAL_LINK)
	    return (UNKNOWN_VIRT_NBR);
	ospf_ifup(intf->ifspfndx);
	return (RX_ON_DOWN_IF);
    }

    /* 
     * a few validity checks 
     */
    if ((intf->type != VIRTUAL_LINK && intf->type != POINT_TO_POINT) &&
	hello->netmask != NDX_IP_MASK(intf->ifspfndx))
	return (BAD_HELLO_MASK);
    if (ntohs(hello->HelloInt) != intf->hello_timer)
	return (BAD_HELLO_TIMER);
    if (ntohl(hello->DeadInt) != intf->dead_timer)
	return (BAD_DEAD_TIMER);
    if ( ((hello->options & OPT_E_bit) && (area->ext_option)) ||
	 (!(hello->options & OPT_E_bit) && (!area->ext_option)) )
	return (BAD_HELLO_E_bit);

    /*
     * for multi-access nets find the nbr that origniated this hello
     */
    if (intf->type <= NONBROADCAST) {
	for (nbr = intf->nbr.next; nbr != NBRNULL; nbr = nbr->next) {
	    if (!nbr->nbrip_addr)
		continue;
	    if (ipsrc == nbr->nbrip_addr) {
		newnbr = nbr;
		break;
	    }
	}
    }
 
    /* 
     * Always go through new nbr case for ptop and virtuals
     */
    if (!newnbr) {			/* new nbr */
	if (rtrid == MY_ID)
	    return (HELLO_ID_CONFUSION);
	switch (intf->type) {
	    case POINT_TO_POINT:
		newnbr = &(intf->nbr);
		newnbr->nbrip_addr = ipsrc;
		break;

	    case VIRTUAL_LINK:
		newnbr = &(intf->nbr);
		break;

	    case NONBROADCAST:
		/* NBMA DR elig nbrs should be configured */
		if (intf->pri)
		    RX_LOG(mc,
			   UNKNOWN_NBMA_NBR,
			   intf->ifspfndx,
			   ipsrc);
		/* Fall through */
	    case BROADCAST:
		NBR_ALLOC(newnbr);
		if (!newnbr)
		    return (GOOD_RX);
		newnbr->nbrip_addr = ipsrc;
		nbr_enq(intf,newnbr);
		break;
	}
	if (intf->type != VIRTUAL_LINK) {
		newnbr->ifspfndx = intf->ifspfndx;
		newnbr->pri = hello->rtr_priority;
	} else  /* Is virtual link */
		if (newnbr->nbr_id != rtrid)
		    return (UNKNOWN_VIRT_NBR);
    }

    /* MODIFIED 11/27 */
    newnbr->nbr_id = rtrid;
    reset_inact_tmr(newnbr);		/* if not set don't set */


    /* 
     * have already reset rtr dead timer or will start in NHello 
     */
    if (intf->type == VIRTUAL_LINK || intf->type == NONBROADCAST) {
	if ((newnbr->state == NATTEMPT) || (newnbr->state == NDOWN))
	    (*(nbr_trans[HELLO_RX][newnbr->state])) (intf, newnbr);
    } else if (newnbr->state == NDOWN)
	(*(nbr_trans[HELLO_RX][newnbr->state])) (intf, newnbr);

    /* 
     * see if THIS rtr appears in the router-heard-from list 
     */
    last_rhf = (struct RHF *) ((u_long) & (hello->rhf) +
			       (olen - (OSPF_HDR_SIZE + HELLO_HDR_SIZE)));

    for (rhf = (struct RHF *) & (hello->rhf);
	 rhf <  last_rhf;
	 rhf++) {
	if (rhf->rtr == MY_ID) {
	    if (newnbr->state < N2WAY) {
		(*(nbr_trans[TWOWAY][newnbr->state])) (intf, newnbr);
	    	/* MODIFIED 12/11/91 fixed 1/29/92 fixed 2/12/92 */
	    }
	    rtr_heard_from++; 		/* flag that we found it */
	    break;
	}
    }

    /* drop back to one way until we can see ourself in this nbr's hello */
    if (!rtr_heard_from)
    {
	(*(nbr_trans[ONEWAY][newnbr->state])) (intf, newnbr);
    } else if (intf->type <= NONBROADCAST) {

	if (hello->dr == newnbr->nbrip_addr)
	    nbr_is_dr++;

	if (hello->bdr == newnbr->nbrip_addr)
	    nbr_is_bdr++;

	/* 
	 * if this nbr is bdr or it's dr and there is no bdr 
	 */
	if ((intf->state == IWAITING) &&
	    (((nbr_is_dr && !(hello->bdr))) || (nbr_is_bdr))) 
	{
		/* MODIFIED 11/22 - two lines added */
		newnbr->dr = hello->dr;
		newnbr->bdr = hello->bdr;
		/* MODIFIED 12/11/91 */
		/* removed line (*(if_trans[BACKUP_SEEN][intf->state])) (intf);
		*/
		/* MODIFIED 2/7/92 */
		intf->nbr_change = BACKUP_SEEN;	/* backup same as nbr change */
	} else if (hello->rtr_priority != newnbr->pri) /* priority change? */ {
	    newnbr->pri = hello->rtr_priority;
	    /* MODIFIED 2/7/92 */
	    if (intf->state >= IDr)
	    	intf->nbr_change = NBR_CHANGE;	/* schedule nbr change */
    	} else {	/* dr/bdr changeola? */
	    /* MODIFIED 2/7/92 nbr_change */
    	    if ((hello->dr != newnbr->dr) &&
      	    	((newnbr->dr == newnbr->nbrip_addr) || (nbr_is_dr)))
		intf->nbr_change = NBR_CHANGE;
    	    else if ((hello->bdr != newnbr->bdr) &&
      	    	((newnbr->bdr == newnbr->nbrip_addr) || (nbr_is_bdr)))
		intf->nbr_change = NBR_CHANGE;
	}

	newnbr->dr = hello->dr;
	newnbr->bdr = hello->bdr;

	/* MODIFIED 2/7/92 delete nbr change */
    }



    /* If not elig send hello to elig nbr if nbr isn't dr or bdr */
    if (intf->type == NONBROADCAST &&
	(!intf->pri) &&
	newnbr->pri &&
	intf->dr != newnbr &&
	intf->bdr != newnbr)
	send_hello(intf, newnbr);

    /* MODIFIED 2/7/92 added next 4 lines of code */
    if (intf->nbr_change) {
	(*(if_trans[intf->nbr_change][intf->state])) (intf);
    }
    /* build net and rtr lsa if necessary */
    if (intf->build_net) {
	area->spfsched |= build_net_lsa(intf, &txq, 0);
	intf->build_net = FALSE;
    }
    if (area->build_rtr) {
	area->spfsched |= build_rtr_lsa(area, &txq, 0);
	area->build_rtr = FALSE;
    }
    if (txq != LLNULL) {		/* may be locked out */
	self_orig_area_flood(area, txq, LS_RTR);
	freeq(&txq, OMEM_LL);
    }
    if (area->spfsched)
	RX_RUN_SPF(area);

    return (GOOD_RX);
}

#endif				/* PROTO_OSPF */
