/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/*
 *	Point-to-point interface flood routine
 */
void
ptp_flood(ll, intf, src_intf, src_nbr)
struct LSDB_LIST *ll;
struct INTF *intf;
struct INTF *src_intf;
struct NBR *src_nbr;
{
    struct NBR *n = &(intf->nbr);
    struct LSDB_LIST *l;
    int floodit = FALSE;
    int req_found;

    /* if < exchange don't use */
    if (n->state < NEXCHANGE)
	return;
    /* 
     * examine all new advertisements 
     */
    for (l = ll; l != LLNULL; l = l->ptr[NEXT]) {
	if (n->state == NEXCHANGE || n->state == NLOADING) {

	    /* check to see if any on this list are on request list */
	    req_found = nbr_rem_req(n, DB_ADV(l->lsdb));

	    if (n == src_nbr) {
		/* send delayed ack */
		if (req_found > REQ_LESS_RECENT)
		    add_ack(&(intf->acks), l->lsdb);
	    } else {
		/* 
		 * Not src nbr case 
		 */

		/* do the right thing per version on the req list */
		if (req_found == REQ_LESS_RECENT) {
		    add_nbr_retrans(n, l->lsdb);
		    add_db_retrans(l->lsdb, n);
		    l->flood = FLOOD;
		    floodit = TRUE;
		    break;
		}
	    }
	    if (req_found)
		continue;
	}				/* end of request */
	if (n == src_nbr) {
	    /* send delayed ack */
	    add_ack(&(intf->acks), l->lsdb);
	} else {			/* newer, so flood */
	    add_nbr_retrans(n, l->lsdb);
	    add_db_retrans(l->lsdb, n);
	    floodit = TRUE;
	    l->flood = FLOOD;
	}
    }					/* end of ll loop */
    if ((n->state == NEXCHANGE || n->state == NLOADING) && NO_REQ(n))
	(*(nbr_trans[LOAD_DONE][n->state])) (intf, n);
    if (floodit)
	send_lsu(ll, 0, intf, 0);
}


/*
 *	Multi-access interface flood routine
 */
void
ma_flood(ll, intf, src_intf, src_nbr)
struct LSDB_LIST *ll;
struct INTF *intf;
struct INTF *src_intf;
struct NBR *src_nbr;
{
    int floodit = FALSE;
    int req_found;
    struct NBR *n = intf->nbr.next;
    struct LSDB_LIST *l;

    /* 
     * examine all neighbors 
     */
    for (; n != NBRNULL; n = n->next) {
	/* if < exchange don't use */
	if (n->state < NEXCHANGE)
	    continue;

	/* 
	 * examine all new advertisements 
	 */
	for (l = ll; l != LLNULL; l = l->ptr[NEXT]) {
	    if (n->state == NEXCHANGE || n->state == NLOADING) {
		req_found = nbr_rem_req(n, DB_ADV(l->lsdb));
		if (n == src_nbr) {
		    if (src_intf->dr == n || src_intf->bdr == n) {
			/* received from DR or BDR */
			/* delayed ack */
			if (req_found > REQ_LESS_RECENT)
			    add_ack(&(intf->acks), l->lsdb);
		    } else {		/* received from IDROTHER */
			/* if this intf state is bdr ack, else if dr flood
			   without adding it to retrans list */
			if (src_intf->state == IBACKUP)	/* delayed ack */
			    add_ack(&(intf->acks), l->lsdb);
			else {
			    l->flood = FLOOD;
			    floodit = TRUE;
			}
		    }
		} else {		/* Not src nbr case */
		    /* we are requesting a newer version */
		    if (req_found == REQ_LESS_RECENT) {
			/* more recent has come in - flood to nbr */
			if (intf == src_intf && (intf->state == IDr ||
					       intf->state == IBACKUP)) {
			    add_nbr_retrans(n, l->lsdb);
			    add_db_retrans(l->lsdb, n);
			    if (intf->state != IBACKUP) {
				l->flood = FLOOD;
				floodit = TRUE;
			    }
			} else if (intf != src_intf) {
			    add_nbr_retrans(n, l->lsdb);
			    add_db_retrans(l->lsdb, n);
			    l->flood = FLOOD;
			    floodit = TRUE;
			}
		    }
		}			/* end of non-src nbr case */
		if (req_found)
		    continue;
	    }
	    /* state == NFULL || request not found */
	    if (n == src_nbr) {
		if (src_intf->dr == n || src_intf->bdr == n) {
		    /* received from DR or BDR */
		    add_ack(&(intf->acks), l->lsdb);	/* delayed ack */
		} else {			/* received from IDROTHER */
		    /*
		     * if this intf state is bdr ack else if dr flood
		     * without adding it to retrans list
		     */
		    if (src_intf->state == IBACKUP)	/* delayed ack */
			add_ack(&(intf->acks), l->lsdb);
		    else {
			l->flood = FLOOD;
			floodit = TRUE;
		    }
		}
	    } else {
		if (intf == src_intf &&
		    (intf->state == IDr || intf->state == IBACKUP)) {
		    add_nbr_retrans(n, l->lsdb);
		    add_db_retrans(l->lsdb, n);
		    if (intf->state != IBACKUP) {
			l->flood = FLOOD;
			floodit = TRUE;
		    }
		} else if (intf != src_intf) {
		    add_nbr_retrans(n, l->lsdb);
		    add_db_retrans(l->lsdb, n);
		    l->flood = FLOOD;
		    floodit = TRUE;
		}
	    }
	}				/* end o ll loop */
    }					/* end o nbr loop */
    for (n = intf->nbr.next; n != NBRNULL; n = n->next)
	if ((n->state == NEXCHANGE || n->state == NLOADING) && NO_REQ(n)) {
	    (*(nbr_trans[LOAD_DONE][n->state])) (intf, n);
	}
    if (floodit)
	send_lsu(ll, 0, intf, 0);
}

/*
 * flood non-self originated LSAs to this area
 * - called by rxlinkup
 */
void
area_flood(a, trans, src_intf, src_nbr, type)
struct AREA *a;
struct LSDB_LIST *trans;
struct INTF *src_intf;
struct NBR *src_nbr;
int type;
{
/* MODIFIED 2/5/92 removed param */
/* struct LSDB_LIST **net_txq;		/* for new net LSAs */

    struct INTF *intf;
    struct LSDB_LIST *l;

    for (intf = a->intf; intf < &(a->intf[a->ifcnt]); intf++) {
	for (l = trans;
	     l != LLNULL; l = l->ptr[NEXT])
	    l->flood = DONTFLOOD;
	if (intf->type == POINT_TO_POINT)
	    ptp_flood(trans, intf, src_intf, src_nbr);
	else				/* Multi-access flood */
	    ma_flood(trans, intf, src_intf, src_nbr);
    }

    if (type != LS_ASE &&
	a == ospf.area &&
	ospf.vcnt) {
	for (intf = ospf.vl; intf < &(ospf.vl[ospf.vcnt]); intf++) {
	    /* assume don't, set to flood otherwise */
	    for (l = trans; l != LLNULL; l = l->ptr[NEXT])
		l->flood = DONTFLOOD;
	    ptp_flood(trans, intf, src_intf, src_nbr);
	}
    }
}


/*
 * flood self-originated lsa's to this area
 */
int
self_orig_area_flood(a, trans, type)
struct AREA *a;
struct LSDB_LIST *trans;
int type;
{

    int floodit;
    int no_bufs;
    struct INTF *intf;
    struct NBR *n;
    struct LSDB_LIST *l;

    for (intf = a->intf; intf < &(a->intf[a->ifcnt]); intf++) {
	floodit = FALSE;
	for (l = trans; l != LLNULL; l = l->ptr[NEXT])
	    l->flood = FLOOD;
	for (n = FirstNbr(intf); n != NBRNULL; n = n->next)
	    if (n->state >= NEXCHANGE) {
		floodit++;		/* ok to send */
		if (n->state < NFULL) {
		    for (l = trans; l != LLNULL; l = l->ptr[NEXT])
			nbr_rem_req(n, DB_ADV(l->lsdb));
		    if (NO_REQ(n))
			(*(nbr_trans[LOAD_DONE][n->state])) (intf, n);
		}
		/* if recvd newer self-gen still add to retrans */
		for (l = trans; l != LLNULL; l = l->ptr[NEXT]) {
		    add_nbr_retrans(n, l->lsdb);
		    add_db_retrans(l->lsdb, n);
		}
	    }
	if (floodit) {
	    no_bufs = send_lsu(trans, 0, intf, 0);
	    if (no_bufs)
		return (FLAG_NO_BUFS);
	}
    }

    if (a == ospf.area &&
	ospf.vcnt &&
	type != LS_ASE) {
	for (intf = ospf.vl; intf < &(ospf.vl[ospf.vcnt]); intf++) {
	    n = &intf->nbr;
	    if (n->state >= NEXCHANGE) {
		if (n->state < NFULL) {
		    for (l = trans; l != LLNULL; l = l->ptr[NEXT])
			nbr_rem_req(n, DB_ADV(l->lsdb));
		    if (NO_REQ(n))
			(*(nbr_trans[LOAD_DONE][n->state])) (intf, n);
		}
		for (l = trans; l != LLNULL; l = l->ptr[NEXT]) {
		    add_nbr_retrans(n, l->lsdb);
		    add_db_retrans(l->lsdb, n);
		    l->flood = FLOOD;
		}
		no_bufs = send_lsu(trans, 0, intf, 0);
		if (no_bufs)
		    return (FLAG_NO_BUFS);
	    }
	}
    }
    return (FLAG_NO_PROBLEM);
}



#endif				/* PROTO_OSPF */
