/*
 *  isis_spf_print.c,v 1.11 1993/01/07 22:40:03 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */


#define	INCLUDE_CTYPE
#include "include.h"
#include "isis_includes.h"


static char  transd[]  = "0123456789abcdef";
/* used to translate hex digits for printing */

/* 
 * Format the address in sysid as a printable string in buf.
 */
char * 
spf_print_addr __PF3(buf, char *,
		     sysid, char *,
		     addr_type, enum addr_types)
{
	int i;

	switch(addr_type) {
		case is_id: {
			IS_ID * ispt = (IS_ID *)sysid;
			/* add this to print hex sysids */
			sprintf(buf,"IS:%x-%x-%x-%x-%x-%x:%x",
				ispt->addr[0], ispt->addr[1], ispt->addr[2],
				ispt->addr[3], ispt->addr[4], ispt->addr[5],
				ispt->addr[6]);
#ifdef addr_string
			sprintf(buf,"%c%c%c%c%c%c:%x ",
				ispt->addr[0], ispt->addr[1], ispt->addr[2],
				ispt->addr[3], ispt->addr[4], ispt->addr[5],
				ispt->addr[6]);
			/* get rid of non-printing chars */
			for (i=0; i<=6;i++)
				if (!isprint(buf[i]))
					buf[i]=' ';
#endif
		}
		break;
		case es_id: {
			ES_ID * espt = (ES_ID *)sysid;
			sprintf(buf,"ES:%x-%x-%x-%x-%x-%x",
				espt->addr[0],
				espt->addr[1],
				espt->addr[2],
				espt->addr[3],
				espt->addr[4],
				espt->addr[5]);
		}
		break;
		case addr_pref: {
			ADDR_PREF *prpt = (ADDR_PREF *) sysid;
			sockaddr_un *sa;
			sa = sockbuild_iso(prpt->addr, (prpt->pref_len + 1) >> 1);
			sprintf(buf,"PREF:%A",sa);
		}
		break;
		case inet_net: {
			INET_NET * ipt = (INET_NET *) sysid;
			/* ignore mask for now */
			sprintf(buf,"%d.%d.%d.%d",
				ipt->addr[0],ipt->addr[1],ipt->addr[2],ipt->addr[3]);
		}
		break;
		case area_addr: {
			AREA_ADDR *apt = (AREA_ADDR *) sysid;
			sockaddr_un *sa;
			sa = sockbuild_iso(apt->addr, apt->area_len);
			sprintf(buf,"AREA:%A",sa);
		}
		break;
		default:
			printf("unexpected addr_type %d\n",addr_type);
	}
	return buf;
}


/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3.5
 * 
 * 	Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */
