/*
 *  flock.c,v 1.9 1993/02/11 03:59:23 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */

#define	INCLUDE_FILE
#define	INCLUDE_STAT

#include "include.h"

/* Emulation of flock() using lockf() */

#if	__GNUC__ >= 2
PROTOTYPE(flock,
	  int,
	  (int,
	   int));
#endif	/* __GNUC__ >= 2 */
int
flock(fd, flags)
int fd;
int flags;
{
#ifdef	F_LOCK
    int rc;
    int cmd = 0;

    switch (BIT_TEST(flags, LOCK_EX|LOCK_SH|LOCK_UN)) {

    case LOCK_SH|LOCK_EX:
    case LOCK_EX:
	cmd = BIT_TEST(flags, LOCK_NB) ? F_TLOCK : F_LOCK;

	break;

    case LOCK_UN:
	cmd = F_ULOCK;
	break;

    case LOCK_SH:
	/* We don`t do shared locks */
    default:
	errno = EINVAL;
	return -1;
    }
    
    lseek(fd, 0L, 0);

    NON_INTR(rc, lockf(fd, cmd, 0L));
    if (rc < 0) {
	switch (errno) {
	case EACCES:
	case EAGAIN:
	    errno = EWOULDBLOCK;
	    break;

	default:
	    break;
	}
    }

    return rc;
#else	/* F_LOCK */
    return 0;
#endif	/* F_LOCK */
}


/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3.5
 * 
 * 	Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
