# Copyright (c) 2000                                RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


## "Generic" configuration file for RIP.
## There are quite a few variables to configure;
## however, you can leave part of the variables
## if you don't use a part of the software (e.g. dbupdate).
## Please don't forget to also modify your $SOURCEFILE.


######################
###
### GENERIC VARIABLES
###
######################

#
# The directory where all sorts of lockfiles are kept

LOCKDIR /home/tiago/k/whois/var/lock


#
# The directory where all sorts of temporary files
# are kept.
# 
# make sure that this directory is owned by the 'updating process'
# user and cannot be written by other users

TMPDIR /home/tiago/k/whois/var/tmp

#
# Where is the RIPADMIN database
# Syntax:
# RIPADMIN MySQL_Host,MySQL_Port,MySQL_User,MySQL_Password,MySQL_RIPADMIN_DB

RIPADMIN sqlhost,3306,dbuser,dbpsw,RIPADMIN

#
# Location of the file containing the SOURCE variables

SOURCEFILE /home/tiago/k/whois/conf/sources.config.sample.q


######################
###
### LOGFILE DEFINITIONS
###
######################

## These variables indicate base filenames;
## the subdirectories have to be created manually beforehand.

##
## Query log
##

QRYLOG /home/tiago/k/whois/log/qry/qrylog

##
## Error logs
##

#
# All dbupdate errors (only needed if you use dbupdate)

DBUPERR /home/tiago/k/whois/log/dbuperr/dbuperrlog

#
# All whois_rip errors

ALLRIPERR /home/tiago/k/whois/log/riperr/riperrlog

#
# Audit log: security-related messages

RIPAUDIT /home/tiago/k/whois/log/audit/auditlog

#
# Mirroring log

RIPMIRLOG /home/tiago/k/whois/log/mirror/mirrorlog

#
# Server log: all administration messages (startup, shutdown, etc)
# and errors

RIPSVRLOG /home/tiago/k/whois/log/svr/svrlog

#
# SQL errors

SQLOG /home/tiago/k/whois/log/sql/sqlog

#
# All update transactions are logged here

RIPUPDLOG /home/tiago/k/whois/log/ripupd/ripupdlog


##
## Update logs
## You need them only if you use dbupdate
##

#
# The file where all update requests are logged
# It must be rotated externally if needed

UPDLOG /home/tiago/k/whois/log/upd/updlog

#
# The file where all acknowledgements are logged
# It must be rotated externally if needed

ACKLOG /home/tiago/k/whois/log/ack/acklog

#
# The file where all notifications are logged
# It must be rotated externally if needed

NOTIFLOG /home/tiago/k/whois/log/notif/notiflog

#
# The file where all forwardings are logged
# It must be rotated externally if needed

FORWLOG /home/tiago/k/whois/log/forw/forwlog

######################
###
### WHOISD VARIABLES
###
######################

#
# KEEPOPEN [not implemented yet]
# Keep connection open for at most KEEPOPEN seconds for 
# network updates & whoisd '-k' keep connection open option

KEEPOPEN 180

#
# Port for the whois server

SVWHOIS_PORT 43001

#
# Port for the config interface

SVCONFIG_PORT 43002

#
# Port for the mirroring server

SVMIRROR_PORT 43003


###########
##
## Files
##

#
# Location of the help file printed in response
# to "whois help" queries

PW_HELP_FILE /home/tiago/k/whois/doc/WHOIS-HELP


###########
##
## Access control
##

##
## In short, access control works in the following way:
## the more you query, the more your "ACL points" grow, 
## until at a certain point you are blocked. 
## First temporarily, then permanently.
## For temporary blocks, your points decay in time.
## These variables configure the decay time.

## (You probably don't want to change these variables).

#
# Interval of the decay (in seconds)

AC_DECAY_INTERVAL 600

#
# Halflife of the decay (in seconds)

AC_DECAY_HALFLIFE 43200

#
# auto save of access tree 

AC_AUTO_SAVE 1

#
# Startup loading of access tree data stored on persistence

AC_LOAD 1

#
# Interval of making persistence (in seconds)

AC_SAVE_INTERVAL 1200


###########
##
## Response texts
##

## The only things you need to change here are the
## pointers to your own URLs and specific site-related information.

#
# Banner. This text comes out before the query is answered.

PW_BANNER % This is the MyDB Whois server.

#
# Standard response header

PW_RESP_HEADER % Rights restricted by copyright.
PW_RESP_HEADER % See http://www.mydb.net/db/copyright.html

#
# Access control limit reached

PW_FMT_LIMIT_REACHED %%ERROR:202: access control limit reached for %s
PW_FMT_LIMIT_REACHED %%
PW_FMT_LIMIT_REACHED %% You have reached the limit of returned contact information objects.
PW_FMT_LIMIT_REACHED %% This connection will be terminated now.
PW_FMT_LIMIT_REACHED %% Continued attempts to return excessive amounts of contact
PW_FMT_LIMIT_REACHED %% information will result in permanent denial of service.
PW_FMT_LIMIT_REACHED %% Please do not try to use CONTACT information in
PW_FMT_LIMIT_REACHED %% My Database for non-operational purposes.
PW_FMT_LIMIT_REACHED %% Refer to http://www.mydb.net/db/copyright.html for more information.

#
# Access denied permanently

PW_FMT_ACL_PERMDENY %%ERROR:201: access denied for %s
PW_FMT_ACL_PERMDENY %%
PW_FMT_ACL_PERMDENY %% Sorry, access from your host has been permanently denied
PW_FMT_ACL_PERMDENY %% because of a repeated abusive behaviour.
PW_FMT_ACL_PERMDENY %% Please contact <my-dbm@mydb.net> for unblocking.

#
# Too many connections from the host

PW_FMT_ACL_CONNDENY %%ERROR:208: connection refused for %s
PW_FMT_ACL_CONNDENY %%
PW_FMT_ACL_CONNDENY %% Sorry, your connection is refused.
PW_FMT_ACL_CONNDENY %% Too many simultaneous connections from your host.

##
## You don't need to change the following response texts
##

#
# No key supplied in query

PW_ERR_NOKEY %ERROR:106: no search key specified
PW_ERR_NOKEY %
PW_ERR_NOKEY % No search key specified

# Line too long

PW_ERR_LINETOOLONG %ERROR:107: input line too long
PW_ERR_LINETOOLONG %
PW_ERR_LINETOOLONG % Input exceeds the maximum line length.

#
# For data retrieved with the "-K" flag

PW_K_FILTER % Note: this output has been filtered.
PW_K_FILTER % Only primary keys will be visible.
PW_K_FILTER % Contact information will not be shown

#
# User is not authorised to pass IP addresses with "-V" flag

PW_FMT_ACL_ADDRPASS %%ERROR:203: address passing not allowed for %s
PW_FMT_ACL_ADDRPASS %%
PW_FMT_ACL_ADDRPASS %% Sorry, you are not allowed to pass addresses on the query line .
PW_FMT_ACL_ADDRPASS %% Please contact us for such permission. For the moment, continuing
PW_FMT_ACL_ADDRPASS %% this will cause permanent denial of access.

#
# No object found

PW_NOTFOUND %ERROR:101: no entries found
PW_NOTFOUND %
PW_NOTFOUND % No entries found in the selected source(s).

#
# The connection is administratively or abnormally closed

PW_CONNCLOSED %ERROR:301: connection has been closed 
PW_CONNCLOSED %
PW_CONNCLOSED % The connection has been closed. 

#
# Unknown attribute in query

QC_FMT_BADATTR %%ERROR:104: unknown attribute
QC_FMT_BADATTR %%
QC_FMT_BADATTR %% "%s" is not a known attribute.

#
# The attribute specified is not inverse searchable

QC_FMT_ATTRNOTINV %%ERROR:105: attribute is not searchable
QC_FMT_ATTRNOTINV %%
QC_FMT_ATTRNOTINV %% "%s" is not an inverse searchable attribute.

# Illegal character in query

QC_BADINPUT %ERROR:108: bad character in input
QC_BADINPUT %
QC_BADINPUT % An invalid character was passed in the query.  Allowed
QC_BADINPUT % characters are letters, numbers, and these: -_:+=.,@/?'.

#
# There is no such source

QC_FMT_BADSOURCE %%ERROR:102: unknown source
QC_FMT_BADSOURCE %%
QC_FMT_BADSOURCE %% "%s" is not a known source.
QC_FMT_BADSOURCE %% Use "-q sources" to list known sources.


#
# There is no such object type

QC_FMT_BADOBJTYPE %%ERROR:103: unknown object type
QC_FMT_BADOBJTYPE %%
QC_FMT_BADOBJTYPE %% "%s" is not a known object type.
QC_FMT_BADOBJTYPE %% Use "-q types" to list known object types.

#
# Multiple "-V" flags were used to pass IP addresses

QC_DUPPROXYIPFLAG %ERROR:205: multiple addresses passed by proxy
QC_DUPPROXYIPFLAG %
QC_DUPPROXYIPFLAG % More than one -V flag passed the address of a client.
QC_DUPPROXYIPFLAG % This is an error in the proxy server.  Please contact
QC_DUPPROXYIPFLAG % the administrator of the server and report this error.

#
# Duplicate IP flags
QC_FMT_DUPIPFLAG %%WARNING:901: duplicate IP flags passed
QC_FMT_DUPIPFLAG %%
QC_FMT_DUPIPFLAG %% More than one IP flag (-l, -L, -m, -M, -x, or -c) passed to the server.
QC_FMT_DUPIPFLAG %% Only "-%s" will be used for this query.

#
# Useless IP flags

QC_USELESSIPFLAG %WARNING:902: useless IP flag passed
QC_USELESSIPFLAG %
QC_USELESSIPFLAG % An IP flag (-l, -L, -m, -M, -x, or -c) used without an IP key.

#
# Useless no-referral flag

QC_USELESSNOREFFLAG %WARNING:904: useless no-referral flag passed
QC_USELESSNOREFFLAG %
QC_USELESSNOREFFLAG % The -R flag used for a non-domain key.

#
# Fixed lookup

QC_FMT_FIXEDLOOKUP %%WARNING:905: fixed lookup key
QC_FMT_FIXEDLOOKUP %%
QC_FMT_FIXEDLOOKUP %% The key "%s" has been changed to "%s" for lookup.



##
## Referral texts
## (You probably don't want to change them)
##

#
# Referral timeout (in seconds)

REFERRALTIMEOUT 15

#
# Referral timeout error

QI_REF_TMOUT %ERROR:302: referral timeout 
QI_REF_TMOUT %
QI_REF_TMOUT % Referral timeout

# 
# Maximum referral lines allowed

REFERRALMAXLINES 250

#
# Maximum referral lines exceeded message

QI_REF_OVERMAXLIN %ERROR:204: maximum referral lines exceeded
QI_REF_OVERMAXLIN %
QI_REF_OVERMAXLIN % Referral reply line limit exceeded

#
# No referral host

QI_REF_BADHOST %ERROR:303: no referral host
QI_REF_BADHOST %
QI_REF_BADHOST % Referral host not found

#
# Host not responding

QI_REF_HOSTNOTTRESP %ERROR:304: referral host not responding 
QI_REF_HOSTNOTTRESP %
QI_REF_HOSTNOTTRESP % Referral host not responding

#
# Referral header

QI_FMT_REFHEADER %% The object shown below is NOT in the %s database.
QI_FMT_REFHEADER %% It has been obtained by querying a remote server:
QI_FMT_REFHEADER %% (%s) at port %d.
QI_FMT_REFHEADER %% To see the object stored in the %s database
QI_FMT_REFHEADER %% use the -R flag in your query
QI_FMT_REFHEADER %%
QI_FMT_REFHEADER %%REFERRAL START 

#
# Referral trailer 

QI_REFTRAILER %%REFERRAL END




######################
###
### DBUPDATE VARIABLES
###
######################

##
## You don't need to change *anything* below this point
## if you are not using dbupdate!
##


###########
##
## Sources
##

#
# The update source. The format is:
#
# (NOTE....this line is split on spaces and commas
#          so make sure the format is matched exactly.)
#
# UPDSOURCE SRCname DB-details  whois_rip-host,QRY-port,UPD-port
#
# where
#
# DB-details = MySQL_Host,MySQL_Port,MySQL_User,MySQL_Password,MySQL_DB

UPDSOURCE SAMPLE sqlhost,3306,dbuser,dbpsw,SAMPLEDB whois.mydb.net,43001,43004


###########
##
## Auth Methods
##

# valid authentication methods accepted by dbupdate

AUTHMETHOD NONE
AUTHMETHOD CRYPT-PW
AUTHMETHOD MD5-PW
AUTHMETHOD PGPKEY


###########
##
## Settings
## 

#
# Run database sw in test mode?  
# If set, the mntner and as-block creation requests are
# automatically processed and not sent to HUMAILBOX

TESTMODE  0

#
# Crypted password to override all security for updates
# 
# Example usage:
#
# object: My Object
# [...]
# source: MYSRC
# override: Reason_for_overriding_all_security Password
#
# [ This sample crypted password correspond to the word "password" ]

OVERRIDECRYPTEDPW   1F.5OTsRVjwLo

#
# PGP key to override all security for updates
# Similar to OVERRIDECRYPTEDPW, but accepts PGP-signed messages
#
OVERRIDEPGP   11111111
OVERRIDEPGP   22222222

#
# ALLOCMNT
# List of maintainers which can create an inetnum object 
# with status ALLOCATED (one per line or space separated list
# or combination of the above)

ALLOCMNT MY-OWN-MNT

#
# ORG_POWER_MNT
# List of maintainers which can create organistion objects with
# "org-type:" IANA, RIR, NIR or LIR (one per line or space separated list
# or combination of the above)

ORG_POWER_MNT MY-OWN-MNT

###########
##
## Files
## 

# ack and notif message templates
ACKTEMPLATE /home/tiago/k/whois/conf/ack_template
NOTIFTEMPLATE /home/tiago/k/whois/conf/notif_template
FRWDTEMPLATE /home/tiago/k/whois/conf/frwd_template
FORWCREATETEMPLATE /home/tiago/k/whois/conf/forw_create_template


#
# UPDATELOCK [not implemented yet]
# Name of the lockfile for stopping updates
# It will be located in LOCKDIR
# Just the existence of this file will block all updates

UPDATELOCK STOPUPDATES

#
# The directory where the GPG process stores 
# the server's public keyring.

PGPPATH /home/tiago/k/whois/.gnupg


###########
##
## Commands
##

#
# GPGCMD
# Full pathname of your gpg executable

GPGCMD /usr/local/bin/gpg

#
# X.509-related stuff
#
#  NOT IN USE

OPENSSLCMD NULL
CRLLIST NULL
CACERTS NULL


#
# MAILCMD is the command into which a composed e-mail is given as standard
# input, to be send as mail. The message piped into this command has ALL
# the necessary mail header to process the mail:
# From:
# To:
# Subject:
# The mail command should take the recipients from the actual message.
# Using sendmail it will be executed as: /usr/lib/sendmail -t < "messagefile"
# (default: /usr/lib/sendmail -t)
#
# NOTE:
# -fmy-dbm makes my-dbm the trusted user that will appear on the
# envelope. Bounces will go to this address. If you do not specify
# this, sendmail will send bounces straight back to the automatic
# mailbox, where it will bounce again, and again, ....
# User has to be a trusted user, T<name> in sendmail.cf.

MAILCMD /usr/lib/sendmail -fmy-dbm -t


###########
##
## E-mail settings
##

#
# HUMAILBOX is a human mailbox, used for forwarding
# special objects. IT MUST NOT BE THE AUTOMATIC MAILBOX!!!!

HUMAILBOX       my-dbm@mydb.net

#
# AUTOBOX is the mailbox used for automatic updates.
# The users must send mail to this address (and not
# HUMAILBOX) to get their updates processed.

AUTOBOX         auto-dbm@mydb.net

# DEFMAIL is the mailbox used when no mail notifications or acknowledgements
# both as to and from address in various places.

DEFMAIL my-dbm@ripe.net

###########
##
## nic suffixes
##

NICSUFFIX RIPE
NICSUFFIX ORG
NICSUFFIX ARIN
NICSUFFIX LACNIC
NICSUFFIX RADB
NICSUFFIX APNIC
NICSUFFIX RIPN


###########
##
## Countries
##

##
## A list of valid ISO country codes for inetnum checks
## You probably will never have to modify this
##

COUNTRY AD
COUNTRY AE
COUNTRY AF
COUNTRY AG
COUNTRY AI
COUNTRY AL
COUNTRY AM
COUNTRY AN
COUNTRY AO
COUNTRY AQ
COUNTRY AR
COUNTRY AS
COUNTRY AT
COUNTRY AU
COUNTRY AW
COUNTRY AZ
COUNTRY BA
COUNTRY BB
COUNTRY BD
COUNTRY BE
COUNTRY BF
COUNTRY BG
COUNTRY BH
COUNTRY BI
COUNTRY BJ
COUNTRY BM
COUNTRY BN
COUNTRY BO
COUNTRY BR
COUNTRY BS
COUNTRY BT
COUNTRY BV
COUNTRY BW
COUNTRY BY
COUNTRY BZ
COUNTRY CA
COUNTRY CC
COUNTRY CD
COUNTRY CF
COUNTRY CG
COUNTRY CH
COUNTRY CI
COUNTRY CK
COUNTRY CL
COUNTRY CM
COUNTRY CN
COUNTRY CO
COUNTRY CR
COUNTRY CS
COUNTRY CU
COUNTRY CV
COUNTRY CX
COUNTRY CY
COUNTRY CZ
COUNTRY DE
COUNTRY DJ
COUNTRY DK
COUNTRY DM
COUNTRY DO
COUNTRY DZ
COUNTRY EC
COUNTRY EE
COUNTRY EG
COUNTRY EH
COUNTRY ER
COUNTRY ES
COUNTRY ET
COUNTRY EU
COUNTRY FI
COUNTRY FJ
COUNTRY FK
COUNTRY FM
COUNTRY FO
COUNTRY FR
COUNTRY FX
COUNTRY GA
COUNTRY GB
COUNTRY GD
COUNTRY GE
COUNTRY GF
COUNTRY GH
COUNTRY GI
COUNTRY GL
COUNTRY GM
COUNTRY GN
COUNTRY GP
COUNTRY GQ
COUNTRY GR
COUNTRY GS
COUNTRY GT
COUNTRY GU
COUNTRY GW
COUNTRY GY
COUNTRY HK
COUNTRY HM
COUNTRY HN
COUNTRY HR
COUNTRY HT
COUNTRY HU
COUNTRY ID
COUNTRY IE
COUNTRY IL
COUNTRY IN
COUNTRY IO
COUNTRY IQ
COUNTRY IR
COUNTRY IS
COUNTRY IT
COUNTRY JM
COUNTRY JO
COUNTRY JP
COUNTRY KE
COUNTRY KG
COUNTRY KH
COUNTRY KI
COUNTRY KM
COUNTRY KN
COUNTRY KP
COUNTRY KR
COUNTRY KW
COUNTRY KY
COUNTRY KZ
COUNTRY LA
COUNTRY LB
COUNTRY LC
COUNTRY LI
COUNTRY LK
COUNTRY LR
COUNTRY LS
COUNTRY LT
COUNTRY LU
COUNTRY LV
COUNTRY LY
COUNTRY MA
COUNTRY MC
COUNTRY MD
COUNTRY MG
COUNTRY MH
COUNTRY MK
COUNTRY ML
COUNTRY MM
COUNTRY MN
COUNTRY MO
COUNTRY MP
COUNTRY MQ
COUNTRY MR
COUNTRY MS
COUNTRY MT
COUNTRY MU
COUNTRY MV
COUNTRY MW
COUNTRY MX
COUNTRY MY
COUNTRY MZ
COUNTRY NA
COUNTRY NC
COUNTRY NE
COUNTRY NF
COUNTRY NG
COUNTRY NI
COUNTRY NL
COUNTRY NO
COUNTRY NP
COUNTRY NR
COUNTRY NU
COUNTRY NZ
COUNTRY OM
COUNTRY PA
COUNTRY PE
COUNTRY PF
COUNTRY PG
COUNTRY PH
COUNTRY PK
COUNTRY PL
COUNTRY PM
COUNTRY PN
COUNTRY PR
COUNTRY PS
COUNTRY PT
COUNTRY PW
COUNTRY PY
COUNTRY QA
COUNTRY RE
COUNTRY RO
COUNTRY RU
COUNTRY RW
COUNTRY SA
COUNTRY SB
COUNTRY SC
COUNTRY SD
COUNTRY SE
COUNTRY SG
COUNTRY SH
COUNTRY SI
COUNTRY SJ
COUNTRY SK
COUNTRY SL
COUNTRY SM
COUNTRY SN
COUNTRY SO
COUNTRY SR
COUNTRY ST
COUNTRY SV
COUNTRY SY
COUNTRY SZ
COUNTRY TC
COUNTRY TD
COUNTRY TF
COUNTRY TG
COUNTRY TH
COUNTRY TJ
COUNTRY TK
COUNTRY TM
COUNTRY TN
COUNTRY TO
COUNTRY TP
COUNTRY TR
COUNTRY TT
COUNTRY TV
COUNTRY TW
COUNTRY TZ
COUNTRY UA
COUNTRY UG
COUNTRY UM
COUNTRY US
COUNTRY UY
COUNTRY UZ
COUNTRY VA
COUNTRY VC
COUNTRY VE
COUNTRY VG
COUNTRY VI
COUNTRY VN
COUNTRY VU
COUNTRY WF
COUNTRY WS
COUNTRY YE
COUNTRY YT
COUNTRY ZA
COUNTRY ZM
COUNTRY ZW
