/***************************************
  $Revision: 1.2 $

  er_WH_errors.h - definition of errors for the whois module

  Status: NOT REVUED, NOT TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999,2000,2001,2002               RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
***************************************/

/* step 1 */

typedef enum {
	 LOW_WH_OK=0,
	 LOW_WH_TIMEOUT,    
 	 LOW_WH_MAXLINES,
 	 LOW_WH_CONNECT,
	 LOW_WH_BADHOST,
	 LOW_WH_SOCKET,
	 LOW_WH_BIND,
	 LOW_WH_OPEN
} WH_err_code_t;

/* step 2 */

#define WH_OK		ER_SEV_I + (FAC_WH<<16) + LOW_WH_OK
#define WH_TIMEOUT      ER_SEV_W + (FAC_WH<<16) + LOW_WH_TIMEOUT
#define WH_MAXLINES     ER_SEV_W + (FAC_WH<<16) + LOW_WH_MAXLINES

#define WH_CONNECT      ER_SEV_E + (FAC_WH<<16) + LOW_WH_CONNECT
#define WH_BADHOST      ER_SEV_E + (FAC_WH<<16) + LOW_WH_BADHOST
#define WH_SOCKET       ER_SEV_E + (FAC_WH<<16) + LOW_WH_SOCKET
#define WH_BIND         ER_SEV_E + (FAC_WH<<16) + LOW_WH_BIND
#define WH_OPEN         ER_SEV_E + (FAC_WH<<16) + LOW_WH_OPEN


/* step 3 */

#ifdef ER_IMPL

er_list_t WH_mod_err[]={
  { ERDUP(WH_OK),  	"OK" },
  { ERDUP(WH_TIMEOUT),  "timeout getting data" },
  { ERDUP(WH_MAXLINES), "maxlines limit exceeded" },
  { ERDUP(WH_CONNECT),  "cannot connect" },  
  { ERDUP(WH_BADHOST),  "cannot find such host" },
  { ERDUP(WH_SOCKET),   "cannot create a socket" },
  { ERDUP(WH_BIND),     "cannot bind to socket" },
  { ERDUP(WH_OPEN),     "cannot open socket for reading" },
  ER_LASTTXT
};

#endif /* ER_IMPL */
