/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StateMessageDatatype;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;

public class ENTITYDatatypeValidator
extends StringDatatypeValidator {
    public static final int ENTITY_VALIDATE = 0;

    public ENTITYDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public ENTITYDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
        if (bl) {
            return;
        }
        this.setTokenType("ENTITY");
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        return string.equals(string2) ? 0 : -1;
    }

    public short getWSFacet() {
        return 2;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        StringPool stringPool;
        int n;
        Object[] objectArray;
        DefaultEntityHandler defaultEntityHandler;
        super.validate(string, object);
        StateMessageDatatype stateMessageDatatype = (StateMessageDatatype)object;
        if (stateMessageDatatype != null && stateMessageDatatype.getDatatypeState() == 0 && !(defaultEntityHandler = (DefaultEntityHandler)(objectArray = (Object[])stateMessageDatatype.getDatatypeObject())[0]).isUnparsedEntity(n = (stringPool = (StringPool)objectArray[1]).addSymbol(string))) {
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException("ENTITY '" + string + "' is not valid");
            invalidDatatypeValueException.setMinorCode(79);
            invalidDatatypeValueException.setMajorCode(62);
            throw invalidDatatypeValueException;
        }
        return null;
    }
}

