#!/usr/local/bin/perl5 -w

# 16 04 2001 EG
#
# This script extracts 'certif' attributes of key-cert objects from sql database
# to be feed into gpg (to create a public keyring). 

# Usage: $0 sqlserver port username passwd dbasename

use strict;

#Perl DBI interface 
use DBI;
use DBD::mysql; 


#
# sub get_certif
# Takes an RPSL key-cert object and extracts its
# certificate.
sub get_certif {

  my $obj = shift @_;
  my $certif = '';
  $obj =~ s/^[\s\n]*//;
  #print "DEBUG: \$obj is [$obj]\n";
  if($obj !~ /^key-cert:/){

    return "***Error!\n";

  }else{

    my @lines = split("\n", $obj);

    # here we implement a state machine to construct the 
    # certificate from 'certif:' attributes. We read the object
    # line by line
    my($state) = 'INIT';
    my $i;
    foreach $i (@lines){
      #print "State = $state\n";
      #print "line = [$i]\n";
      if($i =~ /^certif:/i){
        if ($state eq 'INIT'){
          $i =~ s/^certif://i; # delete 'certif:'
          $i =~ s/^\s*//;      # delete white space in the beginning
          $certif = "$certif\n$i";
          $state = 'CERTIF';
        }elsif($state eq 'CERTIF'){
          $i =~ s/^certif://i; # delete 'certif:'
          $i =~ s/^\s*//;      # delete white space in the beginning
          $certif = "$certif\n$i";
        }elsif($state eq 'ELSE'){
          $i =~ s/^certif://i; # delete 'certif:'
          $i =~ s/^\s*//;      # delete white space in the beginning
          $certif = "$certif\n$i";
          $state = 'CERTIF';
        }else{
          print STDERR "Unknown state $state!\n";
        }
      }elsif($i =~ /^[\s\+]/){
        if ($state eq 'INIT'){
          print STDERR "Cannot happen in INIT state!\n";
        }elsif($state eq 'CERTIF'){
          $i =~ s/^\s*//;      # delete white space in the beginning
          $certif = "$certif\n$i";
        }elsif($state eq 'ELSE'){
        }else{   
          print STDERR "Unknown state $state!\n";
        }

      }else{
        if ($state eq 'INIT'){
          #print STDERR "Cannot happen in INIT state!\n";
          $state = 'ELSE'; 
        }elsif($state eq 'CERTIF'){
          $state = 'ELSE';
        }elsif($state eq 'ELSE'){
        }else{           
          print STDERR "Unknown state $state!\n";
        }

      }
    }

  }
  return $certif;
}




# sub closeDBHandle: closes DB handle 
# input: $stHandle: execution handle, 
#        $dbHandle: DBI handle
#
sub closeDBHandle {
    my($stHandle, $dbHandle) = @_;
  if($stHandle){
    $stHandle->finish;
    $dbHandle->disconnect;
  }
  elsif($dbHandle->disconnect){
    $dbHandle->disconnect;
  }

}


# Main


if($#ARGV != 4){
  print "Usage: $0 sqlserver port username passwd dbasename\n";
  exit(1);
}

my($dbName) = $ARGV[4] ;

my($dbHost) = $ARGV[0];
my($port) =  $ARGV[1];

my($data_source) = 'DBI:mysql:'. $dbName. ':'. $dbHost . ':' . $port; 

my($defaultuser) = $ARGV[2];
my($passwd) = $ARGV[3];


my($certif) = '';

my($dbHandle,  #DBI handle
   $stHandle #query execution handle
   );

$dbHandle =  DBI->connect($data_source , $defaultuser, $passwd);
unless ($dbHandle) {
    #error in connecting;
    #try a close, even though not necessary
    &closeDBHandle($stHandle, $dbHandle);
    return ('DBI : '. $DBI::errstr);
}


# construct the querry
my($query) = 'SELECT STRAIGHT_JOIN obj.object FROM key_cert AS keycert, 
                                     last AS obj 
              WHERE keycert.object_id = obj.object_id';


# do the query
$stHandle  = $dbHandle->prepare($query);
my($rc) = $stHandle->execute  ;

# If error return, print error string 
unless(($rc) or ($stHandle->errstr)) {
        
   print STDERR 'MySQL  Query:' .  $stHandle->errstr;

}else{# print the result
 
  if($DBI::rows > '0' ) 
  {
      print("Found  $DBI::rows result(s).\n");
      # print them out
      my($i, @values); 
      while ( ((@values) = $stHandle->fetchrow_array)){
        foreach $i (@values) {
           #print "[$i]\n";
           $certif = &get_certif($i); 
           print $certif,"\n";
        }
      }

  }
  else  { 
      print("No Match Found\n");
  }


}


&closeDBHandle($stHandle, $dbHandle);
