#!/usr/local/bin/perl5



# A simple networkupdate client
# Command line options:  -h <host> 
#                        -p <port>


######################
#  Copyright (c) 2001                              RIPE NCC
#
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and its
#  documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and that
#  both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
#  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
#  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
#  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
#  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
#  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
######################

# $Revision: 1.1 $


use IO::Socket;
use IO::Select;
use Getopt::Std;

getopts("h:p:");


# the default server is whois.ripe.net
$remotehost = $opt_h ? $opt_h : 'whois.ripe.net';

# the default port is 43
$remoteport = $opt_p ? $opt_p : 43;




$socket = IO::Socket::INET->new( PeerAddr => $remotehost,
                                 PeerPort => $remoteport,
                                 Proto => "tcp",
                                 Type => SOCK_STREAM)
      or die "Couldn't connect to remote host: $@";


# $socket must be flushed after every print 
$oldfh = select($socket); $| = 1; select($oldfh);


$select = IO::Select->new();
$select->add(\*STDIN);
$select->add($socket);

# set timeout for select to 10 secs
$timeout = 10; 

while(1){

  @read_from = $select->can_read($timeout);
  foreach $fd (@read_from){


    if($fd == $socket){ # if it was a socket, read data from it, 
                        # print it to STDOUT

       $n = $socket->sysread($string, 1024);
       if(!defined($n)){ die; }
       print "$string";

    }elsif($fd == \*STDIN){ # if it was STDIN, read data from it,
                            # and print to socket

      $n = sysread(STDIN, $string, 1024);
      if(!defined($n)){ die; }
      if($n == 0){ # EOF

        close($socket);
        exit(0);

      }

      print $socket $string;
    }


  }
}


