#
# dbopen - open a database and lock exclusively if opened for writing
#
# ***NOTE***: flock doesn't work on NFS mounted file systems!!!
#             and thus locking doesn't work properly on NFS file systems
#
#	$RCSfile: dbopen.pl,v $
#	$Revision: 2.2 $
#	$Author: david $
#	$Date: 1996/08/16 13:00:34 $
#
#
# arguments:
#            *database = pointer to file handle, dbm array and normal array
#            *entry  = pointer to object, determines what file to open
#            $write  = open for write or not
#            $name   = open a file independent of type

require "defines.pl";

sub dbname {
    local(*entry)=@_;
    
    local($name)=$DBFILE{$entry{"so"}};
	
    $name.=".".&entype(*entry) if ($SPLIT{$entry{"so"}});
    
    print STDERR "dbname - name: $name\n" if ($opt_V);
       
    return $name;
    
}


sub dbopen {
    local(*database, *entry, $write, $name) = @_;

    $name=&dbname(*entry) if ($name=~ /^\s*$/);
    
    print STDERR "dbopen - name: ", $name, "\n" if (($opt_V) && ($name));
    
    if ($write) {
       
	# If we want to open the dbfile for writing, make sure that
	# cleandb is not using the database. If it is there will be a
	# race condition between rename and open.

	# the file name used for this lockfile is $CLEANLOCK, concatenated
	# with the database filename (no full path)

	$name=~ /$SPLITFILENAME/o;
	
	local($lockfile)=$CLEANLOCK.$2;
	
	while (-f $lockfile) {
	    sleep 60;
	}
	
	
        if (!open($database, "+<$name")) {
           
           if (! -f $name) {
              
              # make a database file in case it doesn't exist yet
              
              # don't do a destructive open since we are not locked yet
       
              open(NEWDB, ">>".$name) || &fatalerror("Cannot create new database: ", $name);
              &lock(NEWDB);
       
              # another process might have build it between the open & lock...
              # so test if the file has still zero length!
              #
              # we could have done this with other flock options
              # but we don't want to use them for compatibility reasons
       
              if (-z $name) {
                 
                 #
                 # printright is required since addkey doesn\'t work
                 # correct when an offset==0;
                 
                 &printrights(NEWDB) if (-z $name);
                 &delormoveindices($name, "", 0);
                 &delormoveindices($name.$CLASSLESSEXT, "", 1);
              
              }
              
              close(NEWDB);
              
              return 0 if (!open($database, "+<$name"));
           
           }
           else {
              return 0;
           }
           
        }

	flock($database, $LOCK_EX);
	
    }
    else {
        
	return 0 if (!open($database, "<$name"));
        
    }
    
    local($oldhandle)=select($database); $|=1; select($oldhandle);
    
    if ($write) {
       dbmopen(%database, $name, 0644) || &fatalerror("Couldn\'t open dbm file($!): $name");  
    }
    else {
       dbmopen(%database, $name, undef) || return 0;
    }
    
    @database=(1, $name);
    
    # print STDERR "dbopen - $name db contents: ", join("*", values %database) , "\n";
    
    # print STDERR "dbopen - $name db contents: ", $database{"bl4-test"} , "\n";
    
    return 1;

}


# Now, for classless we have a seperate database. Due to a slight design
# error (err'hum) we have to open this seperately. It will keep track
# of things. Thing to achieve here is to *never* have two classless
# indexes open at the same time. This should be done differently but
# we have to get things things running. Usually you would call this
# for a lookup and an insert that requires classless thingies.

# So, once more: ONLY ONE OPEN AT THE SAME TIME!!!!

sub dbclopen {
    local(*entry, $write, $name) = @_;

    &fatalerror("Classless index: $name (write: $write) type: ",&entype(*entry), " ", $entry{"so"}, " already opened ($mspnxl[1]) !!!!") if ($mspnxl[0]==1);
    
    $name=&dbname(*entry) if ($name=~ /^\s*$/);
    $name.=$CLASSLESSEXT;

    if ($write) {
       dbmopen(%mspnxl, $name, 0644) ||  &fatalerror("Couldn\'t open classless index ($name) for writing: $!");
    }
    else {
       dbmopen(%mspnxl, $name, undef) || return 0;
    }
    
    @mspnxl=(1, $name);
    
    return 1;

}

1;
