      PROGRAM P112
C
C      PROGRAM 11.2 FORCED VIBRATION OF A RECTANGULAR SOLID IN
C      PLANE STRAIN USING 8-NODE QUADRILATERALS,
C      LUMPED OR CONSISTENT MASS,DIRECT INTEGRATION IN TIME USING
C      WILSON'S THETA METHOD
C
C      ALTER NEXT LINE TO CHANGE PROBLEM SIZE
C
      PARAMETER (IKV=1000,ILOADS=103,INF=85)
C
      REAL AA
      REAL BB
      REAL RHO
      REAL E
      REAL V
      REAL ALPHA
      REAL BETA
      REAL THETA
      REAL OMEGA
      REAL PI
      REAL PERIOD
      REAL DTIM
      REAL AREA
      REAL DET
      REAL QUOT
      REAL PROD
      REAL C1
      REAL C2
      REAL C3
      REAL C4
      REAL C5
      REAL C6
      REAL C7
      REAL C8
      REAL TIM
      REAL DEE(3,3),SAMP(3,2),COORD(8,2),FUN(8),JAC(2,2),JAC1(2,2),
     +     DER(2,8),DERIV(2,8),BEE(3,16),DBEE(3,16),BTDB(16,16),
     +     BT(16,3),KM(16,16),EMM(16,16),ECM(16,16),TN(16,16),NT(16,2),
     +     KV(IKV),MM(IKV),F1(IKV),LOADS(ILOADS),X0(ILOADS),
     +     D1X0(ILOADS),D2X0(ILOADS),X1(ILOADS),D1X1(ILOADS),
     +     D2X1(ILOADS)
      INTEGER NF(INF,2),G(16)
      DATA IJAC,IJAC1,IDER,IDERIV,NODOF,IT/6*2/
      DATA IH,ISAMP,IDEE,IBEE,IDBEE/5*3/
      DATA ICOORD,NOD/2*8/,IBTDB,IKM,IBT,IEMM,IECM,IDOF,ITN,INT/8*16/
C
C      INPUT AND INITIALISATION
C
      READ (5,FMT=*) NXE,NYE,N,IW,NN,NR,NGP,AA,BB,ITYPE,RHO,E,V,ALPHA,
     +  BETA,ISTEP,NPRI,THETA,OMEGA
      CALL READNF(NF,INF,NN,NODOF,NR)
      IR = N* (IW+1)
      PI = ACOS(-1.)
      PERIOD = 2.*PI/OMEGA
      DTIM = PERIOD/20.
      CALL NULVEC(KV,IR)
      CALL NULVEC(MM,IR)
      CALL NULL(DEE,IDEE,IH,IH)
      CALL FMDEPS(DEE,IDEE,E,V)
      CALL GAUSS(SAMP,ISAMP,NGP)
C
C      ELEMENT STIFFNESS AND MASS INTEGRATION AND ASSEMBLY
C
      DO 10 IP = 1,NXE
          DO 10 IQ = 1,NYE
              AREA = 0.
              CALL GEOM8Y(IP,IQ,NYE,AA,BB,COORD,ICOORD,G,NF,INF)
              CALL NULL(KM,IKM,IDOF,IDOF)
              CALL NULL(EMM,IEMM,IDOF,IDOF)
              DO 20 I = 1,NGP
                  DO 20 J = 1,NGP
                      CALL FMQUAD(DER,IDER,FUN,SAMP,ISAMP,I,J)
                      CALL MATMUL(DER,IDER,COORD,ICOORD,JAC,IJAC,IT,NOD,
     +                            IT)
                      CALL TWOBY2(JAC,IJAC,JAC1,IJAC1,DET)
                      CALL MATMUL(JAC1,IJAC1,DER,IDER,DERIV,IDERIV,IT,
     +                            IT,NOD)
                      CALL NULL(BEE,IBEE,IH,IDOF)
                      CALL FORMB(BEE,IBEE,DERIV,IDERIV,NOD)
                      CALL MATMUL(DEE,IDEE,BEE,IBEE,DBEE,IDBEE,IH,IH,
     +                            IDOF)
                      CALL MATRAN(BT,IBT,BEE,IBEE,IH,IDOF)
                      CALL MATMUL(BT,IBT,DBEE,IDBEE,BTDB,IBTDB,IDOF,IH,
     +                            IDOF)
                      QUOT = DET*SAMP(I,2)*SAMP(J,2)
                      AREA = AREA + QUOT
                      IF (ITYPE.NE.1) THEN
                          CALL ECMAT(ECM,IECM,TN,ITN,NT,INT,FUN,NOD,
     +                               NODOF)
                          PROD = QUOT*RHO
                          CALL MSMULT(ECM,IECM,PROD,IDOF,IDOF)
                          CALL MATADD(EMM,IEMM,ECM,IECM,IDOF,IDOF)
                      END IF

                      CALL MSMULT(BTDB,IBTDB,QUOT,IDOF,IDOF)
   20         CALL MATADD(KM,IKM,BTDB,IBTDB,IDOF,IDOF)
              IF (ITYPE.EQ.1) THEN
                  DO 30 I = 1,IDOF
   30             EMM(I,I) = AREA*RHO*.2
                  DO 31 I = 1,13,4
   31             EMM(I,I) = EMM(3,3)*.25
                  DO 32 I = 2,14,4
   32             EMM(I,I) = EMM(3,3)*.25
              END IF

              CALL FORMKV(KV,KM,IKM,G,N,IDOF)
   10 CALL FORMKV(MM,EMM,IEMM,G,N,IDOF)
C
C      REDUCTION OF LEFT HAND SIDE
C
      CALL NULVEC(X0,N)
      CALL NULVEC(D1X0,N)
      CALL NULVEC(D2X0,N)
      C1 = 6./ (THETA*DTIM)**2
      C2 = 6./ (THETA*DTIM)
      C3 = DTIM**2/6.
      C4 = 2.
      C5 = 3.*ALPHA/ (THETA*DTIM)
      C6 = 3.*BETA/ (THETA*DTIM)
      C7 = .5*ALPHA*THETA*DTIM
      C8 = .5*BETA*THETA*DTIM
      DO 40 I = 1,IR
   40 F1(I) = (C1+C5)*MM(I) + (1.+C6)*KV(I)
      CALL BANRED(F1,N,IW)
C
C      TIME STEPPING LOOP
C
      TIM = 0.
      DO 50 J = 1,ISTEP
          TIM = TIM + DTIM
          CALL NULVEC(LOADS,N)
          DO 60 I = 1,N
   60     X1(I) = (C1+C5)*X0(I) + (C2+2.*ALPHA)*D1X0(I) +
     +            (2.+C7)*D2X0(I)
          LOADS(N) = THETA*COS(OMEGA*TIM) +
     +               (1.-THETA)*COS(OMEGA* (TIM-DTIM))
          CALL LINMUL(MM,X1,D1X1,N,IW)
          CALL VECADD(D1X1,LOADS,D1X1,N)
          DO 70 I = 1,N
   70     LOADS(I) = C6*X0(I) + 2.*BETA*D1X0(I) + C8*D2X0(I)
          CALL LINMUL(KV,LOADS,X1,N,IW)
          CALL VECADD(X1,D1X1,X1,N)
          CALL BACSUB(F1,X1,N,IW)
          DO 80 I = 1,N
              D2X1(I) = (X1(I)-X0(I))*C1 - D1X0(I)*C2 - D2X0(I)*C4
              D2X1(I) = D2X0(I) + (D2X1(I)-D2X0(I))/THETA
              D1X1(I) = D1X0(I) + .5*DTIM* (D2X1(I)+D2X0(I))
   80     X1(I) = X0(I) + DTIM*D1X0(I) + 2.*C3*D2X0(I) + C3*D2X1(I)
          IF (J/NPRI*NPRI.EQ.J) WRITE (6,FMT=1000) TIM,COS(OMEGA*TIM),
     +        X1(N)
          CALL VECCOP(X1,X0,N)
          CALL VECCOP(D1X1,D1X0,N)
          CALL VECCOP(D2X1,D2X0,N)
   50 CONTINUE

 1000 FORMAT (5E12.4)

      STOP

      END
