SUBROUTINE MySolver(Model, Solver, dt, Transient)
  Use DefUtils
  IMPLICIT NONE
  TYPE(Solver_t) :: Solver
  TYPE(Model_t) :: Model
  REAL(KIND=dp) :: dt
  LOGICAL :: Transient

  ! Read constant matrix from Material-block
  !------------------------------------------
  REAL(KIND=dp), POINTER :: MyMatrix(:,:)
  LOGICAL :: Found
  TYPE(ValueList_t), POINTER :: Material
  Material => Model % Materials(1) % Values
  CALL GetConstRealArray(Material, MyMatrix, "MyMatrix", Found)
  IF(.NOT.Found) CALL Fatal("MySolver", "Unable to find MyMatrix")
  PRINT *, "Size of MyMatrix =", SIZE(MyMatrix,1), "x", SIZE(MyMatrix,2)
  PRINT *, "MyMatrix(1,:) =", MyMatrix(1,:)
  PRINT *, "MyMatrix(2,:) =", MyMatrix(2,:)

END SUBROUTINE MySolver
