/* gsum.h - macro */

#if defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK)

#ifndef MULTIP
#define MULTIP
#endif

static int FUNC(data, ndata, result)
     TYPE *data;
     int ndata;
     TYPE *result;
{
  if (ME > 0) { /* Nodes with # > 0  */
    pvm_initsend(INITHOW_node);
    PACK(data, ndata, 1);          /* Send my contribution */
    pvm_send(NODEID[0], MSG_SUM);

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(4,0,MSG_SUM,MULTIP sizeof(*data) * ndata);
      TRACEF(7,MSG_SUM);
    }
#endif

    pvm_recv(NODEID[0], MSG_SUM);
    UNPACK(result, ndata, 1);

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(8,0,MSG_SUM,MULTIP sizeof(*data) * ndata);
    }
#endif
  }
  else { /* Node == 0 */
    int i, j;
    TYPE *tmp = (TYPE *)malloc( MULTIP ndata * sizeof(*tmp) );

    if (result != data) {
      for (i=0; i<MULTIP ndata; i++) {
	result[i] = data[i];
      }
    }

    for (j=1; j<NUMNODES; j++) {

#ifdef PICL
      if (logfp) {
	TRACETIME();
	TRACEF(7,MSG_SUM);
      }
#endif
      
      pvm_recv(ANYBODY, MSG_SUM);
      UNPACK(tmp, ndata, 1);       /* Recv somebody's contribution */
      
#ifdef PICL
      if (logfp) {
	int source;
	recvinfo(NOCARE, &source, NULL, NULL);
	TRACETIME();
	TRACEF(8,source,MSG_SUM,MULTIP sizeof(*data) * ndata);
      }
#endif
      
      for (i=0; i<MULTIP ndata; i++) {
	result[i] += tmp[i];
      }
    }

    free(tmp);
      
    pvm_initsend(INITHOW_node);
    PACK(result, ndata, 1);
    pvm_mcast(&NODEID[1], NUMNODES-1, MSG_SUM);

#ifdef PICL
      if (logfp) {
	TRACETIME();
	for (i=1; i<NUMNODES; i++) 
	  TRACEF(4,i,MSG_SUM,MULTIP sizeof(*data) * ndata);
      }
#endif
  }

  return 0;
}


#undef MULTIP
#undef FUNC
#undef TYPE
#undef PACK
#undef UNPACK

#endif  /* defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK) */
