#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

#define FUNC     gb1prod
#define TYPE     char
#define PACK     pvm_pkbyte
#define UNPACK   pvm_upkbyte
#include "gprod.h"

#define FUNC     gi2prod
#define TYPE     short
#define PACK     pvm_pkshort
#define UNPACK   pvm_upkshort
#include "gprod.h"

#define FUNC     gi4prod
#define TYPE     int
#define PACK     pvm_pkint
#define UNPACK   pvm_upkint
#include "gprod.h"

#define FUNC     gr4prod
#define TYPE     float
#define PACK     pvm_pkfloat
#define UNPACK   pvm_upkfloat
#include "gprod.h"

#define FUNC     gr8prod
#define TYPE     double
#define PACK     pvm_pkdouble
#define UNPACK   pvm_upkdouble
#include "gprod.h"

#define MULTIP   2*
#define FUNC     gz8prod
#define TYPE     float
#define PACK     pvm_pkcplx
#define UNPACK   pvm_upkcplx
#include "gprod.h"

#define MULTIP   2*
#define FUNC     gz16prod
#define TYPE     double
#define PACK     pvm_pkdcplx
#define UNPACK   pvm_upkdcplx
#include "gprod.h"


int gprod(data, ndata, result)
     void *data; 
     int ndata; 
     void *result;
{
  int retcode = 0;

  if (ME != HOSTID) { /* Exclude the HOST */

#ifdef PICL
    if (logfp) {
      if (ME==0) tracemsg("gprod()");
      SETIDLETIME();
      TRACEF(20,-4,MSG_PROD,0);
    }
#endif /* PICL */

    switch (DATATYPE) {
    case BYTE1:
      retcode = gb1prod(data,ndata,result);
      break;
    case INTEGER2:
      retcode = gi2prod(data,ndata,result);
      break;
    case INTEGER4:
      retcode = gi4prod(data,ndata,result);
      break;
    case REAL4:
      retcode = gr4prod(data,ndata,result);
      break;
    case REAL8:
      retcode = gr8prod(data,ndata,result);
      break;
    case COMPLEX8:
      retcode = gz8prod(data,ndata,result);
      break;
    case COMPLEX16:
      retcode = gz16prod(data,ndata,result);
      break;
    default:
      fprintf(stderr,
	      "gprod(@%d): Not implemented with data type# %d\n",
	      ME,DATATYPE);
      killproc(ME);
      break;
    }

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(21,-4,MSG_PROD,0);
      UPDATEIDLETIME();
    }
#endif /* PICL */

  }

  return retcode;
}

