#include "easy.h"

/****************************************************************

Name:      dclock (originally: wtime)

Purpose:   Returns the seconds since 00:00 GMT, January 1, 1970
           (see gettimeofday(2))

Arguments: None

Returns:   The wall clock time in seconds as a double is returned. 

Notes:     This function uses two structures defined in the UNIX
           system call, gettimeofday(2). The structure, "timeval" 
           is defined in the include file <sys/time.h> as:

                 struct timeval {
                     long tv_sec;
                     long tv_usec;
                 }

           where timeval.tv_sec is the seconds and timeval.tv_usec
           is the microseconds.  
 
History:   Written by Tim Mattson, Dec 1, 1988
           Renamed wtime to dclock by Sami Saarinen, Nov 11, 1993
           mclock added, Nov ??, 1993
           reftime added to dclock, Dec 22, 1993

****************************************************************/

#include <stddef.h>
#include <sys/time.h> 
#define  USEC_TO_SEC   1.0e-6    /* to convert microsecs to secs */


double dclock()
{
  static struct timeval  time_data; /* seconds since 0 GMT */
  static double reftime = -1;
  double time_in_seconds;

  if (reftime == -1) { /* Is the first call ? */
    gettimeofday(&time_data,NULL);
    reftime =
      (double) time_data.tv_sec +
      (double) time_data.tv_usec * USEC_TO_SEC;
  }

  gettimeofday(&time_data,NULL);

  time_in_seconds  =
    (double) time_data.tv_sec +
    (double) time_data.tv_usec * USEC_TO_SEC -
      reftime;

   return time_in_seconds;
}


int mclock() /* Return time in milliseconds */
{
  return (int) (1000.0 * dclock());
}
