#include "easy.h"

int
FUNCTION(broadcast) ARGS(`msgtag, data, ndata')
int *msgtag;
void *data;
int *ndata;	
{
  int retcode;
  int olddatatype = FUNCALL(getdatatype)();
  int oldstride;

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(BYTE1);
    oldstride = FUNCALL(setstride)(1);
  }

  retcode = FUNCALL(broadcast)(*msgtag, data, *ndata);

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(STRING);
    FUNCALL(setstride)(oldstride);
  }

  return retcode;
}

int
FUNCTION(broadcast2d) 
ARGS(`msgtag, data, nrows, ncols, offset')
int *msgtag;
void *data;
int *nrows;
int *ncols;
int *offset;
{
  int retcode;
  int olddatatype = FUNCALL(getdatatype)();
  int oldstride;

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(BYTE1);
    oldstride = FUNCALL(setstride)(1);
  }

  retcode = FUNCALL(broadcast2d)(*msgtag, data, *nrows, *ncols, *offset);

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(STRING);
    FUNCALL(setstride)(oldstride);
  }

  return retcode;
}

