
      DOUBLE PRECISION FUNCTION SCPROD (U, V)
C     ---------------------------------------
      INTEGER VSIZE
      COMMON /VECLEN/ VSIZE
      DOUBLE PRECISION   U(VSIZE),  V(VSIZE)

C     -------------------------------------------------------------------
C     |  Returns the REAL part of the hermitian scalar product :        |
C     |                                                                 |
C     |                   scprod = (u+, v)                              |
C     |                                                                 |
C     |  where {u} and {v} are fermion vectors.                         |
C     -------------------------------------------------------------------
      INTEGER  I
      DOUBLE PRECISION   SUM

      SUM = 0.0D0
      DO 8  I = 1, VSIZE
        SUM = SUM + (U (I) * V (I))
   8  CONTINUE

C  @@@@  Communication Structure  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
C  @                                                                  @
C----- Accumulate global sum (across all nodes)

      CALL GLBSUM(SUM)
C  @                                                                  @
C  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

      SCPROD = SUM

      END

