
      SUBROUTINE RENORM ( X ) 
C     -----------------------
      DOUBLE PRECISION     X (6)
C     -------------------------------------------------------------
C     |   Scale the vector 'x' to unit length                     |
C     |  (assuming the original vector is not identically zero!)  |
C     -------------------------------------------------------------
      INTEGER  I
      DOUBLE PRECISION     L, LSQ


      LSQ = 0.0
      DO 10  I = 1, 6
        LSQ  = LSQ + (X(I) * X(I))
 10   CONTINUE

      L = SQRT (LSQ)

      DO 20  I = 1, 6
        X(I) = X(I) / L
 20   CONTINUE
      END
