
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

/***************************************************************************/
/* PROGRAM: palshow
/*
/* DESCRIPTION:
/*    Creates a small window which displays the last file loaded
/*    with the command 'paload'.
/*
/* USAGE:    palshow
/*
/* OPTIONS:
/* COMMENTS:
/*    This implementation is device dependent for a SGI IRIS 4D series
/*    workstation.  The window created displays lut locations
/*    512-767.
/*
/* EXAMPLE:
/* SEE ALSO:
/*    paload
/*
/***************************************************************************/

#include "gl.h"
#include "device.h"
#include "stdio.h"

#define WINDOW_STR "palshow"

#define XDIM 256
#define YDIM  70

#define NOPTS 1

void draw_map();

main()
{
	char *pname,*pstr;
	float pver;
	unsigned short dev_month,dev_year;
	int err_ret;
	char pstat;
	char *opt_array[NOPTS],*opt_desc[NOPTS];

	short dev,val;

	pname = "palshow";
	pver = 1.0;
	dev_month = 12;
	dev_year = 1988;
	pstat = 'P';
	pstr = "public domain software";

	opt_desc[0] = "palshow";
	opt_array[0] = opt_desc[0];

	err_ret = prog_title(pname,pver,dev_month,dev_year,pstat,pstr);

	prefsize(XDIM,YDIM);
	winopen(WINDOW_STR);
	wintitle(WINDOW_STR);

	cmode();
	onemap();
	singlebuffer();
	drawmode(NORMALDRAW);
	gconfig();

	draw_map();

	for(;;){
		dev = qread(&val);
		if (dev == REDRAW)
			draw_map();
	}

}

void draw_map()
{
	long i,ydim1;
	unsigned short i1;

	reshapeviewport();
	winpop();

	ydim1 = YDIM - 1;
	i=256;
	do{
		i--;
		i1=i|512; /* statement equivalent to i1=i+512 */
		color(i1);
		move2i(i,0);
		draw2i(i,ydim1);
	}while(i);
}
