/*****************************************************************************
* 
*			  NCSA HDF Vset beta 1.0
*				March , 1990
*
* NCSA HDF Vset beta 1.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************
*  Likkai Ng 31-MAR-90 NCSA
* 
* vg.h
* Part of HDF VSet interface
*
* defines symbols and structures used in all v*.c files    
*
* NOTES:
* This include file depends on the basic HDF *.h files dfi.h and df.h.
* An 'S' in the comment means that that data field is saved in the HDF file.
*
******************************************************************************/


#include "df.h"

#define PUBLIC		
#define PRIVATE	static


/* 
* interlacing supported by the vset. 
*/

#define FULL_INTERLACE	0
#define NO_INTERLACE		1

/* 
* some max lengths 
*
* Except for FIELDNAMELENMAX, change these as you please, they 
* affect memory only, not the file. 
*
* Note that VGDIRMAX must be as large as the total no of vgroups
* in a file that you expect to handle. This is because whenever
* a file is opened, pointers to ALL vgroups in it are set up in
* memory. 
* Same for VSDIRMAX.
*
*/

#define FIELDNAMELENMAX	16				/* fieldname   : 16 chars max */

#define VSFIELDMAX		20  			/* max no of fields per vdata */
#define VSNAMELENMAX		64				/* vdata name  : 64 chars max */	
#define VGNAMELENMAX		64				/* vgroup name : 64 chars max */	
#define VGDIRMAX			1024			/* max no of vgroups in memory */
#define VSDIRMAX			1024			/* max no of vdatas in memory */

/*
* definition of the 2 data elements of the vset.
*/

typedef struct vgroup_desc     	VGROUP;
typedef struct vdata_desc			VDATA;


/*
* -----------------------------------------------------------------
* structures that are part of the VDATA structure
* -----------------------------------------------------------------
*/

typedef struct symdef_struct 
{
	char* name;						/* symbol name */
	int	type;						/* whether int, char, float etc */
	int	isize;					/* field size as stored in vdata */
	int	order;					/* order of field */

	} SYMDEF;

typedef struct write_struct	
{
	int32	n;							/* S actual # fields in element */
	int	ivsize;					/* S size of element as stored in vdata */
 	char 	name[VSFIELDMAX][FIELDNAMELENMAX+1];
										/* S name of each field */
	int	len[VSFIELDMAX]; 		/* S length of each fieldname */
	int	type[VSFIELDMAX];		/* S field type */
  	int	off[VSFIELDMAX];		/* S field offset in element in vdata */
  	int 	isize[VSFIELDMAX];	/* S internal (HDF) size [incl order] */
  	int	order[VSFIELDMAX];	/* S order of field */
  	int	esize[VSFIELDMAX];	/*  external (local machine) size [incl order] */
	int	(*toIEEEfn  [VSFIELDMAX] )();
	int	(*fromIEEEfn[VSFIELDMAX] )();

  	}		 VWRITELIST;

typedef struct read_struct
{
	int	n; 						/* # fields to read */
	int	item[VSFIELDMAX]; 	/* index into vftable_struct */

	} VREADLIST;

/* 
*  ----------------------------------------------- 
        V G R O U P     definition     
*  ----------------------------------------------- 
*/

#define MAXNVELT  36				/* max no of ventities in a vgroup */
										/* A "ventity" is a vgroup or vdata */
struct vgroup_desc
{ 
	int    otag, oref;			/* tag-ref of this vgroup */
  	DF		 *f;	 	     			/* HDF file ptr */
	int 	 nvelt; 					/* S no of ventities */
	int	 tag[MAXNVELT];		/* S tag of ventities */
	int	 ref[MAXNVELT];		/* S ref of ventities */
 	char	 vgname[VGNAMELENMAX+1];/* S name of this vgroup */
	VDATA* velt[MAXNVELT];	 	/* pts to a ventity if opened; or else NULL */

	};									/* VGROUP */

/*
*  ----------------------------------------------- 
*         V D A T A      definition   
*  ----------------------------------------------- 
*/

#define USYMMAX 36				/* max user-defined symbols allowed */

struct vdata_desc{ 
  	int	otag, oref; 			/* tag,ref of this vdata */
  	DF		*f;	 	     			/* HDF file ptr */
  	int	access;					/* 'r' or 'w' */
 	char	vsname[VSNAMELENMAX+1];/* S name of this vdata */
  	int	interlace;				/* S  interlace as in file */
  	int	nvertices;				/* S  #vertices in this vdata */
	int	vpos;    				/* cur position (in terms of elements) */
	VWRITELIST	wlist;
  	VREADLIST	rlist;
	int  			nusym;
	SYMDEF 		usym[USYMMAX];
  	};  								/* VDATA */ 


/* --------------  H D F    V S E T   tags  ---------------------------- */

#define VGDESCTAG  	61820		/* tag for a vgroup d*/ 
#define VSDESCTAG 	61821		/* tag for a vdata descriptor */
#define VSDATATAG 	61822		/* tag for actual raw data of a vdata */ 

/*
* Actual sizes of data types stored in HDF file, and are IEEE-defined. 
*/

#define IEEE_UNTYPEDSIZE   0
#define IEEE_CHARSIZE      1
#define IEEE_INT16SIZE     2
#define IEEE_FLOATSIZE     4

/*
* types used in defining a new field via a call to VSfdefine
*/

#define LOCAL_NOTYPE			0
#define LOCAL_CHARTYPE  	1
#define LOCAL_INTTYPE 	 	2
#define LOCAL_FLOATTYPE		3

/*
* actual LOCAL MACHINE sizes of the above types
*/

#define LOCAL_UNTYPEDSIZE  0
#define LOCAL_CHARSIZE  	sizeof(unsigned char)
#define LOCAL_INTSIZE  		sizeof(int)
#define LOCAL_FLOATSIZE 	sizeof(float)

/* ------------------------------------------------------------------ */
/* 2 GLOBAL VARIABLES (int vjv and char sj[]) provide a simple
* debugging scheme. Debugging is turned on and off via calls to 
* setjj and setnojj. These globals and functions are found in vgp.c.
* 
* If the debug feature is no longer needed, delete all these, and
* all statements that refer to xzj,sjs, and vjv from the source
*
*/

extern int 		vjv; 			/* debugger switch */
extern char 	sjs[]; 		/* contains the debug/error message */

/* zj is just prints out the contents of the text buffer sjs. */
/* sjs contains debugging messages when debug is on */
/* for the Mac, replace define zj to be any print msg routine */

#ifdef MAC
#define zj
#else
#define zj 		fprintf(stderr,"%s",sjs) 
#endif
/* ------------------------------------------------------------------ */
