/**************************************************
 * hbhdf.c: interface to hdf for X HDF Browser
 **************************************************/
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: hbhdf.c,v 1.7 93/11/05 15:36:42 gbourhis Exp $";
#endif
/* $Log:	hbhdf.c,v $
 * Revision 1.7  93/11/05  15:36:42  gbourhis
 * change VGroup hanlde from pointer to int32.
 * some changes in listDesc() (better alignement of items).
 * 
 */

#include "hbox.h"

#define CHECK(status) {if(status == FAIL) {printf("Died at line %d in hbhdf.c\n", __LINE__); HEprint(stderr, 0);}}

extern XmFontList hbfontList;

/*****************************************************
 * getDesc: get VSet descriptors and other descriptors
 *****************************************************/

int getDesc(c)
     ctxt_ptr c;
{
  int32	     vg;
  int        tag, ref, list_count;
  int        list_type, vgid;
  char     * label;
  register   int i;
  int32      fid, sdsid, nt, dims[100], nattr, ndsets, rank;
  char       name[512];

#if DEBUG
  printf("in getDesc(): hbhdf.c\n");
#endif

  if (!c->hb_file) {
    noFile();
    return HB_OK;
  }
  
  list_type = c->list_type;       /* what type of stuff are we listing */
  list_count = 0;

  /*
   * Calculate the number of items to display
   */

  for (i = 0; i < c->hb_numDesc; i++) {
      
      switch(c->hb_desc[i].tag) {
          
      case DFTAG_RIG   :
          if(list_type & RIG) 
              list_count++;
          break;
      case DFTAG_NDG   :
      case DFTAG_SDG   :
          /* will do these later */
          break;
      case DFTAG_LUT  :
          if(list_type & PAL)
              list_count++;
          break;
      case DFTAG_NULL  :
          break;
      case VGDESCTAG   :
          if(list_type & VSET)
              list_count++;
          break;
      default:
          if(list_type & OTHER)
              list_count++;
          break;
      }
  }
  
  if(list_type & SDS) {
      fid = SDstart(c->hb_file, DFACC_RDONLY);
      if(fid != FAIL)
          if(SDfileinfo(fid, &ndsets, &nattr) != FAIL)
              list_count += ndsets;
  }

  clearLists(c, 0, list_count, FALSE);
  if(!list_count)
      return HB_OK;
  c->num_desc = 0;

  /*
   *
   * Print the items into the list as we come across them
   *
   */

  if(list_type & SDS) {
      for(i = 0; i < ndsets; i++) {
          sdsid = SDselect(fid, i);
          if(sdsid == FAIL) continue;

          SDgetinfo(sdsid, name, &rank, dims, &nt, &nattr);
          listDesc(c, DFTAG_NDG, i, 0, name);
          SDendaccess(sdsid);
      }
  }

  if(list_type & VSET) {
      vgid = -1;
      while((vgid = Vgetid(c->f, vgid)) != -1) {
          vg =  Vattach(c->f, vgid, "r");
          Vgetname(vg, name);
          listDesc(c, DFTAG_VG, VQueryref(vg), 0, name);
          Vdetach(vg);
      }
  }
  
  for (i = 0; i < c->hb_numDesc; i++) {
      tag = c->hb_desc[i].tag;
      ref = c->hb_desc[i].ref;
      
      switch(tag) {
          
      case DFTAG_RIG   :
          if(list_type & RIG) { 
              label = getLabel(c, tag, ref);
              listDesc(c, tag, ref, 0, label);
              if(label) free(label);
          }
          break;
      case DFTAG_NDG   :
      case DFTAG_SDG   :
          /*
            
            We've done these already
            
            if(list_type & SDS) {
            label = getLabel(c, tag, ref);
            listDesc(c, tag, ref, 0, label);
            if(label) free(label);
            }
            */
          
          break;
      case DFTAG_LUT  :
          if(list_type & PAL)
              listDesc(c, tag, ref, 0, NULL);
          break;
      case DFTAG_NULL  :
          break;
      case DFTAG_VG    :
          /* already done these */
          break;
      default:
          if(list_type & OTHER)
              listDesc(c, tag, ref, 0, NULL);
          break;
      }
  }
  
  if(list_type & SDS)
      SDend(fid);
  
  return HB_OK;
  
} /* getDesc */


/*********************************************
 * getLabel: return the label for the supplied
 *           tag/ref.  Return NULL if none
 ********************************************/
char *getLabel(c, tag, ref) 
     ctxt_ptr c;
     int tag; 
     int ref;
{
  int ret, len;
  char *name;
  
  if(!tag) return NULL;

  len = DFANgetlablen(c->hb_file, tag, ref);
  if(len < 1) return NULL;

  name = (char *) malloc(len + 1);
  
  ret = DFANgetlabel(c->hb_file, tag, ref, name, len + 1);
  if(ret == FAIL) return NULL;

  name[len + 1] = '\0';

  return name;

} /* getLabel */

/****************************************
 * getGrpDesc: get group descriptor
 *
 * Inputs:  
 *          tag: tag number of desc
 *          ref: reference number of desc
 * Returns: error status
 ****************************************/
int getGrpDesc(c, tag, ref)
     ctxt_ptr  c;
     int  tag;
     int  ref;
{
  int gd, d;  /* group desc */

  for (d = 0; d < c->hb_numDesc; d++)
    if ((c->hb_desc[d].tag == tag) && (c->hb_desc[d].ref == ref))
      for (gd = 0; gd < c->hb_numGrp; gd++)
	if (c->hb_grp[gd].desc == d)
	  return gd;
#if DEBUG
  printf("getGrpDesc: can't find grp number of selected tag and ref");
#endif

  return HB_FAIL;

} /* getGrpDesc */


/****************************************
 * initFile: prepare hdf file for reading
 ****************************************/
int initFile(c, file)
     ctxt_ptr c;
     char     *file;
{

  if (c->hb_file) free(c->hb_file);
  c->hb_file = copyStr(file);

  if (updateDesc(c) == FAIL) {
    printf( "initFile: updateDesc: failed \n");
    return HB_FAIL;
  }

  return HB_OK;
} /* initFile */

/****************************************
 * listAnnotation: list annotation of 
 *                 selected descriptor, if
 *                 it exists
 ****************************************/
int listAnnotation(c, descTag, descRef, index)
     ctxt_ptr c;
     int descTag;    /* tag of currently selected descriptor */
     int descRef;    /* ref of currently selected descriptor */
     int index;  /* index of list widget where annotation descriptor will be listed*/
{
  int len, ref;

#if DEBUG
  printf("in listAnnotation\n");
#endif

  len = DFANgetdesclen(c->hb_file, descTag, descRef);

  if (len > 0) {
    ref = DFANlastref();
    listDesc(c, DFTAG_DIA, ref, index, NULL);
  }

  len = DFANgetlablen(c->hb_file, descTag, descRef);

  if (len > 0) {
    ref = DFANlastref();
    listDesc(c, DFTAG_DIL, ref, index, NULL);
  }

} /* listAnnotation */


/****************************************
 * listDesc: list descriptor tag, ref, and label
 ****************************************/
void listDesc(c, tag, ref, lnum, label_string)
     ctxt_ptr c;
     int      tag;
     int      ref;
     int      lnum;
     char     *label_string;
{
  XmString listString;
  char     s[128];
  XmString tmpString;
  XmString blankString;
  XmString oldString;
  int length;
  int numSpacesNeeded;
  register int x;
  char blanks[512];

  if(tag != DFTAG_NULL)  {
    Dimension tmplength, charlength;
    tmpString = XmStringCreateSimple(getName(tag));
    blankString = XmStringCreateSimple(" ");
    oldString = tmpString;
    tmpString = XmStringConcat(tmpString,blankString);
    XmStringFree(oldString);

    charlength = XmStringWidth(hbfontList,blankString);
    tmplength = XmStringWidth(hbfontList,tmpString);
    numSpacesNeeded = (TAG_NAME_WIDTH -  (int) tmplength)
				/ (int)charlength ;
    if (numSpacesNeeded >= 0 &&
	numSpacesNeeded * (int)charlength < (TAG_NAME_WIDTH - (int)tmplength))
      numSpacesNeeded++;

    if (numSpacesNeeded > 0) {
        for(x=0; x < numSpacesNeeded; x++) {
            blanks[x]=' ';
        }
        blanks[x] = '\0';
        XmStringFree(blankString);
        blankString = XmStringCreateSimple(blanks);
        tmpString = XmStringConcat(tmpString,blankString);
    }
    
    if(lnum == 0) {
      if((label_string) && strlen(label_string)) {
    	sprintf(s,"%-5d %s",ref,label_string);
      	} 
      else {
    	sprintf(s,"%-5d (No label)",ref);
        }
      }

    listString = XmStringCreateSimple(s);
    oldString = listString;
    listString = XmStringConcat(tmpString,listString);
    XmStringFree(oldString);
    XmListAddItem(c->list[lnum], listString, 0);
    XmStringFree(tmpString);
    XmStringFree(blankString);
    XmStringFree(listString);
    }


  /* index tag# and ref# of each descriptor */
  c->index[lnum][c->num_desc].tag = tag;
  c->index[lnum][c->num_desc].ref = ref;
  c->num_list[lnum]++;
  c->num_desc++;
  
} /* listDesc */


/****************************************
 * listGrpDesc: list contents of groups,
 *              excluding Vgroups, including
 *      	annotations
 ****************************************/
void listGrpDesc(c, i, index, clear_all)
     ctxt_ptr c;
     int i;           /* i: group desc */
     int index;
     int clear_all;
{
  int desc, tag, ref;
  int len;                                 /* length of desc annotation */
  int j;
  int num_items = 0;                /* number of items to add */

#if DEBUG
  printf("in listGrpDesc \n");
#endif

  c->num_desc = 0;
  num_items = 0;

  /*
   * Include item position for any annotations the descriptor has
   */

  desc = c->hb_grp[i].desc;
  num_items = c->hb_grp[i].size;

  len = DFANgetdesclen(c->hb_file, c->hb_desc[desc].tag, c->hb_desc[desc].ref);
  if (len > 0)
    num_items++;                       /* update annotation count */
    
  len = DFANgetlablen(c->hb_file, c->hb_desc[desc].tag, c->hb_desc[desc].ref);
  if (len > 0)
    num_items++;                       /* update annotation count */
    
  clearLists(c, index, num_items, clear_all);

  /*
   * Add the annotation to the list
   */
  if(num_items != c->hb_grp[i].size) 
    listAnnotation(c, c->hb_desc[desc].tag, c->hb_desc[desc].ref, index);

  /*
   * Unmanage the list if we're adding boatloads of stuff
   */
  if(num_items > 100) {
    XtUnmanageChild(c->list[index]);
    fprintf(stderr, "Taking the list off-line to process %d entries\n", num_items);
  }

  /* 
   *  add each item to the list 
   */
  for (j = 0; j < c->hb_grp[i].size; j++) {

    tag = c->hb_grp[i].ddList[j].tag;
    ref = c->hb_grp[i].ddList[j].ref;

    listDesc(c, tag, ref, index, NULL);

  }

  /*
  ** Remanage the list
  */
  if(num_items > 100) {
    XtManageChild(c->list[index]);
    fprintf(stderr, "\n");
  }
  
#if DEBUG
  printf("listGrpDesc: done\n");
#endif
} /* listGrpDesc */


/****************************************
 * Empty the given list for writing
 ****************************************/
void clearLists(c, list, size, clear_all)
     ctxt_ptr c;
     int list;
     int size;
     int clear_all;
{
  XmString label;
  int n, i;
  Arg wargs[10];
  
#if DEBUG
  printf("Entered clearList list (%d), size (%d) \n", list, size);
#endif

  XmListDeselectAllItems(c->list[list]);
  c->selection[list] = FALSE;
  XmListDeleteAllItems(c->list[list]);
  c->name[list][0] = '\0';
  c->class[list][0] = '\0';

  n = 0;
  if(!size) {
    XtSetArg(wargs[n], XmNvisibleItemCount, 1); n++;
    XtSetValues(c->list[list], wargs, n);
    label = XmStringCreate("<No Elements>", XmSTRING_DEFAULT_CHARSET);
    XmListAddItem(c->list[list], label, 0);
  } else {
    XtSetArg(wargs[n], XmNvisibleItemCount, size); n++;
    XtSetValues(c->list[list], wargs, n);
  }
  n = 0;
  XtSetArg(wargs[n], XmNtopItemPosition, 1); n++;
  XtSetValues(c->list[list], wargs, n);

  if(size > c->sizes[list]) {
    if(c->index[list])
      free(c->index[list]);
    c->index[list] = (tag_ref_ptr) malloc(size * sizeof(tag_ref));
    c->sizes[list] = size;
  }

  if(clear_all) {
    for(i = list + 1; i < NUM_LIST; i++) {
      XmListDeleteAllItems(c->list[i]);
      c->selection[i] = FALSE;
      c->name[i][0] = '\0';
      c->class[i][0] = '\0';
    }
  }

} /* clearLists */


/******************************************************
 * updateDesc: get all descriptors in hdf file 
 * Returns:  error status
 * NOTE: I make no claim as to what this is doing,
 *       or whether there is an easier way of
 *       doing it.  Fixing this condition requires
 *       a significant rewrite.  cjh 3-Mar-92
 ******************************************************/
int updateDesc(c)
     ctxt_ptr c;
{
    register int i, j, status;
    int32 aid;
    int32 fid;

    c->hb_numDesc = c->hb_numGrp = 0;
    
    if((c->f = Hopen(c->hb_file, DFACC_READ, 0)) == FAIL) {
        fid = SDstart(c->hb_file, DFACC_RDONLY);
        if(fid == FAIL) {
            printf("failed opening\n");
            HEprint(stdout, 0);
            return HB_FAIL;
        }
        SDend(fid);
        return HB_OK;
    }    
    
    /* init the Vset stuff */
    Vstart(c->f);

    aid = Hstartread(c->f, DFTAG_WILDCARD, DFREF_WILDCARD);
    if(aid == FAIL) {
        HEprint(stderr, 0);
        return FAIL;
    }
    
    if(!c->hb_desc || !c->hb_grp) {
        intn sz;
        sz = Hnumber(c->f, DFTAG_WILDCARD);
        if(sz == FAIL) return FAIL;
        
        sz *= 2;   /* just to be safe */
        
        c->hb_desc = (DFdesc   *) HDgetspace(sz * sizeof(DFdesc));
        c->hb_grp  = (HB_GROUP *) HDgetspace(sz * sizeof(DFdesc));
        
        if(!c->hb_desc || !c->hb_grp) return FAIL;
        
    }
    
    status = SUCCEED;
    for(i = 0; status != FAIL; i++) {
        Hinquire(aid, NULL, &c->hb_desc[i].tag, &c->hb_desc[i].ref, &c->hb_desc[i].length,
                 &c->hb_desc[i].offset, NULL, (int16 *) NULL, (int16 *) NULL);
        status = Hnextread(aid, DFTAG_WILDCARD, DFREF_WILDCARD, DF_CURRENT);
    }
    c->hb_numDesc = i;
    
#if DEBUG
    printf("updateDesc: %d is hb_numDesc\n", c->hb_numDesc);
    for(i = 0; i < c->hb_numDesc; i++) 
        printf(" Size of %d == %d  (tag = %d) \n", i, c->hb_desc[i].length, c->hb_desc[i].tag);
#endif  
    
    /* get information about the groups */
    c->hb_numGrp = 0;
    
    if(Hendaccess(aid) == FAIL) {
        HEprint(stderr, 0);
        return FAIL;
    }

#if DEBUG
    printf("updateDesc: done \n");
#endif
    
    return HB_OK;
}

/* =====================================================
 *  getName(tag) : map a tag to its corresponding name
 * BUG: There is a space hole when we have unknown tags
 * =====================================================
 */

char *getName(tag)
     int tag;
{
  char s[80];
  char *name;

  name = HDgettagname((uint16) tag);

  if(!name) {
    sprintf(s, "Unknown Tag (%d)", tag);
    name = copyStr(s);
  }

  return name;

}
