(*^

::[paletteColors = 128; 
	fontset = title, "Geneva", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Geneva", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Geneva", 14, L2, center, bold, nohscroll;
	fontset = section, "Geneva", 14, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Geneva", 12, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Geneva", 10, L2, bold, nohscroll, whiteBox;
	fontset = text, "Geneva", 12, L2, nohscroll;
	fontset = smalltext, "Geneva", 10, L2, nohscroll;
	fontset = input, "Courier", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R65535, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Geneva", 10, L2, italic, B65535, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Geneva", 10, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "New York", 12, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Atoms
:[font = text; inactive; ]
This notebook comes from subsection 6.5.4
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

;[s]
3:0,0;67,1;93,0;470,-1;
2:2,14,10,Geneva,0,10,0,0,0;1,14,10,Geneva,2,10,0,0,0;
:[font = section; inactive; startGroup; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
Converting an Expression into a List of Characters
:[font = text; inactive; ]
page 158
:[font = input; ]
Explode[ Explode ]
:[font = input; ]
InputForm[ % ]
:[font = input; ]
Intern[ Explode[ symbol ] ]
:[font = input; endGroup; endGroup; ]
Explode[ Explode[ Explode[ ab ] ] ] // InputForm
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
Explode::usage = "Explode[expr] turns an expression into
	a list of characters that make up its name."
(*
:[font = input; initialization; ]
*)
Intern::usage = "Intern[charlist] turns a list of characters into an expression."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
Explode[atom_] := Characters[ ToString[InputForm[atom]] ]
(*
:[font = input; initialization; ]
*)
Intern[l:{_String..}] := ToExpression[ StringJoin @@ l ]
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; ]
*)
Protect[Explode, Intern]
(*
:[font = input; initialization; endGroup; ]
*)
Null
(*
^*)