
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)session.c	1.7	(NCSA)	8/12/87";
#endif lint

/*
** Session Menu
*/

#include <sys/types.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <sunwindow/defaults.h>
#include <sunwindow/notify.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/file.h>

#include "machdep.h"
#include "session.h"

/*
** build the menu
*/

Menu sessmenu;
init_session_menu()
{

	extern struct Pixfont *zzbold;
	caddr_t open_con();
	caddr_t close_con();
	caddr_t capture();
	caddr_t endcapture();
	Menu_item capgen();
	Menu_item capendgen();

	sessmenu = menu_create(MENU_FONT,zzbold,
						   MENU_ITEM,
						   MENU_STRING,"Open New Connection...",		/* 1 */
						   MENU_ACTION_PROC,open_con,
						   MENU_INACTIVE,FALSE,0,
						   MENU_ITEM,
						   MENU_STRING,"Close Connection...",		/* 2 */
						   MENU_ACTION_PROC,close_con,
						   MENU_INACTIVE,TRUE,0,
						   MENU_ITEM,
						   MENU_STRING,"",
						   MENU_INACTIVE,TRUE,0,				/* 3 */
						   MENU_ITEM,
						   MENU_STRING,"Capture Session to File...",
						   MENU_GEN_PROC,capgen,
						   MENU_ACTION_PROC,capture,
						   MENU_INACTIVE,FALSE,0,			/* 4 */
						   MENU_ITEM,
						   MENU_STRING,"End Capture and Close File...",
						   MENU_ACTION_PROC,endcapture,
						   MENU_GEN_PROC,capendgen,
						   MENU_INACTIVE,FALSE,0,			/* 5 */
						   0);
}

/*
** mark menu as inactive
*/

invalidate_sess_menu()
{
	menu_set(menu_get(sessmenu,MENU_NTH_ITEM,1),MENU_INACTIVE,FALSE,0);
	menu_set(menu_get(sessmenu,MENU_NTH_ITEM,2),MENU_INACTIVE,TRUE,0);
}

/*
** mark menu as active
*/

validate_sess_menu()
{

	int i;

	menu_set(menu_get(sessmenu,MENU_NTH_ITEM,1),MENU_INACTIVE,TRUE,0);
	menu_set(menu_get(sessmenu,MENU_NTH_ITEM,2),MENU_INACTIVE,FALSE,0);
}

/*
** figure out selection from this menu
*/

Notify_value sessionhandler(item, event)
Panel_item item;
Event *event;
{
	extern Panel menubar;

	/*
	** only process menu on right button down
	*/

	switch (event_id(event)) {

		case MS_RIGHT:
			if (event_is_up(event))
				return;
			menu_show(sessmenu,menubar,event,0);
			break;

		default:
			kbdhandler(Session.s_canvas, event);
			return;
	}

}

/*
** action proc for #1, open new connection
*/

char hostname[256];

caddr_t open_con(m, mi)
Menu m;
Menu_item mi;
{

	int stat;
	int dialog();
	extern char labelname[], *prog_name;
	extern Frame base_frame;
	extern Icon fr_icon;
	char hname[10];

	stat = dialog(hostname,"Machine Name/Address:", 50,255, 
		defaults_get_string("/Teltool/Default_Host","",0), FALSE);
	if (strlen(hostname) == 0)
		return;
	if (stat == FALSE)
		return;

	stat = get_connect(hostname);
	if (stat == 0)
		return;

	strcpy(labelname, prog_name);
	strcat(labelname, hostname);
	strncpy(hname, hostname, 9);
	hname[9] = '\0';
	icon_set(fr_icon, ICON_LABEL, hname, 0);
	window_set(base_frame, FRAME_LABEL, labelname, FRAME_ICON, fr_icon, 0);
	validate_menus();
}

/*
** action proc for item #2, close connection
*/

caddr_t close_con(m, mi)
Menu m;
Menu_item mi;
{
	if (!Session.s_valid)
		return;

	if(confirm("Close Connection: Are you sure?",FALSE))	
		closecon();
}

/*
** action proc for item #3, open capture file
*/

caddr_t capture(m, mi)
Menu m;
Menu_item mi;
{
	extern int captureflag;
	extern FILE *capf;
	extern char capname[];
	int stat;

	stat = dialog(capname,"Capture File Name:", 70,255, DEFCAPNAME,FALSE);

	if (strlen(capname) == 0)
		return;

	if (stat == 0)
		return;

	if (*capname != '|') {
		capf = fopen(capname, "w");
		if (capf == NULL) {
			syserr("open");
			return;
		}
		captureflag = 1;
	}
	else {
		capf = popen(capname + 1, "w");
		if (capf == NULL) {
			syserr("open");
			return;
		}
		captureflag = 2;
	}

	return;
}

/*
** action proc for item #4, close capture file
*/

caddr_t endcapture(m, mi)
Menu m;
Menu_item mi;
{
	extern int captureflag;
	extern FILE *capf;
	int cstat;

	if (confirm("Close Capture File.  Are you sure?",FALSE)) {
		if (captureflag == 1)
			cstat = fclose(capf);
		else 
			cstat = pclose(capf);

		if (cstat == EOF)
			syserr("close");
		captureflag = 0;
		return;
	}
}

/*
** procedure to change messages 
*/

Menu_item capgen(mi, op)
Menu_item mi;
Menu_generate op;
{
	extern int captureflag;

	switch (op) {
		case MENU_DISPLAY:
			if (captureflag)
				menu_set(mi,MENU_INACTIVE,TRUE,0);
			else
				menu_set(mi,MENU_INACTIVE,FALSE,0);
			
			break;
		
		case MENU_DISPLAY_DONE:
		case MENU_NOTIFY:
		case MENU_NOTIFY_DONE:
		break;
	}
	return mi;
}

/*
** procedure to change messages 
*/

Menu_item capendgen(mi, op)
Menu_item mi;
Menu_generate op;
{
	extern int captureflag;

	switch (op) {
		case MENU_DISPLAY:
			if (!captureflag)
				menu_set(mi,MENU_INACTIVE,TRUE,0);
			else
				menu_set(mi,MENU_INACTIVE,FALSE,0);
			
			break;
		
		case MENU_DISPLAY_DONE:
		case MENU_NOTIFY:
		case MENU_NOTIFY_DONE:
		break;
	}
	return mi;
}

/*
** handle capture
*/

docap(buf, len)
char *buf;
int len;
{

	extern FILE *capf;
	extern int captureflag;

	if (captureflag > 0)
		if (fwrite(buf, len, 1, capf) < 0) {
			syserr("Capture write error: Capture turned off");
			if (captureflag == 1)
				fclose(capf);
			else
				pclose(capf);
			captureflag = 0;
		}
}
