/*
 *		@(#)vsdata.h	1.14	(NCSA)	2/13/88
 *
 *      Virtual Screen Kernel Data/Structure Definitions
 *                          (vsdata.h)
 *  
 *      c1986, National Center for Supercomputing Applications
 *      by Gaige B. Paulsen
 *
 *    This file contains the control and interface calls for the NCSA
 *  Virtual Screen Kernel.
 *
 *      Version Date    Notes
 *      ------- ------  ---------------------------------------------------
 *      0.01    861102  Initial coding -GBP
 *
 */

#define MAXWID 132      /* The absolute maximum number of chars/line */

struct VSline {
    struct VSline   *next,          /* Pointer to next line */
                    *prev;          /* Pointer to previous line */
    char            *text;  /* Text for the line */
    };

typedef struct VSline VSline;

struct VSscrn {
    VSline
         *scrntop,          /* top of the current screen */
         *buftop,           /* top of the current buffer */
         *vistop,			/* top of the visible area of screen */
         *attrst[24],       /* pointer to each of the 24 attribute lines    */
         *linest[24];       /* pointer to each of the 24 real screen lines  */
    int  maxlines,          /* maximum number of lines to save off top      */
         numlines,          /* number of lines currently saved off top      */
         allwidth,          /* real maximum width for this window           */
         maxwidth,          /* current maximum width for this window        */
         savelines,         /* save lines off top? 0=no                     */
         attrib,            /* current attibute                             */
         x,y,               /* current cursor positon                       */
         Px,Py,Pattrib,     /* saved cursor position and attribute          */
         VSIDC,             /* Insert/delete character mode 0=draw line     */
         DECAWM,            /* Auto Wrap Mode 0=off */
         DECCKM,            /* Cursor Key Mode      */
         DECPAM,            /* keyPad Application Mode*/
		 G0,G1,				/* Character set identifiers */
		 charset,			/* Character set mode */
         IRM,               /* Insert/Replace Mode  */
         escflg,            /* Current Escape level */
         top, bottom,       /* Vertical bounds of the screen */
         Rtop,Rbottom,		/* Vertical bounds of Region */
         Rleft,Rright,		/* Horizontal bounds of Region */
         parmptr;           /* pointer to current parm */
    int  parms[6];          /* Ansi Parameters */
    char *tabs;             /* pointer to array for tab settings */
    };

typedef struct VSscrn VSscrn;

struct VSscrndata {
    VSscrn *loc;            /* Location of the Screen record for this scrn */
    int     stat;           /* status of this screen (0=Uninitialized,     */
                            /*                        1=In Use             */
                            /*                        2=Inited, but not IU */
    };

typedef struct VSscrndata VSscrndata;

#ifdef VSMASTER
VSscrn  *VSIw;
int      VSIwn;
#else
extern VSscrn   *VSIw;
extern int       VSIwn;
#endif

