
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)rghpio.c	1.3	(NCSA)	8/12/87";
#endif lint

#include <stdio.h>

/*
** routines to support the HP-GL device
*/

static FILE *hpout;
static int	oflag = -1;

/*
** open the HP-GL device
*/

open_hp()
{
	extern char hpfname[];
	char		*hpfile = hpfname;
	int			write_hp();

	if (*hpfile == '|') {
		hpout = popen(++hpfile, "w");
		oflag = 1;
	}
	else {
		hpout = fopen(hpfile,"w");
		oflag = 0;
	}

	if (hpout == NULL)
		return -1;

	RGHPoutfunc(write_hp);
}

/*
** close the HP-GL device
*/

close_hp()
{

	if (oflag)
		pclose(hpout);
	else
		fclose(hpout);
	
	oflag = -1;
}

/*
** write on the HP-GL device
*/

write_hp(s)
char *s;
{
	while (*s != '\0')
		fputc(*s++, hpout);
}
