/************************************************************ 
*
* Example program: Illustrates storing slices in a file
*
* Input file:  none
* Output file: named by user on command line
*
************************************************************ */

#include <stdio.h>
#include "df.h"
#define ROWS 10
#define COLS 12 
#define TRUE   1
#define FALSE  0

char *malloc();

main(argc,argv)
int argc;
char *argv[];
{
    int i, j, count, ret;
	int dimsizes[2], windims[2];
	float data[ROWS][COLS], indata[ROWS][COLS];
	
    if (argc != 2) {
        printf("Usage: %s outfile\n", argv[0]);
        exit(1);
    }

    printf("\nWrites out 10x12 data set in slices, then reads it back in.\n");

    count = 0;
    for (i=0; i<ROWS; i++)
       for (j=0; j<COLS; j++) 
           data[i][j] = (float) count++;
 
    printf("\nHere is the data set:\n");   
    for (i=0; i<ROWS; i++) {
        printf("\n %2d ", i+1);
        for (j=0; j<COLS; j++)
            printf("%5.0f", data[i][j]);
    }
    printf("\n");

	dimsizes[0]=ROWS;
	dimsizes[1]=COLS;

    DFSDsetdims(2,dimsizes);

    /* write out scientific data set in slices */
    DFSDstartslice(argv[1]);

    printf("\nNow writing out the slices.\n\n");
    printf("First slice: (1,1) to (2,12)\n");
    windims[0]=2; windims[1]=12;        /* {(1,1) to (2,12)} */
    ret = DFSDputslice(windims, &data[0][0], dimsizes);
    checkerror(ret, "DFSDputslice");

    printf(" Next slice: (3,1) to (6,12)\n");
    windims[0]=4; windims[1]=12;        /* {(3,1) to (6,12)} */
    ret = DFSDputslice(windims, &data[2][0], dimsizes);
    checkerror(ret, "DFSDputslice");

    printf("  Next slice: (7,1) to (7,4)\n");
    windims[0]=1; windims[1]=4;        /* {(7,1) to (7,4)} */
    ret = DFSDputslice(windims, &data[6][0], dimsizes);
    checkerror(ret, "DFSDputslice");

    printf("   Next slice: (7,5) to (7,12)\n");
    windims[0]=1; windims[1]=8;        /* {(7,5) to (7,12)} */
    ret = DFSDputslice(windims, &data[6][4], dimsizes);
    checkerror(ret, "DFSDputslice");

    printf("    Final slice: (8,1) to (10,12)\n");
    windims[0]=3; windims[1]=12;        /* {(8,1) to (10,12)} */
    ret = DFSDputslice(windims, &data[7][0], dimsizes);
    checkerror(ret, "DFSDputslice");

    ret = DFSDendslice();
    checkerror(ret, "DFSDendslice");

    printf("\nNow reading the data set back in.\nHere it is:\n");
    ret = DFSDgetdata(argv[1], 2, dimsizes, indata);
    for (i=0; i<ROWS; i++) {
        printf("\n %2d ", i+1);
        for (j=0; j<COLS; j++)
            printf("%5.0f", indata[i][j]);
    }
    printf("\n");

}


checkerror(ret, name)
int ret;
char *name;
{
    if ( ret != 0) {
        printf("\nError calling routine %s\n", name);
        printf("ret = %d;   DFerror = %d\n\n", ret, DFerror);
    }
}




