C
C $Header: /pita/work/HDF/dev/RCS/test/annotations/get1anF.f,v 1.1 90/06/26 16:49:29 mfolk beta $
C
C $Log:	get1anF.f,v $
c Revision 1.1  90/06/26  16:49:29  mfolk
c Initial revision
c 
C
      program get1an

C Program to test routines for finding and reading label and description
C
C An HDF file called 'o2' must already exist with at least two SDSs
C in it and both a label and description annotation corresponding 
C to the second SDS.
C
C Mike Folk  9/12/90
C
C****||************************************************************

      integer DFopen, DFclose
      integer dfindnr, daglab, dagdesc, dagdlen
      integer desclen, ref, ret, dfile
      integer DFACC_READ, DFTAG_SDG
      character*20  label, filename
      character*400 desc
	
      parameter (DFACC_READ  =   1,
     $           DFTAG_SDG   = 700 )

      print *, 'Enter HDF file name.  The HDF file should contain two'
      print *, 'SDSs with a label and description for the second one.'
      print *, 'File name: '
      read *, filename
      
      dfile = DFopen(filename, DFACC_READ, -1)
  
C****||******** find ref of second SDS in file ****************
      ref = 0
      ref = dfindnr(dfile, DFTAG_SDG, ref)
      ref = dfindnr(dfile, DFTAG_SDG, ref)
      if (ref .lt. 0) 
     *  call fatalerror('Unable to find second scientific data set.')

      ret = DFclose(dfile)
  
C****||******** get label, then description ****************
      ret = daglab(filename, DFTAG_SDG, ref, label, 11)
      if (ret .lt. 0) print *, 'No label'
      if (ret .ge. 0) print *,'Label: ', label

      desclen = dagdlen(filename, DFTAG_SDG, ref)
      if (desclen .gt. 400) 
     $    call fatalerror('Description too long. Greater than 400.')
      if (desclen .lt. 0) 
     $    call fatalerror('Error reading description length.')

  	  ret = dagdesc(filename, DFTAG_SDG, ref, desc, desclen)
      if (ret .lt. 0) 
     $    call fatalerror('Error reading description.')
      print *,'Description: '
      print *, desc
  
      stop
      end

C************************************************************
* fatalerror: subroutine to report fatal error and abort
*
C****||***********************************************************

      subroutine fatalerror(s)
      character*(*) s

      print *, s
      print *, 'DFerror:', DFerrno()
      print *, 'Program aborted.'
      print *, ' '
      stop
      end

