      SUBROUTINE BTRIX (JS, JE, LS, LE, K)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     VECTORIZED BLOCK TRI-DIAGONAL SOLVER IN THE J DIRECTION
C          FOR K = CONSTANT PLANES
C
C   11/15/84  D H BAILEY  MODIFIED FOR NAS KERNEL TEST
C
      PARAMETER (JD=30, KD=30, LD=30, MD=30)
      COMMON /ARRAYS/ S(JD,KD,LD,5), A(5,5,MD,MD), B(5,5,MD,MD),
     $     C(5,5,MD,MD)
C
      DIMENSION    U12(MD), U13(MD), U14(MD), U15(MD), U23(MD),
     $             U24(MD), U25(MD), U34(MD), U35(MD), U45(MD)
C
      DOUBLE PRECISION    
     $     L11(MD), L21(MD), L31(MD), L41(MD), L51(MD),
     $     L22(MD), L32(MD), L42(MD), L52(MD), L33(MD),
     $     L43(MD), L53(MD), L44(MD), L54(MD), L55(MD)
C
C     PART 1.  FORWARD BLOCK SWEEP
C
C
      DO 100 J   = JS,JE
C
C**********   STEP 1.  CONSTRUCT L(I) IN B    **************************
C
      IF(J.EQ.JS) GO TO 4
      DO 3 M = 1,5
        DO 3 N = 1,5
          DO 3 L = LS,LE
            B(M,N,J,L) = B(M,N,J,L) - A(M,1,J,L)*B(1,N,J-1,L)
     $           - A(M,2,J,L)*B(2,N,J-1,L) - A(M,3,J,L)*B(3,N,J-1,L)
     $           - A(M,4,J,L)*B(4,N,J-1,L) - A(M,5,J,L)*B(5,N,J-1,L)
    3 CONTINUE
C
    4 CONTINUE
C
C**********    STEP 2.  CONPUTE L INVERSE    ***************************
C
C
C        A.  DECOMPOSE L(I) INTO L AND U
C
      DO 20 L = LS,LE
        L11(L)  = 1. / B(1,1,J,L)
        U12(L)  = B(1,2,J,L)*L11(L)
        U13(L)  = B(1,3,J,L)*L11(L)
        U14(L)  = B(1,4,J,L)*L11(L)
        U15(L)  = B(1,5,J,L)*L11(L)
        L21(L)  = B(2,1,J,L)
        L22(L)  = 1. / (B(2,2,J,L) - L21(L)*U12(L))
        U23(L)  = (B(2,3,J,L) - L21(L)*U13(L)) * L22(L)
        U24(L)  = (B(2,4,J,L) - L21(L)*U14(L)) * L22(L)
        U25(L)  = (B(2,5,J,L) - L21(L)*U15(L)) * L22(L)
        L31(L)  = B(3,1,J,L)
        L32(L)  = B(3,2,J,L) - L31(L)*U12(L)
        L33(L)  = 1. / (B(3,3,J,L) - L31(L)*U13(L) - L32(L)*U23(L))
        U34(L)  = (B(3,4,J,L) - L31(L)*U14(L) - L32(L)*U24(L)) * L33(L)
        U35(L)  = (B(3,5,J,L) - L31(L)*U15(L) - L32(L)*U25(L)) * L33(L)
   20 CONTINUE
C
      DO 25 L = LS,LE
        L41(L)  = B(4,1,J,L)
        L42(L)  = B(4,2,J,L) - L41(L)*U12(L)
        L43(L)  = B(4,3,J,L) - L41(L)*U13(L) - L42(L)*U23(L)
        L44(L)  = 1. / (B(4,4,J,L) - L41(L)*U14(L) - L42(L)*U24(L)
     $      - L43(L)*U34(L))
        U45(L)  = (B(4,5,J,L) - L41(L)*U15(L) - L42(L)*U25(L)
     $      - L43(L)*U35(L)) * L44(L)
        L51(L)  = B(5,1,J,L)
        L52(L)  = B(5,2,J,L) - L51(L)*U12(L)
        L53(L)  = B(5,3,J,L) - L51(L)*U13(L) - L52(L)*U23(L)
        L54(L)  = B(5,4,J,L) - L51(L)*U14(L) - L52(L)*U24(L)
     $      - L53(L)*U34(L)
        L55(L)  = 1. / (B(5,5,J,L) - L51(L)*U15(L) - L52(L)*U25(L)
     $      - L53(L)*U35(L) - L54(L)*U45(L))
   25 CONTINUE
C
C**********    STEP 3.  SOLVE FOR INTERMEDIATE VECTOR    ***************
C
C         A.  CONSTRUCT RHS
C
      IF(J.EQ.JS) GO TO 34
      DO 33 M = 1,5
        DO 33 L = LS,LE
          S(J,K,L,M) = S(J,K,L,M) - A(M,1,J,L)*S(J-1,K,L,1)
     $         - A(M,2,J,L)*S(J-1,K,L,2) - A(M,3,J,L)*S(J-1,K,L,3)
     $         - A(M,4,J,L)*S(J-1,K,L,4) - A(M,5,J,L)*S(J-1,K,L,5)
   33 CONTINUE
C
C         B. INTERMEDIATE VECTOR
C
   34 CONTINUE
C
C         FWD SUBSTITUTION
C
      DO 35 L = LS,LE
        D1 = S(J,K,L,1)*L11(L)
        D2 = (S(J,K,L,2) - L21(L)*D1) * L22(L)
        D3 = (S(J,K,L,3) - L31(L)*D1 - L32(L)*D2) * L33(L)
        D4 = (S(J,K,L,4) - L41(L)*D1 - L42(L)*D2 - L43(L)*D3) * L44(L)
        D5 = (S(J,K,L,5) - L51(L)*D1 - L52(L)*D2 - L53(L)*D3
     $       - L54(L)*D4) * L55(L)
C
C         BWD SUBSTITUTION
C
        S(J,K,L,5)  = D5
        S(J,K,L,4)  = D4 - U45(L)*D5
        S(J,K,L,3)  = D3 - U34(L)*S(J,K,L,4) - U35(L)*D5
        S(J,K,L,2)  = D2 - U23(L)*S(J,K,L,3) - U24(L)*S(J,K,L,4)
     $       - U25(L)*D5
        S(J,K,L,1)  = D1 - U12(L)*S(J,K,L,2) - U13(L)*S(J,K,L,3)
     $       - U14(L)*S(J,K,L,4) - U15(L)*D5
   35 CONTINUE
C
C**********    STEP 4.  CONSTRUCT U(I) = L(I)**(-1)*C(I+1)    **********
C**********             BY COLUMNS AND STORE IN B            **********
C
      IF(J.EQ.JE) GO TO 100
      DO 40 N = 1,5
        DO 40 L = LS,LE
C
C         FWD SUBSTITUTION
C
          C1 = C(1,N,J,L)*L11(L)
          C2 = (C(2,N,J,L) - L21(L)*C1) * L22(L)
          C3 = (C(3,N,J,L) - L31(L)*C1 - L32(L)*C2) * L33(L)
          C4 = (C(4,N,J,L) - L41(L)*C1 - L42(L)*C2 - L43(L)*C3)
     $          * L44(L)
          C5 = (C(5,N,J,L) - L51(L)*C1 - L52(L)*C2 - L53(L)*C3
     $          - L54(L)*C4) * L55(L)
C
C         BWD SUBSTITUTION
C
          B(5,N,J,L)  = C5
          B(4,N,J,L)  = C4 - U45(L)*C5
          B(3,N,J,L)  = C3 - U34(L)*B(4,N,J,L) - U35(L)*C5
          B(2,N,J,L)  = C2 - U23(L)*B(3,N,J,L) - U24(L)*B(4,N,J,L)
     $         - U25(L)*C5
          B(1,N,J,L)  = C1 - U12(L)*B(2,N,J,L) - U13(L)*B(3,N,J,L)
     $         - U14(L)*B(4,N,J,L) - U15(L)*C5
   40 CONTINUE
C
C
  100 CONTINUE
C
C     PART 2.  BACKWARD BLOCK SWEEP
C
      JEM1 = JE - 1
C
      DO 200 J = JEM1,JS,-1
        DO 200 M = 1,5
          DO 200 L = LS,LE
            S(J,K,L,M) = S(J,K,L,M) - B(M,1,J,L)*S(J+1,K,L,1)
     $           - B(M,2,J,L)*S(J+1,K,L,2) - B(M,3,J,L)*S(J+1,K,L,3)
     $           - B(M,4,J,L)*S(J+1,K,L,4) - B(M,5,J,L)*S(J+1,K,L,5)
  200 CONTINUE
C
      RETURN
      END
