      SUBROUTINE INPARS

      IMPLICIT CHARACTER ( A-Z )

      COMMON/ATOMS/NATM
      COMMON/STEPS/DT
      COMMON/CUTOFF/RCUT
      COMMON/LJPAR/SIGMA
      COMMON/TEMPER/EQTEMP
      COMMON/ESHIFT/VRCUT,DVRCUT,DVRC12
      COMMON/LSTDAT/LIST,HEAD,MAP
      COMMON/LSTDT2/SFX,SFY,SFZ,CELLIX,CELLIY,CELLIZ,MX,MY,MZ
      COMMON/CONTRL/NSTEP,NEQUIL,ISAVE

C    *******************************************************************
C    ** SUBROUTINE TO READ IN L-J PARAMETERS, INITIALISE COUNTERS ETC **
C    *******************************************************************

      INTEGER     NMAX, MMX, MMY, MMZ, NCELL, MAPSIZ
      PARAMETER ( NMAX = 60000 )
      PARAMETER ( MMX=50, MMY=50, MMZ=50, NCELL=MMX*MMY*MMZ )
      PARAMETER ( MAPSIZ = 13*NCELL )

      REAL         DT, RCUT, SIGMA, EQTEMP
      REAL         SR6,VRCUT,DVRCUT,DVRC12
      REAL         SFX,SFY,SFZ,CELLIX,CELLIY,CELLIZ

      INTEGER      HEAD(NCELL), LIST(NMAX), MAP(MAPSIZ),MX,MY,MZ
      INTEGER      NATM
      INTEGER      NSTEP,NEQUIL,ISAVE

C**   CALCULATE DIMENSIONS OF PROCESSORS LINK-CELL STRUCTURE

      MX    = MIN(MMX,INT(1.0/RCUT)+2)
      MY    = MIN(MMY,INT(1.0/RCUT)+2)
      MZ    = MIN(MMZ,INT(1.0/RCUT)+2)

C**   CALCULATE SCALE FACTORS TO ENSURE EDGE CELLS ARE INCLUDED
C**   IN LINKED LIST

      SFX = (REAL(MX)-2.)/REAL(MX)
      SFY = (REAL(MY)-2.)/REAL(MY)
      SFZ = (REAL(MZ)-2.)/REAL(MZ)

C**   REAL VALUES OF NUMBER OF CELLS IN EACH COORDINATE DIRECTION

      CELLIX = REAL(MX)
      CELLIY = REAL(MY)
      CELLIZ = REAL(MZ)

C**   CALL SUBROUTINE TO CALCULATE NEIGHBOUR LIST OF NEIGHBOURING
C**   CELLS THAT WE WISH TO CONSIDER IN FORCE LOOP

      CALL MAPS

C**   CALCULATE VALUES FOR SHIFTED FORCE POTENTIAL

      SR6    = (SIGMA/RCUT)**6
      VRCUT  = SR6*(SR6-1.0)
      DVRCUT = -1.0*SR6*(SR6-0.5)/RCUT
      DVRC12 = 12.0*DVRCUT

      RETURN
      END
