      SUBROUTINE INITIA(JDIM,KDIM,Q,PRESS,SNDSP,S,XY,XYJ,
     *                  XIT,ETT,DS,X,Y,SLOPE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON/BASE/
     1  JMAX,       KMAX,     JM,          KM,          JBEGIN,   JEND,
     1  KBEGIN,     KEND,     JPLUS(999),  JMINU (999), JLOW,     JUP,
     1  KLOW,       KUP,      PERIDC  ,    NP,          DT,   CP2TIM,
     1  FSMACH,     ALPHA,    GAMMA,       GAMI,        PI,
     1  DIS2X,      DIS2Y,    DIS4X,       DIS4Y,       PHIDT,    
     1  THETAD ,    RESID,    JACDT,       IPRINT,      NPCP,
     1  JTAIL1,     JTAIL2,   NUMITE ,     ISTART,      NSTEPS
      LOGICAL PERIDC  
      COMMON/GRID/DYM,YMAX,XMIN,XMAX,THICK
C
      DIMENSION Q(JDIM,KDIM,4)
      DIMENSION PRESS(JDIM,KDIM),SNDSP(JDIM,KDIM)
      DIMENSION S(JDIM,KDIM,4),XY(JDIM,KDIM,4),XYJ(JDIM,KDIM)
      DIMENSION XIT(JDIM,KDIM),ETT(JDIM,KDIM),DS(JDIM,KDIM)
      DIMENSION X(JDIM,KDIM),Y(JDIM,KDIM),SLOPE(JDIM)
      COMMON/INFNTY/RHOINF,UINF,VINF,EINF,PINF
C
C
C               COMPUTE VARIOUS CONSTANTS
C
      GAMMA = 1.4
      GAMI = GAMMA -1.
      PI = 4.*ATAN(1.0)
C
      COSANG = COS( PI*ALPHA/180.)
      SINANG = SIN(PI*ALPHA/180.)
      RHOINF = 1.
      UINF   = FSMACH*COSANG
      VINF   = FSMACH*SINANG
      EINF   = 1./(GAMMA*GAMI) + .5*FSMACH**2
      PINF   = 1./GAMMA
C
C              GRID CALCULATION
C
      CALL BICONG(JDIM,KDIM,JMAX,KMAX,JTAIL1,JTAIL2,DYM,THICK,
     1 YMAX,XMAX,XMIN,X,Y)
C
C                INITIALIZE TO FREE STREAM
C
C                LOAD FREE STREAM AT ANGLE OF ATTACK ALPHA
C
      DO 32 K=1,KMAX
      DO 32 J=1,JMAX
         Q(J,K,1) = RHOINF
         Q(J,K,2) = RHOINF*UINF
         Q(J,K,3) = RHOINF*VINF
         Q(J,K,4) = EINF
   32 CONTINUE
C
C
C  SET UP VARIABLES, INDECIES, AND COMPUTE METRICS
C
C
C  JTAIL2 = JMAX  FOR PERIDC   MESHES
C
      IF(PERIDC  )JTAIL2 = JMAX
C
C            SET PERIDC   INDEX
C
      JM = JMAX-1
      KM = KMAX-1
      JBEGIN = 1
      JEND = JMAX
      KBEGIN = 1
      KEND = KMAX
      KLOW = 2
      KUP = KM
      DO 10 J = 1, JMAX
         JPLUS(J) = J+1
         JMINU (J) = J-1
10    CONTINUE
C
      IF ( .NOT.PERIDC    ) THEN
         JPLUS(JMAX) = JMAX
         JMINU (1) = 1
         JLOW = 2
         JUP = JMAX-1
      ELSE
         JPLUS(JMAX) = 1
         JMINU (1) = JMAX
         JLOW = 1
         JUP = JMAX
         JTAIL1 = 1
         JTAIL2 = JMAX
      ENDIF
C
      DO 8 K=1,KMAX
      DO 8 J=1,JMAX
         XIT(J,K) = 0.
         ETT(J,K) = 0.
8     CONTINUE
C
C
C                METRIC CALCULATION
C   S USED FOR WORK SPACE HERE
C
      CALL XYMETS(JDIM,KDIM,X,Y,XY,XIT,ETT,XYJ,S)
C
      DO 9 N=1,4
      DO 9 K=1,KMAX
      DO 9 J=1,JMAX
         S(J,K,N) = 0.
9     CONTINUE
C
C               INITIALIZE VARIABLE TIME STEP IF JACDT=1
C
      FACTOR=1.0
      IF(JACDT.EQ.0) FACTOR=0.0
      DO 65 K=1,KMAX
      DO 65 J=1,JMAX
         DS(J,K)=1.0/(1.0+FACTOR*SQRT(XYJ(J,K)))
   65 CONTINUE
C
C
C               SCALE VARIABLES BY JACOBIAN STORED BY XYMETS IN XYJ(J,K)
C
      DO 50 N=1,4
      DO 50 K=1,KMAX
      DO 50 J=1,JMAX
       Q(J,K,N) = Q(J,K,N)/XYJ(J,K)
   50 CONTINUE
C
C
C  AIRFOIL BODY SLOPE
C
C    USED ONLY IF RUNNING THE BICONVEX AIRFOIL
C
      DO 22 J = 1,JMAX
         SLOPE(J) = 0.0
22    CONTINUE
C
      DO 24 J = JTAIL1,JTAIL2
         XPT = X( J, 1)
         DGDX = 2. * THICK * ( 1. - 2. * XPT )
         SLOPE( J) = ATAN( DGDX)
24    CONTINUE
      DO 26 J = 1,JMAX
         WRITE(*, 25) J, SLOPE(J)
  25     FORMAT(1H ,'****J,SLOPE',I5,2X,E20.8)
  26  CONTINUE
C
C   INITIALIZE PRESS,SNDSP
C
      CALL CALCPS(JDIM,KDIM,Q,PRESS,SNDSP)
C
      RETURN
      END
